/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.server;

import com.mbed.coap.client.CoapClient;
import com.mbed.coap.packet.BlockSize;
import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.CoapTcpPacketConverter;
import com.mbed.coap.packet.Code;
import com.mbed.coap.server.CoapServer;
import com.mbed.coap.server.CriticalOptionVerifier;
import com.mbed.coap.server.NotificationValidator;
import com.mbed.coap.server.ObservationHandler;
import com.mbed.coap.server.ObserveRequestFilter;
import com.mbed.coap.server.RescueFilter;
import com.mbed.coap.server.RouterService;
import com.mbed.coap.server.block.BlockWiseIncomingFilter;
import com.mbed.coap.server.block.BlockWiseNotificationFilter;
import com.mbed.coap.server.block.BlockWiseOutgoingFilter;
import com.mbed.coap.server.filter.CongestionControlFilter;
import com.mbed.coap.server.messaging.Capabilities;
import com.mbed.coap.server.messaging.CapabilitiesResolver;
import com.mbed.coap.server.messaging.CapabilitiesStorage;
import com.mbed.coap.server.messaging.CapabilitiesStorageImpl;
import com.mbed.coap.server.messaging.CoapTcpDispatcher;
import com.mbed.coap.server.messaging.PayloadSizeVerifier;
import com.mbed.coap.server.messaging.TcpExchangeFilter;
import com.mbed.coap.server.observe.NotificationsReceiver;
import com.mbed.coap.server.observe.ObservationsStore;
import com.mbed.coap.transport.CoapTcpTransport;
import com.mbed.coap.transport.CoapTransport;
import com.mbed.coap.utils.Filter;
import com.mbed.coap.utils.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.Function;

public class CoapServerBuilderForTcp {
    private CoapTcpTransport coapTransport;
    private Service<CoapRequest, CoapResponse> route = RouterService.NOT_FOUND_SERVICE;
    private int maxMessageSize = 1152;
    private CapabilitiesStorage csmStorage;
    private int maxIncomingBlockTransferSize = 10000000;
    private int maxQueueSize = 100;
    private BlockSize blockSize;
    private Filter.SimpleFilter<CoapRequest, CoapResponse> outboundFilter = Filter.identity();
    private Filter.SimpleFilter<CoapRequest, CoapResponse> routeFilter = Filter.identity();
    private NotificationsReceiver notificationsReceiver = NotificationsReceiver.REJECT_ALL;
    private ObservationsStore observationsStore = ObservationsStore.ALWAYS_EMPTY;

    CoapServerBuilderForTcp() {
        this.csmStorage = new CapabilitiesStorageImpl();
    }

    private CapabilitiesStorage capabilities() {
        return this.csmStorage;
    }

    public final CoapServerBuilderForTcp blockSize(BlockSize blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public CoapServerBuilderForTcp transport(CoapTcpTransport coapTransport) {
        this.coapTransport = Objects.requireNonNull(coapTransport);
        return this;
    }

    public CoapServerBuilderForTcp route(Service<CoapRequest, CoapResponse> route) {
        this.route = route;
        return this;
    }

    public CoapServerBuilderForTcp route(RouterService.RouteBuilder routeBuilder) {
        return this.route((Service<CoapRequest, CoapResponse>)routeBuilder.build());
    }

    public CoapServerBuilderForTcp routeFilter(Filter.SimpleFilter<CoapRequest, CoapResponse> routeFilter) {
        this.routeFilter = Objects.requireNonNull(routeFilter);
        return this;
    }

    public CoapServerBuilderForTcp csmStorage(CapabilitiesStorage csmStorage) {
        this.csmStorage = csmStorage;
        return this;
    }

    public CoapServerBuilderForTcp maxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public CoapServerBuilderForTcp maxIncomingBlockTransferSize(int size) {
        this.maxIncomingBlockTransferSize = size;
        return this;
    }

    public CoapServerBuilderForTcp queueMaxSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public CoapServerBuilderForTcp outboundFilter(Filter.SimpleFilter<CoapRequest, CoapResponse> outboundFilter) {
        this.outboundFilter = outboundFilter;
        return this;
    }

    public CoapServerBuilderForTcp notificationsReceiver(NotificationsReceiver notificationsReceiver) {
        this.notificationsReceiver = Objects.requireNonNull(notificationsReceiver);
        if (this.observationsStore.equals(ObservationsStore.ALWAYS_EMPTY)) {
            return this.observationsStore(ObservationsStore.inMemory());
        }
        return this;
    }

    public CoapServerBuilderForTcp observationsStore(ObservationsStore observationsStore) {
        this.observationsStore = Objects.requireNonNull(observationsStore);
        return this;
    }

    public CoapClient buildClient(InetSocketAddress target) throws IOException {
        return CoapClient.create((InetSocketAddress)target, (CoapServer)this.build().start(), r -> r.getCode() == Code.C703_PONG);
    }

    public CoapServer build() {
        Service sender = packet -> this.coapTransport.sendPacket((CoapPacket)packet).whenComplete((__, throwable) -> CoapTransport.logSent((CoapPacket)packet, (Throwable)throwable));
        Service sendNotification = new NotificationValidator().andThen((Filter)new BlockWiseNotificationFilter((CapabilitiesResolver)this.capabilities())).andThenMap(CoapTcpPacketConverter::toCoapPacket).andThen(new PayloadSizeVerifier(this.csmStorage)).then(sender);
        Service inboundService = new RescueFilter().andThenIf(this.hasRoute(), (Filter)new CriticalOptionVerifier()).andThenIf(this.hasRoute(), (Filter)new BlockWiseIncomingFilter((CapabilitiesResolver)this.capabilities(), this.maxIncomingBlockTransferSize)).andThen(this.routeFilter).then(this.route);
        TcpExchangeFilter exchangeFilter = new TcpExchangeFilter();
        Service outboundService = this.outboundFilter.andThen((Filter)new ObserveRequestFilter(arg_0 -> ((ObservationsStore)this.observationsStore).add(arg_0))).andThen((Filter)new CongestionControlFilter(this.maxQueueSize, CoapRequest::getPeerAddress)).andThen((Filter)new BlockWiseOutgoingFilter((CapabilitiesResolver)this.capabilities(), this.maxIncomingBlockTransferSize)).andThen((Filter)exchangeFilter).andThenMap(CoapTcpPacketConverter::toCoapPacket).then(sender);
        Function inboundObservation = new ObservationHandler(this.notificationsReceiver, this.observationsStore).andThen(it -> it.getNow(true));
        CoapTcpDispatcher dispatcher = new CoapTcpDispatcher((Service<CoapPacket, Boolean>)sender, this.csmStorage, new Capabilities((long)this.maxMessageSize, this.blockSize != null), (Service<CoapRequest, CoapResponse>)inboundService, exchangeFilter::handleResponse, inboundObservation);
        this.coapTransport.setListener(dispatcher);
        return new CoapServer((CoapTransport)this.coapTransport, dispatcher::handle, outboundService, sendNotification, Function::identity);
    }

    private boolean hasRoute() {
        return !Objects.equals(this.route, RouterService.NOT_FOUND_SERVICE);
    }
}

