/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.server.messaging;

import com.mbed.coap.server.messaging.Capabilities;
import com.mbed.coap.server.messaging.CapabilitiesStorage;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;

public class CapabilitiesStorageImpl
implements CapabilitiesStorage {
    final ConcurrentHashMap<InetSocketAddress, Capabilities> capabilitiesMap = new ConcurrentHashMap();
    private final Capabilities defaultCapability;

    public CapabilitiesStorageImpl(Capabilities defaultCapability) {
        this.defaultCapability = defaultCapability;
    }

    public CapabilitiesStorageImpl() {
        this(Capabilities.BASE);
    }

    @Override
    public void put(InetSocketAddress address, Capabilities newCapabilities) {
        if (Capabilities.BASE.equals((Object)newCapabilities)) {
            this.capabilitiesMap.remove(address);
        } else {
            this.capabilitiesMap.put(address, newCapabilities);
        }
    }

    public Capabilities getOrDefault(InetSocketAddress address) {
        return this.capabilitiesMap.getOrDefault(address, this.defaultCapability);
    }

    @Override
    public void remove(InetSocketAddress address) {
        this.capabilitiesMap.remove(address);
    }
}

