/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.server.messaging;

import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.HeaderOptions;
import com.mbed.coap.packet.Opaque;
import com.mbed.coap.packet.SeparateResponse;
import com.mbed.coap.packet.SignalingOptions;
import com.mbed.coap.packet.SignallingHeaderOptions;
import com.mbed.coap.server.messaging.Capabilities;
import com.mbed.coap.server.messaging.CapabilitiesStorage;
import com.mbed.coap.transport.CoapTcpListener;
import com.mbed.coap.transport.CoapTransport;
import com.mbed.coap.utils.FutureHelpers;
import com.mbed.coap.utils.Service;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapTcpDispatcher
implements CoapTcpListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapTcpDispatcher.class);
    private final CapabilitiesStorage csmStorage;
    private final Capabilities ownCapability;
    private final Service<CoapPacket, Boolean> sender;
    private final Service<CoapRequest, CoapResponse> inboundService;
    private final Function<SeparateResponse, Boolean> outboundHandler;
    private final Function<SeparateResponse, Boolean> observationHandler;

    public CoapTcpDispatcher(Service<CoapPacket, Boolean> sender, CapabilitiesStorage csmStorage, Capabilities ownCapability, Service<CoapRequest, CoapResponse> inboundService, Function<SeparateResponse, Boolean> outboundHandler, Function<SeparateResponse, Boolean> observationHandler) {
        this.csmStorage = csmStorage;
        this.ownCapability = ownCapability;
        this.sender = sender;
        this.inboundService = inboundService;
        this.outboundHandler = outboundHandler;
        this.observationHandler = observationHandler;
    }

    public void handle(CoapPacket packet) {
        CoapTransport.logReceived((CoapPacket)packet);
        if (packet.getCode() == null && packet.getMethod() == null) {
            return;
        }
        if (packet.getCode() != null && packet.getCode().isSignaling() && packet.getCode() != Code.C703_PONG) {
            this.onSignal(packet);
            return;
        }
        if (packet.getMethod() != null) {
            ((CompletableFuture)((CompletableFuture)this.inboundService.apply((Object)packet.toCoapRequest())).thenAccept(resp -> {
                CompletableFuture cfr_ignored_0 = (CompletableFuture)this.sender.apply((Object)packet.createResponseFrom(resp));
            })).exceptionally(FutureHelpers.logError((Logger)LOGGER));
            return;
        }
        if (packet.getCode() != null) {
            SeparateResponse resp2 = packet.toCoapResponse().toSeparate(packet.getToken(), packet.getRemoteAddress(), packet.getTransportContext());
            if (this.outboundHandler.apply(resp2).booleanValue()) {
                return;
            }
            if (packet.headers().getObserve() != null && this.observationHandler.apply(resp2).booleanValue()) {
                return;
            }
        }
        LOGGER.warn("Can not process CoAP message [{}]", (Object)packet);
    }

    private void onSignal(CoapPacket packet) {
        if (packet.getCode() == Code.C701_CSM) {
            SignalingOptions signalingOpts = ((SignallingHeaderOptions)packet.headers()).toSignallingOptions(packet.getCode());
            Capabilities remoteCapabilities = Capabilities.BASE;
            if (signalingOpts != null) {
                Long maxMessageSize = signalingOpts.getMaxMessageSize();
                Boolean blockWiseTransferBERT = signalingOpts.getBlockWiseTransfer();
                remoteCapabilities = Capabilities.BASE.withNewOptions(maxMessageSize, blockWiseTransferBERT);
            }
            this.csmStorage.put(packet.getRemoteAddress(), Capabilities.min((Capabilities)this.ownCapability, (Capabilities)remoteCapabilities));
        } else if (packet.getCode() == Code.C702_PING) {
            CoapPacket pongResp = new CoapPacket(packet.getRemoteAddress());
            pongResp.setCode(Code.C703_PONG);
            pongResp.setToken(packet.getToken());
            this.sender.apply((Object)pongResp);
        } else if (packet.getCode() == Code.C705_ABORT) {
            this.removeConnection(packet.toCoapResponse().toSeparate(packet.getToken(), packet.getRemoteAddress()));
        } else {
            LOGGER.debug("[{}] Ignored signal message: {}", (Object)packet.getRemoteAddrString(), (Object)packet.getCode());
        }
    }

    @Override
    public void onConnected(InetSocketAddress remoteAddress) {
        CoapPacket packet = new CoapPacket(remoteAddress);
        packet.setMessageType(null);
        packet.setCode(Code.C701_CSM);
        SignallingHeaderOptions headers = new SignallingHeaderOptions(packet.getCode());
        headers.putSignallingOptions(SignalingOptions.capabilities(this.ownCapability.getMaxMessageSizeInt(), this.ownCapability.isBlockTransferEnabled()));
        packet.setHeaderOptions((HeaderOptions)headers);
        this.sender.apply((Object)packet);
    }

    @Override
    public void onDisconnected(InetSocketAddress remoteAddress) {
        this.removeConnection(CoapResponse.of((Code)Code.C705_ABORT).toSeparate(Opaque.EMPTY, remoteAddress));
    }

    private void removeConnection(SeparateResponse abortResp) {
        this.csmStorage.remove(abortResp.getPeerAddress());
        this.outboundHandler.apply(abortResp);
        LOGGER.debug("[{}] Disconnected", (Object)abortResp.getPeerAddress());
    }
}

