/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.server.messaging;

import com.mbed.coap.exception.CoapException;
import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.server.messaging.CapabilitiesResolver;
import com.mbed.coap.utils.Filter;
import com.mbed.coap.utils.FutureHelpers;
import com.mbed.coap.utils.Service;
import java.util.concurrent.CompletableFuture;

public class PayloadSizeVerifier<T>
implements Filter.SimpleFilter<CoapPacket, T> {
    private final CapabilitiesResolver capabilitiesResolver;

    public PayloadSizeVerifier(CapabilitiesResolver capabilitiesResolver) {
        this.capabilitiesResolver = capabilitiesResolver;
    }

    public CompletableFuture<T> apply(CoapPacket packet, Service<CoapPacket, T> service) {
        if (this.verifyPayloadSize(packet)) {
            return FutureHelpers.failedFuture((Exception)((Object)new CoapException("Request payload size is too big and no block transfer support is enabled for " + packet.getRemoteAddress() + ": " + packet.getPayload().size())));
        }
        return (CompletableFuture)service.apply((Object)packet);
    }

    private boolean verifyPayloadSize(CoapPacket packet) {
        int maxMessageSize;
        int payloadLen = packet.getPayload().size();
        return payloadLen > (maxMessageSize = this.capabilitiesResolver.getOrDefault(packet.getRemoteAddress()).getMaxMessageSizeInt());
    }
}

