/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.server.messaging;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.SeparateResponse;
import com.mbed.coap.server.messaging.TransactionId;
import com.mbed.coap.utils.Filter;
import com.mbed.coap.utils.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TcpExchangeFilter
implements Filter<CoapRequest, CoapResponse, CoapRequest, Boolean> {
    private final ConcurrentMap<TransactionId, CompletableFuture<CoapResponse>> transactions = new ConcurrentHashMap<TransactionId, CompletableFuture<CoapResponse>>();

    public CompletableFuture<CoapResponse> apply(CoapRequest request, Service<CoapRequest, Boolean> service) {
        TransactionId tid = new TransactionId(request.getToken(), request.getPeerAddress());
        CompletableFuture<CoapResponse> promise = new CompletableFuture<CoapResponse>();
        this.transactions.put(tid, promise);
        CompletableFuture servicePromise = (CompletableFuture)service.apply((Object)request);
        servicePromise.whenComplete((resp, ex) -> {
            if (ex != null) {
                promise.completeExceptionally((Throwable)ex);
            }
        });
        promise.whenComplete((__, ex) -> {
            servicePromise.cancel(false);
            this.transactions.remove(tid, promise);
        });
        return promise;
    }

    public boolean handleResponse(SeparateResponse resp) {
        if (resp.getCode() == Code.C705_ABORT) {
            this.removeTransactions(resp.getPeerAddress());
            return true;
        }
        TransactionId tid = new TransactionId(resp.getToken(), resp.getPeerAddress());
        CompletableFuture promise = (CompletableFuture)this.transactions.remove(tid);
        if (promise != null) {
            return promise.complete(resp.asResponse());
        }
        return false;
    }

    private void removeTransactions(InetSocketAddress remoteAddress) {
        for (TransactionId transId : this.transactions.keySet()) {
            CompletableFuture promise;
            if (!transId.hasRemoteAddress(remoteAddress) || (promise = (CompletableFuture)this.transactions.remove(transId)) == null) continue;
            promise.completeExceptionally(new IOException("Socket closed"));
        }
    }

    public int transactions() {
        return this.transactions.size();
    }
}

