/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.transport.javassl;

import com.mbed.coap.transport.javassl.SocketClientTransport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketClientTransport
extends SocketClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLSocketClientTransport.class);

    public SSLSocketClientTransport(InetSocketAddress destination, SSLSocketFactory socketFactory, boolean autoReconnect) {
        super(destination, socketFactory, autoReconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect() throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.socketFactory.createSocket(this.destination.getAddress(), this.destination.getPort());
        sslSocket.addHandshakeCompletedListener(handshakeCompletedEvent -> {
            try {
                LOGGER.debug("Connected [{}, {}]", handshakeCompletedEvent.getSource(), (Object)((X509Certificate)sslSocket.getSession().getPeerCertificates()[0]).getSubjectX500Principal());
            }
            catch (SSLPeerUnverifiedException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            this.listener.onConnected((InetSocketAddress)this.socket.getRemoteSocketAddress());
        });
        sslSocket.startHandshake();
        this.socket = sslSocket;
        SSLSocketClientTransport sSLSocketClientTransport = this;
        synchronized (sSLSocketClientTransport) {
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        }
        this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 1024);
    }

    public SSLSocket getSslSocket() {
        return (SSLSocket)this.socket;
    }
}

