/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.transport.javassl;

import com.mbed.coap.exception.CoapException;
import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.packet.CoapTcpPacketSerializer;
import com.mbed.coap.transport.BlockingCoapTransport;
import com.mbed.coap.transport.CoapTcpListener;
import com.mbed.coap.transport.CoapTcpTransport;
import com.mbed.coap.utils.ExecutorHelpers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClientTransport
extends BlockingCoapTransport
implements CoapTcpTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketClientTransport.class);
    protected final InetSocketAddress destination;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected Socket socket;
    protected CoapTcpListener listener;
    private final ExecutorService readingWorker;
    protected final SocketFactory socketFactory;
    private final boolean autoReconnect;
    private volatile boolean isRunning;

    public SocketClientTransport(InetSocketAddress destination, SocketFactory socketFactory, boolean autoReconnect) {
        this(destination, socketFactory, autoReconnect, ExecutorHelpers.newSingleThreadExecutor((String)"client-reader"));
    }

    public SocketClientTransport(InetSocketAddress destination, SocketFactory socketFactory, boolean autoReconnect, ExecutorService readingWorker) {
        this.destination = destination;
        this.socketFactory = socketFactory;
        this.autoReconnect = autoReconnect;
        this.readingWorker = readingWorker;
    }

    public void start() throws IOException {
        this.isRunning = true;
        this.connect();
    }

    @Override
    public void setListener(CoapTcpListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() throws IOException {
        this.socket = this.socketFactory.createSocket(this.destination.getAddress(), this.destination.getPort());
        SocketClientTransport socketClientTransport = this;
        synchronized (socketClientTransport) {
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        }
        this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 2048);
        this.listener.onConnected((InetSocketAddress)this.socket.getRemoteSocketAddress());
    }

    public CompletableFuture<CoapPacket> receive() {
        return CompletableFuture.supplyAsync(this::read, this.readingWorker).thenCompose(it -> it == null ? this.receive() : CompletableFuture.completedFuture(it));
    }

    private CoapPacket read() {
        block10: {
            try {
                if (this.socket.isClosed() && this.autoReconnect && this.isRunning) {
                    this.waitBeforeReconnection();
                    LOGGER.debug("reconnecting to " + this.destination);
                    this.connect();
                }
                if (this.socket.isClosed()) break block10;
                try {
                    return CoapTcpPacketSerializer.deserialize((InetSocketAddress)this.socket.getRemoteSocketAddress(), this.inputStream);
                }
                catch (CoapException e) {
                    if (e.getCause() != null && e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    LOGGER.warn("Closing socket connection, due to parsing error: " + e.getMessage());
                    this.socket.close();
                }
                catch (EOFException ex) {
                    this.socket.close();
                }
            }
            catch (SocketTimeoutException ex) {
                return null;
            }
            catch (Exception ex) {
                if (ex.getMessage() != null && ex.getMessage().startsWith("Socket closed")) break block10;
                LOGGER.error(ex.toString());
            }
        }
        if (this.socket.isClosed()) {
            this.listener.onDisconnected(this.destination);
        }
        if (!this.autoReconnect && this.socket.isClosed()) {
            throw new CompletionException(new IOException("Socket closed"));
        }
        return null;
    }

    protected void waitBeforeReconnection() throws InterruptedException {
        Thread.sleep(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket0(CoapPacket coapPacket) throws CoapException, IOException {
        InetSocketAddress adr = coapPacket.getRemoteAddress();
        if (!adr.equals(this.destination)) {
            throw new IllegalStateException("No connection with: " + adr);
        }
        SocketClientTransport socketClientTransport = this;
        synchronized (socketClientTransport) {
            CoapTcpPacketSerializer.writeTo(this.outputStream, coapPacket);
            this.outputStream.flush();
        }
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    public void stop() {
        this.isRunning = false;
        try {
            this.listener.onDisconnected(this.destination);
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.readingWorker.shutdown();
        }
    }
}

