/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.netty.NettyExtensionsKt;
import org.opencoap.ssl.transport.DtlsSessionContext;
import org.opencoap.ssl.transport.Packet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/opencoap/ssl/netty/DatagramPacketWithContext;", "Lio/netty/channel/socket/DatagramPacket;", "data", "Lio/netty/buffer/ByteBuf;", "recipient", "Ljava/net/InetSocketAddress;", "sender", "sessionContext", "Lorg/opencoap/ssl/transport/DtlsSessionContext;", "(Lio/netty/buffer/ByteBuf;Ljava/net/InetSocketAddress;Ljava/net/InetSocketAddress;Lorg/opencoap/ssl/transport/DtlsSessionContext;)V", "getSessionContext", "()Lorg/opencoap/ssl/transport/DtlsSessionContext;", "Companion", "kotlin-mbedtls-netty"})
public final class DatagramPacketWithContext
extends DatagramPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DtlsSessionContext sessionContext;

    public DatagramPacketWithContext(@NotNull ByteBuf data, @Nullable InetSocketAddress recipient, @NotNull InetSocketAddress sender, @NotNull DtlsSessionContext sessionContext) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)sessionContext, (String)"sessionContext");
        super(data, recipient, sender);
        this.sessionContext = sessionContext;
    }

    @NotNull
    public final DtlsSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @JvmStatic
    @NotNull
    public static final DtlsSessionContext contextFrom(@NotNull DatagramPacket msg) {
        return Companion.contextFrom(msg);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f\u00a8\u0006\r"}, d2={"Lorg/opencoap/ssl/netty/DatagramPacketWithContext$Companion;", "", "()V", "contextFrom", "Lorg/opencoap/ssl/transport/DtlsSessionContext;", "msg", "Lio/netty/channel/socket/DatagramPacket;", "from", "Lorg/opencoap/ssl/netty/DatagramPacketWithContext;", "packet", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "kotlin-mbedtls-netty"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatagramPacketWithContext from(@NotNull Packet<ByteBuffer> packet) {
            Intrinsics.checkNotNullParameter(packet, (String)"packet");
            return new DatagramPacketWithContext(NettyExtensionsKt.toByteBuf((ByteBuffer)packet.getBuffer()), null, packet.getPeerAddress(), packet.getSessionContext());
        }

        @JvmStatic
        @NotNull
        public final DtlsSessionContext contextFrom(@NotNull DatagramPacket msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            return msg instanceof DatagramPacketWithContext ? ((DatagramPacketWithContext)msg).getSessionContext() : DtlsSessionContext.EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

