/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.netty.DatagramPacketWithContext;
import org.opencoap.ssl.netty.NettyExtensionsKt;
import org.opencoap.ssl.netty.SessionAuthenticationContext;
import org.opencoap.ssl.transport.DtlsServer;
import org.opencoap.ssl.transport.DtlsSessionLifecycleCallbacks;
import org.opencoap.ssl.transport.NoOpsSessionStore;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SessionStore;
import org.opencoap.ssl.transport.SessionWithContext;
import org.opencoap.ssl.transport.TransportOutbound;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020#0\"j\u0002`$H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/opencoap/ssl/netty/DtlsChannelHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "sslConfig", "Lorg/opencoap/ssl/SslConfig;", "expireAfter", "Ljava/time/Duration;", "sessionStore", "Lorg/opencoap/ssl/transport/SessionStore;", "lifecycleCallbacks", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;", "(Lorg/opencoap/ssl/SslConfig;Ljava/time/Duration;Lorg/opencoap/ssl/transport/SessionStore;Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;)V", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "dtlsServer", "Lorg/opencoap/ssl/transport/DtlsServer;", "getDtlsServer", "()Lorg/opencoap/ssl/transport/DtlsServer;", "setDtlsServer", "(Lorg/opencoap/ssl/transport/DtlsServer;)V", "channelRead", "", "msg", "", "handlerAdded", "loadSession", "result", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$CidSessionMissing;", "Lio/netty/channel/socket/DatagramPacket;", "write", "promise", "Lio/netty/channel/ChannelPromise;", "Ljava/util/concurrent/CompletableFuture;", "", "packet", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "kotlin-mbedtls-netty"})
@SourceDebugExtension(value={"SMAP\nDtlsChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsChannelHandler.kt\norg/opencoap/ssl/netty/DtlsChannelHandler\n+ 2 NettyExtensions.kt\norg/opencoap/ssl/netty/NettyExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,120:1\n62#2,6:121\n62#2,6:129\n215#3,2:127\n*S KotlinDebug\n*F\n+ 1 DtlsChannelHandler.kt\norg/opencoap/ssl/netty/DtlsChannelHandler\n*L\n64#1:121,6\n109#1:129,6\n94#1:127,2\n*E\n"})
public final class DtlsChannelHandler
extends ChannelDuplexHandler {
    @NotNull
    private final SslConfig sslConfig;
    @NotNull
    private final Duration expireAfter;
    @NotNull
    private final SessionStore sessionStore;
    @NotNull
    private final DtlsSessionLifecycleCallbacks lifecycleCallbacks;
    private ChannelHandlerContext ctx;
    public DtlsServer dtlsServer;

    @JvmOverloads
    public DtlsChannelHandler(@NotNull SslConfig sslConfig, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks) {
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
        Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
        Intrinsics.checkNotNullParameter((Object)lifecycleCallbacks, (String)"lifecycleCallbacks");
        this.sslConfig = sslConfig;
        this.expireAfter = expireAfter;
        this.sessionStore = sessionStore;
        this.lifecycleCallbacks = lifecycleCallbacks;
    }

    public /* synthetic */ DtlsChannelHandler(SslConfig sslConfig, Duration duration, SessionStore sessionStore, DtlsSessionLifecycleCallbacks dtlsSessionLifecycleCallbacks, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            sessionStore = (SessionStore)NoOpsSessionStore.INSTANCE;
        }
        if ((n & 8) != 0) {
            dtlsSessionLifecycleCallbacks = new DtlsSessionLifecycleCallbacks(){

                public void handshakeFinished(@NotNull InetSocketAddress adr, long hanshakeStartTimestamp, long hanshakeFinishTimestamp, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeFinished((DtlsSessionLifecycleCallbacks)this, (InetSocketAddress)adr, (long)hanshakeStartTimestamp, (long)hanshakeFinishTimestamp, (DtlsSessionLifecycleCallbacks.Reason)reason, (Throwable)throwable);
                }

                public void handshakeStarted(@NotNull InetSocketAddress adr) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeStarted((DtlsSessionLifecycleCallbacks)this, (InetSocketAddress)adr);
                }

                public void messageDropped(@NotNull InetSocketAddress adr) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.messageDropped((DtlsSessionLifecycleCallbacks)this, (InetSocketAddress)adr);
                }

                public void sessionFinished(@NotNull InetSocketAddress adr, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished((DtlsSessionLifecycleCallbacks)this, (InetSocketAddress)adr, (DtlsSessionLifecycleCallbacks.Reason)reason, (Throwable)throwable);
                }

                public void sessionStarted(@NotNull InetSocketAddress adr, @NotNull String cipherSuite, boolean reloaded) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.sessionStarted((DtlsSessionLifecycleCallbacks)this, (InetSocketAddress)adr, (String)cipherSuite, (boolean)reloaded);
                }
            };
        }
        this(sslConfig, duration, sessionStore, dtlsSessionLifecycleCallbacks);
    }

    @NotNull
    public final DtlsServer getDtlsServer() {
        DtlsServer dtlsServer = this.dtlsServer;
        if (dtlsServer != null) {
            return dtlsServer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dtlsServer");
        return null;
    }

    public final void setDtlsServer(@NotNull DtlsServer dtlsServer) {
        Intrinsics.checkNotNullParameter((Object)dtlsServer, (String)"<set-?>");
        this.dtlsServer = dtlsServer;
    }

    private final CompletableFuture<Boolean> write(Packet<ByteBuffer> packet) {
        DatagramPacket dtlsPacket = new DatagramPacket(NettyExtensionsKt.toByteBuf((ByteBuffer)packet.getBuffer()), packet.getPeerAddress());
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
            channelHandlerContext = null;
        }
        if (!channelHandlerContext.channel().isWritable()) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ChannelHandlerContext channelHandlerContext2 = this.ctx;
        if (channelHandlerContext2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
            channelHandlerContext2 = null;
        }
        ChannelFuture channelFuture = channelHandlerContext2.writeAndFlush((Object)dtlsPacket);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
        return NettyExtensionsKt.toCompletableFuture(channelFuture);
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        TransportOutbound transportOutbound = new TransportOutbound(this){
            final /* synthetic */ DtlsChannelHandler $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final CompletableFuture<Boolean> send(@NotNull Packet<ByteBuffer> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return DtlsChannelHandler.access$write(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)((Object)this.$tmp0), DtlsChannelHandler.class, "write", "write(Lorg/opencoap/ssl/transport/Packet;)Ljava/util/concurrent/CompletableFuture;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof TransportOutbound ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        };
        Function2 function2 = (Function2)new Function2<byte[], SessionWithContext, Unit>((Object)this.sessionStore){

            public final void invoke(@NotNull byte[] p0, @NotNull SessionWithContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((SessionStore)this.receiver).write(p0, p1);
            }
        };
        EventExecutor eventExecutor = ctx.executor();
        Intrinsics.checkNotNullExpressionValue((Object)eventExecutor, (String)"executor(...)");
        this.setDtlsServer(new DtlsServer(transportOutbound, this.sslConfig, this.expireAfter, function2, this.lifecycleCallbacks, (ScheduledExecutorService)eventExecutor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!(msg instanceof DatagramPacket)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ReferenceCounted $this$useAndRelease$iv = (ReferenceCounted)msg;
        boolean $i$f$useAndRelease = false;
        try {
            DtlsServer.ReceiveResult result;
            DatagramPacket it = (DatagramPacket)$this$useAndRelease$iv;
            boolean bl = false;
            DtlsServer dtlsServer = this.getDtlsServer();
            SocketAddress socketAddress = ((DatagramPacket)msg).sender();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"sender(...)");
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            ByteBuffer byteBuffer = ((ByteBuf)((DatagramPacket)msg).content()).nioBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
            DtlsServer.ReceiveResult receiveResult = result = dtlsServer.handleReceived(inetSocketAddress, byteBuffer);
            if (!(receiveResult instanceof DtlsServer.ReceiveResult.Handled) && !(receiveResult instanceof DtlsServer.ReceiveResult.DecryptFailed)) {
                if (receiveResult instanceof DtlsServer.ReceiveResult.Decrypted) {
                    ctx.fireChannelRead((Object)DatagramPacketWithContext.Companion.from((Packet<ByteBuffer>)((DtlsServer.ReceiveResult.Decrypted)result).getPacket()));
                } else if (receiveResult instanceof DtlsServer.ReceiveResult.CidSessionMissing) {
                    DtlsServer.ReceiveResult.CidSessionMissing cidSessionMissing = (DtlsServer.ReceiveResult.CidSessionMissing)result;
                    DatagramPacket datagramPacket = ((DatagramPacket)msg).retain();
                    Intrinsics.checkNotNullExpressionValue((Object)datagramPacket, (String)"retain(...)");
                    this.loadSession(cidSessionMissing, datagramPacket, ctx);
                }
            }
        }
        finally {
            $this$useAndRelease$iv.release();
        }
    }

    private final void loadSession(DtlsServer.ReceiveResult.CidSessionMissing result, DatagramPacket msg, ChannelHandlerContext ctx) {
        ((CompletableFuture)this.sessionStore.read(result.getCid()).thenApplyAsync(arg_0 -> DtlsChannelHandler.loadSession$lambda$1((Function1)new Function1<SessionWithContext, Boolean>(this, msg, result){
            final /* synthetic */ DtlsChannelHandler this$0;
            final /* synthetic */ DatagramPacket $msg;
            final /* synthetic */ DtlsServer.ReceiveResult.CidSessionMissing $result;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                this.$result = $result;
                super(1);
            }

            public final Boolean invoke(@Nullable SessionWithContext sessBuf) {
                DtlsServer dtlsServer = this.this$0.getDtlsServer();
                SocketAddress socketAddress = this.$msg.sender();
                Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"sender(...)");
                return dtlsServer.loadSession(sessBuf, (InetSocketAddress)socketAddress, this.$result.getCid());
            }
        }, arg_0), (Executor)ctx.executor())).whenComplete((arg_0, arg_1) -> DtlsChannelHandler.loadSession$lambda$2((Function2)new Function2<Boolean, Throwable, Unit>(this, ctx, msg){
            final /* synthetic */ DtlsChannelHandler this$0;
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ DatagramPacket $msg;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$msg = $msg;
                super(2);
            }

            public final void invoke(@Nullable Boolean isLoaded, Throwable throwable) {
                if (Intrinsics.areEqual((Object)isLoaded, (Object)true)) {
                    this.this$0.channelRead(this.$ctx, this.$msg);
                } else {
                    this.$msg.release();
                }
            }
        }, arg_0, arg_1));
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        Object object = msg;
        if (object instanceof DatagramPacket) {
            this.write((DatagramPacket)msg, promise, ctx);
        } else if (object instanceof SessionAuthenticationContext) {
            Map<String, String> $this$forEach$iv = ((SessionAuthenticationContext)msg).getMap();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                String value = entry.getValue();
                if (this.getDtlsServer().putSessionAuthenticationContext(((SessionAuthenticationContext)msg).getAdr(), key, value)) continue;
                promise.setFailure((Throwable)new SslException("Session does not exists"));
            }
            if (!promise.isDone()) {
                promise.setSuccess();
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(DatagramPacket msg, ChannelPromise promise, ChannelHandlerContext ctx) {
        ReferenceCounted $this$useAndRelease$iv = (ReferenceCounted)msg;
        boolean $i$f$useAndRelease = false;
        try {
            DatagramPacket it = (DatagramPacket)$this$useAndRelease$iv;
            boolean bl = false;
            ByteBuffer plainContent = ((ByteBuf)msg.content()).nioBuffer();
            DtlsServer dtlsServer = this.getDtlsServer();
            Intrinsics.checkNotNull((Object)plainContent);
            SocketAddress socketAddress = msg.recipient();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"recipient(...)");
            ByteBuffer encPacket = dtlsServer.encrypt(plainContent, (InetSocketAddress)socketAddress);
            if (encPacket == null) {
                promise.setFailure((Throwable)new Exception("Session not found"));
            } else {
                ctx.write((Object)new DatagramPacket(NettyExtensionsKt.toByteBuf(encPacket), (InetSocketAddress)msg.recipient()), promise);
            }
        }
        finally {
            $this$useAndRelease$iv.release();
        }
    }

    @JvmOverloads
    public DtlsChannelHandler(@NotNull SslConfig sslConfig, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore) {
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
        Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
        this(sslConfig, expireAfter, sessionStore, null, 8, null);
    }

    @JvmOverloads
    public DtlsChannelHandler(@NotNull SslConfig sslConfig, @NotNull Duration expireAfter) {
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
        this(sslConfig, expireAfter, null, null, 12, null);
    }

    @JvmOverloads
    public DtlsChannelHandler(@NotNull SslConfig sslConfig) {
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        this(sslConfig, null, null, null, 14, null);
    }

    private static final Boolean loadSession$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void loadSession$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ CompletableFuture access$write(DtlsChannelHandler $this, Packet packet) {
        return $this.write((Packet<ByteBuffer>)packet);
    }
}

