/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.SslSession;
import org.opencoap.ssl.netty.DtlsClientChannelHandler;
import org.opencoap.ssl.netty.NettyExtensionsKt;
import org.opencoap.ssl.transport.SessionWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opencoap/ssl/netty/DtlsClientChannelHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "sslSession", "Lorg/opencoap/ssl/SslSession;", "sessionWriter", "Lorg/opencoap/ssl/transport/SessionWriter;", "(Lorg/opencoap/ssl/SslSession;Lorg/opencoap/ssl/transport/SessionWriter;)V", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "channelRead", "", "msg", "", "close", "promise", "Lio/netty/channel/ChannelPromise;", "handlerAdded", "write", "kotlin-mbedtls-netty"})
@SourceDebugExtension(value={"SMAP\nDtlsClientChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsClientChannelHandler.kt\norg/opencoap/ssl/netty/DtlsClientChannelHandler\n+ 2 NettyExtensions.kt\norg/opencoap/ssl/netty/NettyExtensionsKt\n*L\n1#1,88:1\n62#2,6:89\n*S KotlinDebug\n*F\n+ 1 DtlsClientChannelHandler.kt\norg/opencoap/ssl/netty/DtlsClientChannelHandler\n*L\n80#1:89,6\n*E\n"})
public final class DtlsClientChannelHandler
extends ChannelDuplexHandler {
    @NotNull
    private final SslSession sslSession;
    @NotNull
    private final SessionWriter sessionWriter;
    private final Logger logger;
    private ChannelHandlerContext ctx;

    public DtlsClientChannelHandler(@NotNull SslSession sslSession, @NotNull SessionWriter sessionWriter) {
        Intrinsics.checkNotNullParameter((Object)sslSession, (String)"sslSession");
        Intrinsics.checkNotNullParameter((Object)sessionWriter, (String)"sessionWriter");
        this.sslSession = sslSession;
        this.sessionWriter = sessionWriter;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
    }

    public void close(@NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        try {
            byte[] cid = this.sslSession.getOwnCid();
            if (cid != null && !Intrinsics.areEqual((Object)this.sessionWriter, (Object)SessionWriter.NO_OPS)) {
                this.sessionWriter.invoke(cid, this.sslSession.saveAndClose());
            } else {
                this.sslSession.close();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Could not store session: {}", (Object)ex.toString());
        }
        ctx.close(promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!(msg instanceof DatagramPacket)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf plainContent = ctx.alloc().buffer(((ByteBuf)((DatagramPacket)msg).content()).readableBytes());
        try {
            Intrinsics.checkNotNull((Object)plainContent);
            NettyExtensionsKt.writeThroughNioBuffer(plainContent, (Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>(this, msg){
                final /* synthetic */ DtlsClientChannelHandler this$0;
                final /* synthetic */ Object $msg;
                {
                    this.this$0 = $receiver;
                    this.$msg = $msg;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SslSession sslSession = DtlsClientChannelHandler.access$getSslSession$p(this.this$0);
                    ByteBuffer byteBuffer = ((ByteBuf)((DatagramPacket)this.$msg).content()).nioBuffer();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
                    sslSession.decrypt(byteBuffer, it, (Function1)channelRead.1.INSTANCE);
                }
            }));
            if (plainContent.isReadable()) {
                ctx.fireChannelRead((Object)((DatagramPacket)msg).replace(plainContent.retain()));
            }
        }
        catch (SslException ex) {
            this.logger.warn("[{}], {}", (Object)((DatagramPacket)msg).sender(), (Object)ex.toString());
        }
        finally {
            plainContent.release();
            ((DatagramPacket)msg).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (!(msg instanceof DatagramPacket)) {
            ctx.write(msg, promise);
            return;
        }
        ReferenceCounted $this$useAndRelease$iv = (ReferenceCounted)msg;
        boolean $i$f$useAndRelease = false;
        try {
            DatagramPacket it = (DatagramPacket)$this$useAndRelease$iv;
            boolean bl = false;
            ByteBuf content = (ByteBuf)it.content();
            ByteBuffer byteBuffer = content.nioBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
            ByteBuffer dtlsPacket = this.sslSession.encrypt(byteBuffer);
            ctx.write((Object)((DatagramPacket)msg).replace(NettyExtensionsKt.toByteBuf(dtlsPacket)), promise);
        }
        finally {
            $this$useAndRelease$iv.release();
        }
    }

    public static final /* synthetic */ SslSession access$getSslSession$p(DtlsClientChannelHandler $this) {
        return $this.sslSession;
    }
}

