/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.SslContext;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.SslHandshakeContext;
import org.opencoap.ssl.SslSession;
import org.opencoap.ssl.netty.DtlsClientChannelHandler;
import org.opencoap.ssl.netty.NettyExtensionsKt;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SessionWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J \u0010\u001f\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/opencoap/ssl/netty/DtlsClientHandshakeChannelHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "sslHandshakeContext", "Lorg/opencoap/ssl/SslHandshakeContext;", "peerAddress", "Ljava/net/InetSocketAddress;", "sessionWriter", "Lorg/opencoap/ssl/transport/SessionWriter;", "(Lorg/opencoap/ssl/SslHandshakeContext;Ljava/net/InetSocketAddress;Lorg/opencoap/ssl/transport/SessionWriter;)V", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "outboundMessages", "", "Lkotlin/Pair;", "Lio/netty/channel/socket/DatagramPacket;", "Lio/netty/channel/ChannelPromise;", "scheduledRetransmission", "Lio/netty/util/concurrent/ScheduledFuture;", "channelActive", "", "channelRead", "msg", "", "close", "promise", "releaseOutboundMessages", "scheduleRetransmission", "stepAndSchedule", "write", "packet", "Ljava/nio/ByteBuffer;", "kotlin-mbedtls-netty"})
@SourceDebugExtension(value={"SMAP\nDtlsClientHandshakeChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsClientHandshakeChannelHandler.kt\norg/opencoap/ssl/netty/DtlsClientHandshakeChannelHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1855#2,2:122\n1855#2,2:124\n*S KotlinDebug\n*F\n+ 1 DtlsClientHandshakeChannelHandler.kt\norg/opencoap/ssl/netty/DtlsClientHandshakeChannelHandler\n*L\n80#1:122,2\n104#1:124,2\n*E\n"})
public final class DtlsClientHandshakeChannelHandler
extends ChannelDuplexHandler {
    @NotNull
    private final SslHandshakeContext sslHandshakeContext;
    @NotNull
    private final InetSocketAddress peerAddress;
    @NotNull
    private final SessionWriter sessionWriter;
    private final Logger logger;
    private ChannelHandlerContext ctx;
    @NotNull
    private final List<Pair<DatagramPacket, ChannelPromise>> outboundMessages;
    @Nullable
    private ScheduledFuture<?> scheduledRetransmission;

    public DtlsClientHandshakeChannelHandler(@NotNull SslHandshakeContext sslHandshakeContext, @NotNull InetSocketAddress peerAddress, @NotNull SessionWriter sessionWriter) {
        Intrinsics.checkNotNullParameter((Object)sslHandshakeContext, (String)"sslHandshakeContext");
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        Intrinsics.checkNotNullParameter((Object)sessionWriter, (String)"sessionWriter");
        this.sslHandshakeContext = sslHandshakeContext;
        this.peerAddress = peerAddress;
        this.sessionWriter = sessionWriter;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.outboundMessages = new ArrayList();
    }

    private final void write(ByteBuffer packet) {
        DatagramPacket dtlsPacket = new DatagramPacket(NettyExtensionsKt.toByteBuf(packet), this.peerAddress);
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
            channelHandlerContext = null;
        }
        channelHandlerContext.writeAndFlush((Object)dtlsPacket);
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        this.stepAndSchedule();
    }

    private final void stepAndSchedule() {
        ScheduledFuture<?> scheduledFuture = this.scheduledRetransmission;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.sslHandshakeContext.step(Packet.Companion.getEMPTY_BYTEBUFFER(), (Function1)new Function1<ByteBuffer, Unit>((Object)this){

            public final void invoke(@NotNull ByteBuffer p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                DtlsClientHandshakeChannelHandler.access$write((DtlsClientHandshakeChannelHandler)((Object)this.receiver), p0);
            }
        });
        this.scheduleRetransmission();
    }

    private final void scheduleRetransmission() {
        Duration readTimeout = this.sslHandshakeContext.getReadTimeout();
        if (!readTimeout.isZero()) {
            ChannelHandlerContext channelHandlerContext = this.ctx;
            if (channelHandlerContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
                channelHandlerContext = null;
            }
            this.scheduledRetransmission = channelHandlerContext.executor().schedule(this::stepAndSchedule, readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!(msg instanceof DatagramPacket)) {
            ctx.fireChannelRead(msg);
            return;
        }
        try {
            ScheduledFuture<?> scheduledFuture = this.scheduledRetransmission;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            ByteBuffer byteBuffer = ((ByteBuf)((DatagramPacket)msg).content()).nioBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
            SslContext sslContext2 = this.sslHandshakeContext.step(byteBuffer, (Function1)new Function1<ByteBuffer, Unit>((Object)this){

                public final void invoke(@NotNull ByteBuffer p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    DtlsClientHandshakeChannelHandler.access$write((DtlsClientHandshakeChannelHandler)((Object)this.receiver), p0);
                }
            });
            if (sslContext2 instanceof SslSession) {
                ctx.channel().pipeline().replace((ChannelHandler)this, "DTLS-Client", (ChannelHandler)new DtlsClientChannelHandler((SslSession)sslContext2, this.sessionWriter));
                Iterable $this$forEach$iv = this.outboundMessages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    DatagramPacket plain = (DatagramPacket)pair.component1();
                    ChannelPromise promise = (ChannelPromise)pair.component2();
                    ctx.channel().writeAndFlush((Object)plain, promise);
                }
                this.outboundMessages.clear();
            } else {
                this.scheduleRetransmission();
            }
        }
        catch (SslException ex) {
            this.logger.warn("Closing channel ({}) due to SslException: {}", (Object)ctx.channel(), (Object)ex.toString());
            ctx.channel().close();
        }
        finally {
            ((DatagramPacket)msg).release();
        }
    }

    public void close(@NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        this.sslHandshakeContext.close();
        this.releaseOutboundMessages();
        super.close(ctx, promise);
    }

    private final void releaseOutboundMessages() {
        Iterable $this$forEach$iv = this.outboundMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            DatagramPacket plain = (DatagramPacket)pair.component1();
            ChannelPromise promise = (ChannelPromise)pair.component2();
            plain.release();
            promise.setFailure((Throwable)new ClosedChannelException());
        }
        this.outboundMessages.clear();
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (!(msg instanceof DatagramPacket)) {
            ctx.write(msg, promise);
            return;
        }
        this.outboundMessages.add((Pair<DatagramPacket, ChannelPromise>)new Pair(msg, (Object)promise));
        if (!ctx.channel().isOpen()) {
            this.releaseOutboundMessages();
        }
    }

    public static final /* synthetic */ void access$write(DtlsClientHandshakeChannelHandler $this, ByteBuffer packet) {
        $this.write(packet);
    }
}

