/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.netty.NettyExtensionsKt;
import org.opencoap.ssl.transport.Transport;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0003\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\b\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\u0002\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f\u001a3\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0010*\u0002H\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u000e0\u0012H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u001e\u0010\u0014\u001a\u00020\u000e*\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"mapToByteArray", "Lorg/opencoap/ssl/transport/Transport;", "", "Lio/netty/buffer/ByteBuf;", "mapToString", "", "toByteArray", "toByteBuf", "Ljava/nio/ByteBuffer;", "toCompletableFuture", "Ljava/util/concurrent/CompletableFuture;", "", "Lio/netty/channel/ChannelFuture;", "useAndRelease", "", "T", "Lio/netty/util/ReferenceCounted;", "f", "Lkotlin/Function1;", "(Lio/netty/util/ReferenceCounted;Lkotlin/jvm/functions/Function1;)V", "writeThroughNioBuffer", "kotlin-mbedtls-netty"})
@SourceDebugExtension(value={"SMAP\nNettyExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyExtensions.kt\norg/opencoap/ssl/netty/NettyExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class NettyExtensionsKt {
    @NotNull
    public static final CompletableFuture<Boolean> toCompletableFuture(@NotNull ChannelFuture $this$toCompletableFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$toCompletableFuture, (String)"<this>");
        if ($this$toCompletableFuture.isSuccess()) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Boolean> promise = new CompletableFuture<Boolean>();
        $this$toCompletableFuture.addListener(arg_0 -> NettyExtensionsKt.toCompletableFuture$lambda$0(promise, arg_0));
        return promise;
    }

    @NotNull
    public static final ByteBuf toByteBuf(@NotNull ByteBuffer $this$toByteBuf) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteBuf, (String)"<this>");
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)$this$toByteBuf);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(...)");
        return byteBuf;
    }

    @NotNull
    public static final ByteBuf toByteBuf(@NotNull byte[] $this$toByteBuf) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteBuf, (String)"<this>");
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])$this$toByteBuf);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(...)");
        return byteBuf;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuf $this$toByteArray) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        byte[] it = byArray = ByteBufUtil.getBytes((ByteBuf)$this$toByteArray, (int)$this$toByteArray.readerIndex(), (int)$this$toByteArray.readableBytes(), (boolean)false);
        boolean bl = false;
        $this$toByteArray.release();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"also(...)");
        return byArray;
    }

    public static final void writeThroughNioBuffer(@NotNull ByteBuf $this$writeThroughNioBuffer, @NotNull Function1<? super ByteBuffer, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)$this$writeThroughNioBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (!($this$writeThroughNioBuffer.nioBufferCount() == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffer nioBuffer = $this$writeThroughNioBuffer.nioBuffer(0, $this$writeThroughNioBuffer.writableBytes());
        Intrinsics.checkNotNull((Object)nioBuffer);
        f.invoke((Object)nioBuffer);
        $this$writeThroughNioBuffer.writerIndex(nioBuffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends ReferenceCounted> void useAndRelease(@NotNull T $this$useAndRelease, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter($this$useAndRelease, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$useAndRelease = false;
        try {
            f.invoke($this$useAndRelease);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$useAndRelease.release();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public static final Transport<byte[]> mapToByteArray(@NotNull Transport<ByteBuf> $this$mapToByteArray) {
        Intrinsics.checkNotNullParameter($this$mapToByteArray, (String)"<this>");
        return $this$mapToByteArray.map((Function1)mapToByteArray.1.INSTANCE, (Function1)mapToByteArray.2.INSTANCE);
    }

    @NotNull
    public static final Transport<String> mapToString(@NotNull Transport<ByteBuf> $this$mapToString) {
        Intrinsics.checkNotNullParameter($this$mapToString, (String)"<this>");
        return NettyExtensionsKt.mapToByteArray($this$mapToString).map((Function1)mapToString.1.INSTANCE, (Function1)mapToString.2.INSTANCE);
    }

    private static final void toCompletableFuture$lambda$0(CompletableFuture $promise, Future it) {
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        if (it.isSuccess()) {
            $promise.complete(true);
        } else {
            $promise.completeExceptionally(it.cause());
        }
    }
}

