/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslSession;
import org.opencoap.ssl.netty.CompletableQueue;
import org.opencoap.ssl.netty.DtlsClientChannelHandler;
import org.opencoap.ssl.netty.DtlsClientHandshakeChannelHandler;
import org.opencoap.ssl.netty.NettyExtensionsKt;
import org.opencoap.ssl.netty.NettyTransportAdapter;
import org.opencoap.ssl.transport.SessionWriter;
import org.opencoap.ssl.transport.Transport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/opencoap/ssl/netty/NettyTransportAdapter;", "Lorg/opencoap/ssl/transport/Transport;", "Lio/netty/buffer/ByteBuf;", "channel", "Lio/netty/channel/socket/DatagramChannel;", "destinationAddress", "Ljava/net/InetSocketAddress;", "(Lio/netty/channel/socket/DatagramChannel;Ljava/net/InetSocketAddress;)V", "getChannel", "()Lio/netty/channel/socket/DatagramChannel;", "inboundMessageReceiver", "Lorg/opencoap/ssl/netty/NettyTransportAdapter$InboundMessageReceiver;", "close", "", "localPort", "", "receive", "Ljava/util/concurrent/CompletableFuture;", "timeout", "Ljava/time/Duration;", "send", "", "packet", "Companion", "InboundMessageReceiver", "kotlin-mbedtls-netty"})
@SourceDebugExtension(value={"SMAP\nNettyTransportAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyTransportAdapter.kt\norg/opencoap/ssl/netty/NettyTransportAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class NettyTransportAdapter
implements Transport<ByteBuf> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatagramChannel channel;
    @NotNull
    private final InetSocketAddress destinationAddress;
    @NotNull
    private final InboundMessageReceiver inboundMessageReceiver;

    public NettyTransportAdapter(@NotNull DatagramChannel channel, @NotNull InetSocketAddress destinationAddress) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
        this.channel = channel;
        this.destinationAddress = destinationAddress;
        this.inboundMessageReceiver = new InboundMessageReceiver();
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{this.inboundMessageReceiver};
        this.channel.pipeline().addLast(channelHandlerArray);
    }

    @NotNull
    public final DatagramChannel getChannel() {
        return this.channel;
    }

    @NotNull
    public CompletableFuture<ByteBuf> receive(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        if (!this.channel.isActive()) {
            CompletableFuture<ByteBuf> completableFuture;
            CompletableFuture<ByteBuf> $this$receive_u24lambda_u240 = completableFuture = new CompletableFuture<ByteBuf>();
            boolean bl = false;
            $this$receive_u24lambda_u240.completeExceptionally(new IOException("Channel closed"));
            return completableFuture;
        }
        CompletableFuture<ByteBuf> promise = this.inboundMessageReceiver.getQueue().poll();
        ScheduledFuture timeoutFuture = this.channel.eventLoop().schedule(() -> NettyTransportAdapter.receive$lambda$1(promise), timeout.toMillis(), TimeUnit.MILLISECONDS);
        CompletionStage completionStage = promise.whenComplete((arg_0, arg_1) -> NettyTransportAdapter.receive$lambda$2((Function2)new Function2<ByteBuf, Throwable, Unit>(timeoutFuture){
            final /* synthetic */ ScheduledFuture<?> $timeoutFuture;
            {
                this.$timeoutFuture = $timeoutFuture;
                super(2);
            }

            public final void invoke(ByteBuf byteBuf, Throwable throwable) {
                this.$timeoutFuture.cancel(false);
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        return completionStage;
    }

    public int localPort() {
        return this.channel.localAddress().getPort();
    }

    public void close() {
        this.channel.close().sync();
    }

    @NotNull
    public CompletableFuture<Boolean> send(@NotNull ByteBuf packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        DatagramPacket dgramPacket = new DatagramPacket(packet, this.destinationAddress);
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)dgramPacket);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
        return NettyExtensionsKt.toCompletableFuture(channelFuture);
    }

    @NotNull
    public <P2> Transport<P2> map(@NotNull Function1<? super ByteBuf, ? extends P2> f, @NotNull Function1<? super P2, ? extends ByteBuf> f2) {
        return Transport.DefaultImpls.map((Transport)this, f, f2);
    }

    private static final void receive$lambda$1(CompletableFuture $promise) {
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        $promise.cancel(false);
    }

    private static final void receive$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress, @NotNull EventLoopGroup group, @NotNull SessionWriter sessionWriter, @NotNull Function1<? super Bootstrap, Unit> bootstrapConfig) {
        return Companion.connect(sslConfig, destinationAddress, group, sessionWriter, bootstrapConfig);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress, @NotNull EventLoopGroup group, @NotNull SessionWriter sessionWriter) {
        return Companion.connect(sslConfig, destinationAddress, group, sessionWriter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress, @NotNull EventLoopGroup group) {
        return Companion.connect(sslConfig, destinationAddress, group);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress) {
        return Companion.connect(sslConfig, destinationAddress);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0007J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"Lorg/opencoap/ssl/netty/NettyTransportAdapter$Companion;", "", "()V", "connect", "Lorg/opencoap/ssl/netty/NettyTransportAdapter;", "sslConfig", "Lorg/opencoap/ssl/SslConfig;", "destinationAddress", "Ljava/net/InetSocketAddress;", "group", "Lio/netty/channel/EventLoopGroup;", "sessionWriter", "Lorg/opencoap/ssl/transport/SessionWriter;", "bootstrapConfig", "Lkotlin/Function1;", "Lio/netty/bootstrap/Bootstrap;", "", "reload", "sslSession", "Lorg/opencoap/ssl/SslSession;", "kotlin-mbedtls-netty"})
    @SourceDebugExtension(value={"SMAP\nNettyTransportAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyTransportAdapter.kt\norg/opencoap/ssl/netty/NettyTransportAdapter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress, @NotNull EventLoopGroup group, @NotNull SessionWriter sessionWriter, @NotNull Function1<? super Bootstrap, Unit> bootstrapConfig) {
            Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
            Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)sessionWriter, (String)"sessionWriter");
            Intrinsics.checkNotNullParameter(bootstrapConfig, (String)"bootstrapConfig");
            AbstractBootstrap abstractBootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new DtlsClientHandshakeChannelHandler(sslConfig.newContext(destinationAddress), destinationAddress, sessionWriter));
            bootstrapConfig.invoke((Object)abstractBootstrap);
            Channel it = ((Bootstrap)abstractBootstrap).bind(0).sync().channel();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.netty.channel.socket.DatagramChannel");
            return new NettyTransportAdapter((DatagramChannel)it, destinationAddress);
        }

        public static /* synthetic */ NettyTransportAdapter connect$default(Companion companion, SslConfig sslConfig, InetSocketAddress inetSocketAddress, EventLoopGroup eventLoopGroup, SessionWriter sessionWriter, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                eventLoopGroup = (EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("udp", true));
            }
            if ((n & 8) != 0) {
                sessionWriter = SessionWriter.NO_OPS;
            }
            if ((n & 0x10) != 0) {
                function1 = connect.1.INSTANCE;
            }
            return companion.connect(sslConfig, inetSocketAddress, eventLoopGroup, sessionWriter, (Function1<? super Bootstrap, Unit>)function1);
        }

        @NotNull
        public final NettyTransportAdapter reload(@NotNull SslSession sslSession, @NotNull InetSocketAddress destinationAddress, @NotNull SessionWriter sessionWriter, @NotNull EventLoopGroup group) {
            Intrinsics.checkNotNullParameter((Object)sslSession, (String)"sslSession");
            Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
            Intrinsics.checkNotNullParameter((Object)sessionWriter, (String)"sessionWriter");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Channel it = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new DtlsClientChannelHandler(sslSession, sessionWriter))).bind(0).sync().channel();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.netty.channel.socket.DatagramChannel");
            return new NettyTransportAdapter((DatagramChannel)it, destinationAddress);
        }

        public static /* synthetic */ NettyTransportAdapter reload$default(Companion companion, SslSession sslSession, InetSocketAddress inetSocketAddress, SessionWriter sessionWriter, EventLoopGroup eventLoopGroup, int n, Object object) {
            if ((n & 8) != 0) {
                eventLoopGroup = (EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("udp", true));
            }
            return companion.reload(sslSession, inetSocketAddress, sessionWriter, eventLoopGroup);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress, @NotNull EventLoopGroup group, @NotNull SessionWriter sessionWriter) {
            Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
            Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)sessionWriter, (String)"sessionWriter");
            return org.opencoap.ssl.netty.NettyTransportAdapter$Companion.connect$default(this, sslConfig, destinationAddress, group, sessionWriter, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress, @NotNull EventLoopGroup group) {
            Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
            Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            return org.opencoap.ssl.netty.NettyTransportAdapter$Companion.connect$default(this, sslConfig, destinationAddress, group, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NettyTransportAdapter connect(@NotNull SslConfig sslConfig, @NotNull InetSocketAddress destinationAddress) {
            Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
            Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
            return org.opencoap.ssl.netty.NettyTransportAdapter$Companion.connect$default(this, sslConfig, destinationAddress, null, null, null, 28, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/opencoap/ssl/netty/NettyTransportAdapter$InboundMessageReceiver;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "()V", "queue", "Lorg/opencoap/ssl/netty/CompletableQueue;", "Lio/netty/buffer/ByteBuf;", "getQueue", "()Lorg/opencoap/ssl/netty/CompletableQueue;", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead", "msg", "", "kotlin-mbedtls-netty"})
    private static final class InboundMessageReceiver
    extends ChannelInboundHandlerAdapter {
        @NotNull
        private final CompletableQueue<ByteBuf> queue = new CompletableQueue();

        @NotNull
        public final CompletableQueue<ByteBuf> getQueue() {
            return this.queue;
        }

        public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Object object = ((DatagramPacket)msg).content();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"content(...)");
            this.queue.add((ByteBuf)object);
        }

        public void channelInactive(@NotNull ChannelHandlerContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            ctx.fireChannelInactive();
            this.queue.cancelAll();
        }
    }
}

