/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Callback;
import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.AuthConfig;
import org.opencoap.ssl.CidSupplier;
import org.opencoap.ssl.EmptyCidSupplier;
import org.opencoap.ssl.MbedtlsApi;
import org.opencoap.ssl.ReceiveCallback;
import org.opencoap.ssl.SendCallback;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.SslHandshakeContext;
import org.opencoap.ssl.SslSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\t\u0010\b\u001a\u00020\u000fH\u0096\u0001J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opencoap/ssl/SslConfig;", "Ljava/io/Closeable;", "conf", "Lcom/sun/jna/Memory;", "cidSupplier", "Lorg/opencoap/ssl/CidSupplier;", "mtu", "", "close", "(Lcom/sun/jna/Memory;Lorg/opencoap/ssl/CidSupplier;ILjava/io/Closeable;)V", "getCidSupplier", "()Lorg/opencoap/ssl/CidSupplier;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "", "loadSession", "Lorg/opencoap/ssl/SslSession;", "cid", "", "session", "peerAddress", "Ljava/net/InetSocketAddress;", "newContext", "Lorg/opencoap/ssl/SslHandshakeContext;", "Companion", "LogCallback", "NoOpsGetDelayCallback", "NoOpsSetDelayCallback", "kotlin-mbedtls"})
public final class SslConfig
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Memory conf;
    @NotNull
    private final CidSupplier cidSupplier;
    private final int mtu;
    @NotNull
    private final Closeable close;
    private final Logger logger;

    public SslConfig(@NotNull Memory conf, @NotNull CidSupplier cidSupplier, int mtu, @NotNull Closeable close) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
        Intrinsics.checkNotNullParameter((Object)close, (String)"close");
        this.conf = conf;
        this.cidSupplier = cidSupplier;
        this.mtu = mtu;
        this.close = close;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final CidSupplier getCidSupplier() {
        return this.cidSupplier;
    }

    @Override
    public void close() {
        this.close.close();
    }

    @NotNull
    public final SslHandshakeContext newContext(@NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        Memory memory = new Memory(560L);
        MbedtlsApi mbedtlsApi = MbedtlsApi.INSTANCE;
        Pointer p0 = (Pointer)memory;
        boolean bl = false;
        mbedtlsApi.mbedtls_ssl_init(p0);
        Memory sslContext = memory;
        MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_setup((Pointer)sslContext, (Pointer)this.conf));
        MbedtlsApi.INSTANCE.mbedtls_ssl_set_timer_cb((Pointer)sslContext, Pointer.NULL, NoOpsSetDelayCallback.INSTANCE, NoOpsGetDelayCallback.INSTANCE);
        byte[] cid2 = this.cidSupplier.next();
        MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_set_cid((Pointer)sslContext, 1, cid2, cid2.length));
        MbedtlsApi.INSTANCE.mbedtls_ssl_set_mtu((Pointer)sslContext, this.mtu);
        String string = peerAddress.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"peerAddress.toString()");
        String clientId = string;
        MbedtlsApi.INSTANCE.mbedtls_ssl_set_client_transport_id((Pointer)sslContext, clientId, clientId.length());
        MbedtlsApi.INSTANCE.mbedtls_ssl_set_bio((Pointer)sslContext, Pointer.NULL, SendCallback.INSTANCE, null, ReceiveCallback.INSTANCE);
        return new SslHandshakeContext(this, sslContext, cid2, peerAddress);
    }

    @NotNull
    public final SslSession loadSession(@NotNull byte[] cid2, @NotNull byte[] session, @NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)cid2, (String)"cid");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        Object object = new Memory(560L);
        MbedtlsApi mbedtlsApi = MbedtlsApi.INSTANCE;
        Pointer p0 = (Pointer)object;
        boolean bl = false;
        mbedtlsApi.mbedtls_ssl_init(p0);
        Memory sslContext = object;
        MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_setup((Pointer)sslContext, (Pointer)this.conf));
        MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_context_load((Pointer)sslContext, session, session.length));
        MbedtlsApi.INSTANCE.mbedtls_ssl_set_bio((Pointer)sslContext, Pointer.NULL, SendCallback.INSTANCE, null, ReceiveCallback.INSTANCE);
        Object it = object = new SslSession(this, sslContext, cid2, true);
        boolean bl2 = false;
        this.logger.info("[{}] Reconnected {}", (Object)peerAddress, it);
        return object;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, @NotNull Duration retransmitMin, @NotNull Duration retransmitMax) {
        return Companion.client(auth, cipherSuites, reqAuthentication, cidSupplier, retransmitMin, retransmitMax);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, int mtu, @NotNull Duration retransmitMin, @NotNull Duration retransmitMax) {
        return Companion.server(auth, cipherSuites, reqAuthentication, cidSupplier, mtu, retransmitMin, retransmitMax);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, @NotNull Duration retransmitMin) {
        return Companion.client(auth, cipherSuites, reqAuthentication, cidSupplier, retransmitMin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier) {
        return Companion.client(auth, cipherSuites, reqAuthentication, cidSupplier);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication) {
        return Companion.client(auth, cipherSuites, reqAuthentication);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites) {
        return Companion.client(auth, cipherSuites);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig client(@NotNull AuthConfig auth) {
        return Companion.client(auth);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, int mtu, @NotNull Duration retransmitMin) {
        return Companion.server(auth, cipherSuites, reqAuthentication, cidSupplier, mtu, retransmitMin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, int mtu) {
        return Companion.server(auth, cipherSuites, reqAuthentication, cidSupplier, mtu);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier) {
        return Companion.server(auth, cipherSuites, reqAuthentication, cidSupplier);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication) {
        return Companion.server(auth, cipherSuites, reqAuthentication);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites) {
        return Companion.server(auth, cipherSuites);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SslConfig server(@NotNull AuthConfig auth) {
        return Companion.server(auth);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007JP\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002JR\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007\u00a8\u0006\u001c"}, d2={"Lorg/opencoap/ssl/SslConfig$Companion;", "", "()V", "client", "Lorg/opencoap/ssl/SslConfig;", "auth", "Lorg/opencoap/ssl/AuthConfig;", "cipherSuites", "", "", "reqAuthentication", "", "cidSupplier", "Lorg/opencoap/ssl/CidSupplier;", "retransmitMin", "Ljava/time/Duration;", "retransmitMax", "create", "isServer", "authConfig", "requiredAuthMode", "mtu", "", "getCipherSuiteId", "cipherSuite", "mapCipherSuites", "Lcom/sun/jna/Memory;", "server", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, @NotNull Duration retransmitMin, @NotNull Duration retransmitMax) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            Intrinsics.checkNotNullParameter((Object)retransmitMin, (String)"retransmitMin");
            Intrinsics.checkNotNullParameter((Object)retransmitMax, (String)"retransmitMax");
            return this.create(false, auth, cipherSuites, cidSupplier, reqAuthentication, 0, retransmitMin, retransmitMax);
        }

        public static /* synthetic */ SslConfig client$default(Companion companion, AuthConfig authConfig, List list, boolean bl, CidSupplier cidSupplier, Duration duration, Duration duration2, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                cidSupplier = EmptyCidSupplier.INSTANCE;
            }
            if ((n & 0x10) != 0) {
                Duration duration3 = Duration.ofSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(1)");
                duration = duration3;
            }
            if ((n & 0x20) != 0) {
                Duration duration4 = Duration.ofSeconds(60L);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(60)");
                duration2 = duration4;
            }
            return companion.client(authConfig, list, bl, cidSupplier, duration, duration2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, int mtu, @NotNull Duration retransmitMin, @NotNull Duration retransmitMax) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            Intrinsics.checkNotNullParameter((Object)retransmitMin, (String)"retransmitMin");
            Intrinsics.checkNotNullParameter((Object)retransmitMax, (String)"retransmitMax");
            return this.create(true, auth, cipherSuites, cidSupplier, reqAuthentication, mtu, retransmitMin, retransmitMax);
        }

        public static /* synthetic */ SslConfig server$default(Companion companion, AuthConfig authConfig, List list, boolean bl, CidSupplier cidSupplier, int n, Duration duration, Duration duration2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            if ((n2 & 8) != 0) {
                cidSupplier = EmptyCidSupplier.INSTANCE;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                Duration duration3 = Duration.ofSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(1)");
                duration = duration3;
            }
            if ((n2 & 0x40) != 0) {
                Duration duration4 = Duration.ofSeconds(60L);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(60)");
                duration2 = duration4;
            }
            return companion.server(authConfig, list, bl, cidSupplier, n, duration, duration2);
        }

        /*
         * WARNING - void declaration
         */
        private final SslConfig create(boolean isServer, AuthConfig authConfig, List<String> cipherSuites, CidSupplier cidSupplier, boolean requiredAuthMode, int mtu, Duration retransmitMin, Duration retransmitMax) {
            Memory memory = new Memory(400L);
            MbedtlsApi mbedtlsApi = MbedtlsApi.INSTANCE;
            Object p0 = (Pointer)memory;
            boolean bl = false;
            mbedtlsApi.mbedtls_ssl_config_init((Pointer)p0);
            Memory sslConfig = memory;
            mbedtlsApi = new Memory(1032L);
            p0 = MbedtlsApi.Crypto.INSTANCE;
            Object p02 = (Pointer)mbedtlsApi;
            boolean bl2 = false;
            ((MbedtlsApi.Crypto)p0).mbedtls_entropy_init((Pointer)p02);
            MbedtlsApi entropy = mbedtlsApi;
            p0 = new Memory(344L);
            p02 = MbedtlsApi.Crypto.INSTANCE;
            Object p03 = (Pointer)p0;
            boolean bl3 = false;
            ((MbedtlsApi.Crypto)p02).mbedtls_ctr_drbg_init((Pointer)p03);
            Object ctrDrbg = p0;
            p02 = new Memory(616L);
            p03 = MbedtlsApi.X509.INSTANCE;
            Object p04 = (Pointer)p02;
            boolean bl4 = false;
            ((MbedtlsApi.X509)p03).mbedtls_x509_crt_init((Pointer)p04);
            Object ownCert = p02;
            p03 = new Memory(616L);
            p04 = MbedtlsApi.X509.INSTANCE;
            Object p05 = (Pointer)p03;
            boolean bl5 = false;
            ((MbedtlsApi.X509)p04).mbedtls_x509_crt_init((Pointer)p05);
            Object caCert = p03;
            p04 = new Memory(16L);
            p05 = MbedtlsApi.Crypto.INSTANCE;
            Pointer p06 = (Pointer)p04;
            boolean bl6 = false;
            ((MbedtlsApi.Crypto)p05).mbedtls_pk_init(p06);
            Object pkey = p04;
            Ref.ObjectRef cipherSuiteIds = new Ref.ObjectRef();
            int endpointType = isServer ? 1 : 0;
            MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_config_defaults((Pointer)sslConfig, endpointType, 1, 0));
            MbedtlsApi.INSTANCE.mbedtls_ssl_conf_min_version((Pointer)sslConfig, 3, 3);
            Pointer pointer = (Pointer)ctrDrbg;
            Function function = MbedtlsApi.Crypto.INSTANCE.getMbedtls_entropy_func$kotlin_mbedtls();
            Intrinsics.checkNotNullExpressionValue((Object)function, (String)"Crypto.mbedtls_entropy_func");
            MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.Crypto.INSTANCE.mbedtls_ctr_drbg_seed(pointer, (Pointer)function, (Pointer)entropy, Pointer.NULL, 0));
            Pointer pointer2 = (Pointer)sslConfig;
            Function function2 = MbedtlsApi.Crypto.INSTANCE.getMbedtls_ctr_drbg_random$kotlin_mbedtls();
            Intrinsics.checkNotNullExpressionValue((Object)function2, (String)"mbedtls_ctr_drbg_random");
            MbedtlsApi.INSTANCE.mbedtls_ssl_conf_rng(pointer2, (Pointer)function2, (Pointer)ctrDrbg);
            Ref.ObjectRef cookieCtx = new Ref.ObjectRef();
            if (!isServer) {
                MbedtlsApi.INSTANCE.mbedtls_ssl_conf_dtls_cookies((Pointer)sslConfig, null, null, null);
            } else {
                void p07;
                Memory memory2 = new Memory(32L);
                MbedtlsApi mbedtlsApi2 = MbedtlsApi.INSTANCE;
                Pointer pointer3 = (Pointer)memory2;
                Ref.ObjectRef objectRef = cookieCtx;
                boolean bl7 = false;
                mbedtlsApi2.mbedtls_ssl_cookie_init((Pointer)p07);
                objectRef.element = memory2;
                Pointer pointer4 = (Pointer)cookieCtx.element;
                Function function3 = MbedtlsApi.Crypto.INSTANCE.getMbedtls_ctr_drbg_random$kotlin_mbedtls();
                Intrinsics.checkNotNullExpressionValue((Object)function3, (String)"mbedtls_ctr_drbg_random");
                MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_cookie_setup(pointer4, (Pointer)function3, (Pointer)ctrDrbg));
                MbedtlsApi.INSTANCE.mbedtls_ssl_conf_dtls_cookies((Pointer)sslConfig, MbedtlsApi.INSTANCE.getMbedtls_ssl_cookie_write(), MbedtlsApi.INSTANCE.getMbedtls_ssl_cookie_check(), (Pointer)cookieCtx.element);
            }
            MbedtlsApi.INSTANCE.mbedtls_ssl_conf_authmode((Pointer)sslConfig, requiredAuthMode ? 2 : 0);
            if (!((Collection)cipherSuites).isEmpty()) {
                cipherSuiteIds.element = this.mapCipherSuites(cipherSuites);
                MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_conf_ciphersuites((Pointer)sslConfig, (Memory)cipherSuiteIds.element));
            }
            if (!Intrinsics.areEqual((Object)cidSupplier, (Object)EmptyCidSupplier.INSTANCE)) {
                MbedtlsApi.INSTANCE.mbedtls_ssl_conf_cid((Pointer)sslConfig, cidSupplier.next().length, 0);
            }
            authConfig.configure(sslConfig, (Memory)caCert, (Memory)ownCert, (Memory)pkey, (Memory)ctrDrbg);
            MbedtlsApi.INSTANCE.mbedtls_ssl_conf_handshake_timeout((Pointer)sslConfig, (int)retransmitMin.toMillis(), (int)retransmitMax.toMillis());
            MbedtlsApi.INSTANCE.mbedtls_ssl_conf_dbg((Pointer)sslConfig, LogCallback.INSTANCE, Pointer.NULL);
            return new SslConfig(sslConfig, cidSupplier, mtu, () -> Companion.create$lambda$8(sslConfig, (Memory)entropy, (Memory)ctrDrbg, (Memory)pkey, (Memory)ownCert, (Memory)caCert, cookieCtx, cipherSuiteIds));
        }

        static /* synthetic */ SslConfig create$default(Companion companion, boolean bl, AuthConfig authConfig, List list, CidSupplier cidSupplier, boolean bl2, int n, Duration duration, Duration duration2, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                bl2 = true;
            }
            return companion.create(bl, authConfig, list, cidSupplier, bl2, n, duration, duration2);
        }

        /*
         * WARNING - void declaration
         */
        private final Memory mapCipherSuites(List<String> cipherSuites) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = cipherSuites;
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(companion.getCipherSuiteId((String)p0));
            }
            int[] ids = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
            Memory cipherSuiteList = new Memory((long)((ids.length + 1) * 4));
            cipherSuiteList.write(0L, ids, 0, ids.length);
            cipherSuiteList.setInt(cipherSuiteList.size() - (long)4, 0);
            return cipherSuiteList;
        }

        private final int getCipherSuiteId(String cipherSuite) {
            int id = MbedtlsApi.INSTANCE.mbedtls_ssl_get_ciphersuite_id(cipherSuite);
            if (id <= 0) {
                throw new SslException("Unknown cipher-suite: " + cipherSuite);
            }
            return id;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, @NotNull Duration retransmitMin) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            Intrinsics.checkNotNullParameter((Object)retransmitMin, (String)"retransmitMin");
            return org.opencoap.ssl.SslConfig$Companion.client$default(this, auth, cipherSuites, reqAuthentication, cidSupplier, retransmitMin, null, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            return org.opencoap.ssl.SslConfig$Companion.client$default(this, auth, cipherSuites, reqAuthentication, cidSupplier, null, null, 48, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            return org.opencoap.ssl.SslConfig$Companion.client$default(this, auth, cipherSuites, reqAuthentication, null, null, null, 56, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig client(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            return org.opencoap.ssl.SslConfig$Companion.client$default(this, auth, cipherSuites, false, null, null, null, 60, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig client(@NotNull AuthConfig auth) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            return org.opencoap.ssl.SslConfig$Companion.client$default(this, auth, null, false, null, null, null, 62, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, int mtu, @NotNull Duration retransmitMin) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            Intrinsics.checkNotNullParameter((Object)retransmitMin, (String)"retransmitMin");
            return org.opencoap.ssl.SslConfig$Companion.server$default(this, auth, cipherSuites, reqAuthentication, cidSupplier, mtu, retransmitMin, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier, int mtu) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            return org.opencoap.ssl.SslConfig$Companion.server$default(this, auth, cipherSuites, reqAuthentication, cidSupplier, mtu, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication, @NotNull CidSupplier cidSupplier) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            Intrinsics.checkNotNullParameter((Object)cidSupplier, (String)"cidSupplier");
            return org.opencoap.ssl.SslConfig$Companion.server$default(this, auth, cipherSuites, reqAuthentication, cidSupplier, 0, null, null, 112, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites, boolean reqAuthentication) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            return org.opencoap.ssl.SslConfig$Companion.server$default(this, auth, cipherSuites, reqAuthentication, null, 0, null, null, 120, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth, @NotNull List<String> cipherSuites) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            Intrinsics.checkNotNullParameter(cipherSuites, (String)"cipherSuites");
            return org.opencoap.ssl.SslConfig$Companion.server$default(this, auth, cipherSuites, false, null, 0, null, null, 124, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SslConfig server(@NotNull AuthConfig auth) {
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            return org.opencoap.ssl.SslConfig$Companion.server$default(this, auth, null, false, null, 0, null, null, 126, null);
        }

        private static final void create$lambda$8(Memory $sslConfig, Memory $entropy, Memory $ctrDrbg, Memory $pkey, Memory $ownCert, Memory $caCert, Ref.ObjectRef $cookieCtx, Ref.ObjectRef $cipherSuiteIds) {
            block1: {
                Memory memory;
                Intrinsics.checkNotNullParameter((Object)$sslConfig, (String)"$sslConfig");
                Intrinsics.checkNotNullParameter((Object)$entropy, (String)"$entropy");
                Intrinsics.checkNotNullParameter((Object)$ctrDrbg, (String)"$ctrDrbg");
                Intrinsics.checkNotNullParameter((Object)$pkey, (String)"$pkey");
                Intrinsics.checkNotNullParameter((Object)$ownCert, (String)"$ownCert");
                Intrinsics.checkNotNullParameter((Object)$caCert, (String)"$caCert");
                Intrinsics.checkNotNullParameter((Object)$cookieCtx, (String)"$cookieCtx");
                Intrinsics.checkNotNullParameter((Object)$cipherSuiteIds, (String)"$cipherSuiteIds");
                MbedtlsApi.INSTANCE.mbedtls_ssl_config_free((Pointer)$sslConfig);
                MbedtlsApi.Crypto.INSTANCE.mbedtls_entropy_free((Pointer)$entropy);
                MbedtlsApi.Crypto.INSTANCE.mbedtls_ctr_drbg_free((Pointer)$ctrDrbg);
                MbedtlsApi.Crypto.INSTANCE.mbedtls_pk_free((Pointer)$pkey);
                MbedtlsApi.X509.INSTANCE.mbedtls_x509_crt_free((Pointer)$ownCert);
                MbedtlsApi.X509.INSTANCE.mbedtls_x509_crt_free((Pointer)$caCert);
                Memory memory2 = (Memory)$cookieCtx.element;
                if (memory2 != null) {
                    memory = memory2;
                    MbedtlsApi mbedtlsApi = MbedtlsApi.INSTANCE;
                    Pointer p0 = (Pointer)memory;
                    boolean bl = false;
                    mbedtlsApi.mbedtls_ssl_cookie_free(p0);
                }
                Memory memory3 = (Memory)$cipherSuiteIds.element;
                if (memory3 == null) break block1;
                Memory it = memory = memory3;
                boolean bl = false;
                it.clear();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opencoap/ssl/SslConfig$LogCallback;", "Lcom/sun/jna/Callback;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "callback", "", "ctx", "Lcom/sun/jna/Pointer;", "debugLevel", "", "fileName", "", "lineNumber", "message", "kotlin-mbedtls"})
    private static final class LogCallback
    implements Callback {
        @NotNull
        public static final LogCallback INSTANCE = new LogCallback();
        private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());

        private LogCallback() {
        }

        public final void callback(@Nullable Pointer ctx, int debugLevel, @NotNull String fileName, int lineNumber, @Nullable String message) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            if (debugLevel == 1) {
                String string = message;
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"got supported group", (boolean)false, (int)2, null) : false;
                if (bl) {
                    return;
                }
            }
            switch (debugLevel) {
                case 1: {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = StringsKt.substringAfterLast$default((String)fileName, (char)'/', null, (int)2, null);
                    objectArray[1] = lineNumber;
                    String string = message;
                    objectArray[2] = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                    logger.warn("[mbedtls {}:{}] {} ", objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = StringsKt.substringAfterLast$default((String)fileName, (char)'/', null, (int)2, null);
                    objectArray[1] = lineNumber;
                    String string = message;
                    objectArray[2] = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                    logger.debug("[mbedtls {}:{}] {}", objectArray);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = StringsKt.substringAfterLast$default((String)fileName, (char)'/', null, (int)2, null);
                    objectArray[1] = lineNumber;
                    String string = message;
                    objectArray[2] = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                    logger.trace("[mbedtls {}:{}] {}", objectArray);
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/opencoap/ssl/SslConfig$NoOpsSetDelayCallback;", "Lcom/sun/jna/Callback;", "()V", "callback", "", "data", "Lcom/sun/jna/Pointer;", "intermediateMs", "", "finalMs", "kotlin-mbedtls"})
    private static final class NoOpsSetDelayCallback
    implements Callback {
        @NotNull
        public static final NoOpsSetDelayCallback INSTANCE = new NoOpsSetDelayCallback();

        private NoOpsSetDelayCallback() {
        }

        public final void callback(@Nullable Pointer data, int intermediateMs, int finalMs) {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opencoap/ssl/SslConfig$NoOpsGetDelayCallback;", "Lcom/sun/jna/Callback;", "()V", "callback", "", "data", "Lcom/sun/jna/Pointer;", "kotlin-mbedtls"})
    private static final class NoOpsGetDelayCallback
    implements Callback {
        @NotNull
        public static final NoOpsGetDelayCallback INSTANCE = new NoOpsGetDelayCallback();

        private NoOpsGetDelayCallback() {
        }

        public final int callback(@Nullable Pointer data) {
            return 1;
        }
    }
}

