/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.CloseNotifyException;
import org.opencoap.ssl.MbedtlsApi;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00062\u00060\u0001j\u0002`\u0002:\u0001\u0006B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/opencoap/ssl/SslException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "Companion", "kotlin-mbedtls"})
public class SslException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SslException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/opencoap/ssl/SslException$Companion;", "", "()V", "from", "Lorg/opencoap/ssl/SslException;", "error", "", "translateError", "", "translateError$kotlin_mbedtls", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SslException from(int error) {
            SslException sslException;
            if (error == -30848) {
                sslException = CloseNotifyException.INSTANCE;
            } else {
                Locale locale = Locale.US;
                String string = "%s [-0x%04X]";
                Object[] objectArray = new Object[]{this.translateError$kotlin_mbedtls(error), -error};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                sslException = new SslException(string2);
            }
            return sslException;
        }

        @NotNull
        public final String translateError$kotlin_mbedtls(int error) {
            Memory buffer = new Memory(100L);
            MbedtlsApi.Crypto.INSTANCE.mbedtls_strerror(error, (Pointer)buffer, (int)buffer.size());
            String string = buffer.getString(0L);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.getString(0)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

