/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.HelloVerifyRequired;
import org.opencoap.ssl.MbedtlsApi;
import org.opencoap.ssl.ReceiveCallback;
import org.opencoap.ssl.SendCallback;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslContext;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.SslSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00012\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180\u001bJ$\u0010\u0019\u001a\u00020\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180\u001bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opencoap/ssl/SslHandshakeContext;", "Lorg/opencoap/ssl/SslContext;", "conf", "Lorg/opencoap/ssl/SslConfig;", "sslContext", "Lcom/sun/jna/Memory;", "cid", "", "peerAdr", "Ljava/net/InetSocketAddress;", "(Lorg/opencoap/ssl/SslConfig;Lcom/sun/jna/Memory;[BLjava/net/InetSocketAddress;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "readTimeout", "Ljava/time/Duration;", "getReadTimeout", "()Ljava/time/Duration;", "startTimestamp", "", "getStartTimestamp", "()J", "stepTimeout", "close", "", "step", "send", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "receivedBuf", "kotlin-mbedtls"})
public final class SslHandshakeContext
implements SslContext {
    @NotNull
    private final SslConfig conf;
    @NotNull
    private final Memory sslContext;
    @Nullable
    private final byte[] cid;
    @NotNull
    private final InetSocketAddress peerAdr;
    private final Logger logger;
    private final long startTimestamp;
    @NotNull
    private Duration stepTimeout;

    public SslHandshakeContext(@NotNull SslConfig conf, @NotNull Memory sslContext, @Nullable byte[] cid2, @NotNull InetSocketAddress peerAdr) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)sslContext, (String)"sslContext");
        Intrinsics.checkNotNullParameter((Object)peerAdr, (String)"peerAdr");
        this.conf = conf;
        this.sslContext = sslContext;
        this.cid = cid2;
        this.peerAdr = peerAdr;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.startTimestamp = System.currentTimeMillis();
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        this.stepTimeout = duration;
    }

    public final long getStartTimestamp() {
        return this.startTimestamp;
    }

    @NotNull
    public final SslContext step(@NotNull Function1<? super ByteBuffer, Unit> send2) {
        Intrinsics.checkNotNullParameter(send2, (String)"send");
        return this.step(null, send2);
    }

    @NotNull
    public final SslContext step(@Nullable ByteBuffer receivedBuf, @NotNull Function1<? super ByteBuffer, Unit> send2) {
        SslSession sslSession;
        Intrinsics.checkNotNullParameter(send2, (String)"send");
        int ret2 = ((Number)ReceiveCallback.INSTANCE.invoke(receivedBuf, (Function0)new Function0<Integer>(send2, this){
            final /* synthetic */ Function1<ByteBuffer, Unit> $send;
            final /* synthetic */ SslHandshakeContext this$0;
            {
                this.$send = $send;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                T t = SendCallback.INSTANCE.invoke(this.$send, (Function0)new Function0<Integer>(this.this$0){
                    final /* synthetic */ SslHandshakeContext this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return MbedtlsApi.INSTANCE.mbedtls_ssl_handshake((Pointer)SslHandshakeContext.access$getSslContext$p(this.this$0));
                    }
                });
                SslHandshakeContext sslHandshakeContext = this.this$0;
                int it = ((Number)t).intValue();
                boolean bl = false;
                Duration duration = Duration.ofMillis(ReceiveCallback.INSTANCE.timeout());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(ReceiveCallback.timeout().toLong())");
                SslHandshakeContext.access$setStepTimeout$p(sslHandshakeContext, duration);
                return (Integer)t;
            }
        })).intValue();
        switch (ret2) {
            case -26880: {
                return this;
            }
            case -27264: {
                throw HelloVerifyRequired.INSTANCE;
            }
            case 0: {
                SslSession it = sslSession = new SslSession(this.conf, this.sslContext, this.cid, false, 8, null);
                boolean bl = false;
                Object[] objectArray = new Object[]{this.peerAdr, System.currentTimeMillis() - this.startTimestamp, it};
                this.logger.info("[{}] DTLS connected in {}ms {}", objectArray);
                break;
            }
            default: {
                SslException sslException;
                SslException it = sslException = SslException.Companion.from(ret2);
                boolean bl = false;
                this.logger.debug("[{}] DTLS failed handshake: {}", (Object)this.peerAdr, (Object)it.getMessage());
                throw (Throwable)sslException;
            }
        }
        return sslSession;
    }

    @NotNull
    public final Duration getReadTimeout() {
        return this.stepTimeout;
    }

    @Override
    public void close() {
        MbedtlsApi.INSTANCE.mbedtls_ssl_free((Pointer)this.sslContext);
    }

    public static final /* synthetic */ Memory access$getSslContext$p(SslHandshakeContext $this) {
        return $this.sslContext;
    }

    public static final /* synthetic */ void access$setStepTimeout$p(SslHandshakeContext $this, Duration duration) {
        $this.stepTimeout = duration;
    }
}

