/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.transport.DatagramChannelAdapter;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SingleThreadExecutorKt;
import org.opencoap.ssl.transport.Transport;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001c2\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J \u0010\u0015\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opencoap/ssl/transport/DatagramChannelAdapter;", "Lorg/opencoap/ssl/transport/Transport;", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "channel", "Ljava/nio/channels/DatagramChannel;", "buffer", "(Ljava/nio/channels/DatagramChannel;Ljava/nio/ByteBuffer;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "port", "", "getPort", "()I", "selector", "Ljava/nio/channels/Selector;", "close", "", "localPort", "receive", "Ljava/util/concurrent/CompletableFuture;", "timeout", "Ljava/time/Duration;", "send", "", "packet", "Companion", "kotlin-mbedtls"})
public final class DatagramChannelAdapter
implements Transport<Packet<ByteBuffer>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatagramChannel channel;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final Selector selector;
    private final ExecutorService executor;

    public DatagramChannelAdapter(@NotNull DatagramChannel channel, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.channel = channel;
        this.buffer = buffer;
        Selector selector = Selector.open();
        Intrinsics.checkNotNullExpressionValue((Object)selector, (String)"open()");
        this.selector = selector;
        this.executor = Executors.newSingleThreadExecutor(arg_0 -> DatagramChannelAdapter.executor$lambda$0(this, arg_0));
        this.channel.configureBlocking(false);
        this.channel.register(this.selector, 1);
    }

    public /* synthetic */ DatagramChannelAdapter(DatagramChannel datagramChannel, ByteBuffer byteBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(16384);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(16384)");
            byteBuffer = byteBuffer2;
        }
        this(datagramChannel, byteBuffer);
    }

    private final int getPort() {
        SocketAddress socketAddress = this.channel.getLocalAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return ((InetSocketAddress)socketAddress).getPort();
    }

    @Override
    @NotNull
    public CompletableFuture<Packet<ByteBuffer>> receive(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ExecutorService executorService = this.executor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executor");
        return SingleThreadExecutorKt.supply(executorService, () -> DatagramChannelAdapter.receive$lambda$1(this, timeout));
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> send(@NotNull Packet<ByteBuffer> packet) {
        CompletableFuture<Boolean> completableFuture;
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        try {
            CompletableFuture<Boolean> completableFuture2 = CompletableFuture.completedFuture(this.channel.send(packet.getBuffer(), packet.getPeerAddress()) > 0);
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"{\n            completedF\u2026erAddress) > 0)\n        }");
            completableFuture = completableFuture2;
        }
        catch (Exception ex) {
            CompletableFuture completableFuture3;
            CompletableFuture it = completableFuture3 = new CompletableFuture();
            boolean bl = false;
            it.completeExceptionally(ex);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    @Override
    public void close() {
        this.channel.close();
        this.selector.close();
        this.executor.shutdown();
    }

    @Override
    public int localPort() {
        SocketAddress socketAddress = this.channel.getLocalAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return ((InetSocketAddress)socketAddress).getPort();
    }

    @Override
    @NotNull
    public <P2> Transport<P2> map(@NotNull Function1<? super Packet<ByteBuffer>, ? extends P2> f, @NotNull Function1<? super P2, Packet<ByteBuffer>> f2) {
        return Transport.DefaultImpls.map(this, f, f2);
    }

    private static final Thread executor$lambda$0(DatagramChannelAdapter this$0, Runnable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new Thread(it, "udp-io (:" + this$0.getPort() + ')');
    }

    private static final Packet receive$lambda$1(DatagramChannelAdapter this$0, Duration $timeout) {
        Packet packet;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$timeout, (String)"$timeout");
        this$0.selector.select($timeout.toMillis());
        this$0.buffer.clear();
        SocketAddress sourceAddress = this$0.channel.receive(this$0.buffer);
        if (sourceAddress == null) {
            packet = Packet.Companion.getEmptyByteBufferPacket();
        } else {
            this$0.buffer.flip();
            packet = new Packet(this$0.buffer, (InetSocketAddress)sourceAddress, null, 4, null);
        }
        return packet;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u000bj\u0002`\f0\u00042\b\b\u0002\u0010\r\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lorg/opencoap/ssl/transport/DatagramChannelAdapter$Companion;", "", "()V", "connect", "Lorg/opencoap/ssl/transport/Transport;", "Ljava/nio/ByteBuffer;", "dest", "Ljava/net/InetSocketAddress;", "listenPort", "", "open", "Lorg/opencoap/ssl/transport/Packet;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "port", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Transport<Packet<ByteBuffer>> open(int port) {
            DatagramChannel datagramChannel = DatagramChannel.open().bind(new InetSocketAddress("0.0.0.0", port));
            Intrinsics.checkNotNullExpressionValue((Object)datagramChannel, (String)"datagramChannel");
            return new DatagramChannelAdapter(datagramChannel, null, 2, null);
        }

        public static /* synthetic */ Transport open$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.open(n);
        }

        @NotNull
        public final Transport<ByteBuffer> connect(@NotNull InetSocketAddress dest, int listenPort) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            DatagramChannel datagramChannel = DatagramChannel.open();
            Intrinsics.checkNotNullExpressionValue((Object)datagramChannel, (String)"open()");
            DatagramChannel channel = datagramChannel;
            if (listenPort > 0) {
                channel.bind(new InetSocketAddress("0.0.0.0", listenPort));
            }
            channel.connect(dest);
            return new DatagramChannelAdapter(channel, null, 2, null).map((Function1)connect.1.INSTANCE, (Function1)new Function1<ByteBuffer, Packet<ByteBuffer>>(dest){
                final /* synthetic */ InetSocketAddress $dest;
                {
                    this.$dest = $dest;
                    super(1);
                }

                @NotNull
                public final Packet<ByteBuffer> invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new Packet<ByteBuffer>(it, this.$dest, null, 4, null);
                }
            });
        }

        public static /* synthetic */ Transport connect$default(Companion companion, InetSocketAddress inetSocketAddress, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.connect(inetSocketAddress, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

