/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.CloseNotifyException;
import org.opencoap.ssl.HelloVerifyRequired;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslContext;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.SslHandshakeContext;
import org.opencoap.ssl.SslSession;
import org.opencoap.ssl.transport.DatagramChannelAdapter;
import org.opencoap.ssl.transport.DtlsSessionContext;
import org.opencoap.ssl.transport.DtlsSessionLifecycleCallbacks;
import org.opencoap.ssl.transport.ExtensionsKt;
import org.opencoap.ssl.transport.NoOpsSessionStore;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SessionStore;
import org.opencoap.ssl.transport.SessionWithContext;
import org.opencoap.ssl.transport.SingleThreadExecutor;
import org.opencoap.ssl.transport.SingleThreadExecutorKt;
import org.opencoap.ssl.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 02\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001:\u00040123BC\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u0013\u001a\u00020\u001eJ0\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u000bH\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u0012H\u0016J\u0006\u0010(\u001a\u00020\u0012J \u0010)\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040 2\u0006\u0010#\u001a\u00020\u000bH\u0016J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020%0 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020%0 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.J\f\u0010/\u001a\u00020\u001d*\u00020\u001bH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064\u00b2\u0006\f\u0010&\u001a\u0004\u0018\u00010\u0003X\u008a\u0084\u0002"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer;", "Lorg/opencoap/ssl/transport/Transport;", "Lorg/opencoap/ssl/transport/Packet;", "", "Lorg/opencoap/ssl/transport/BytesPacket;", "transport", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "sslConfig", "Lorg/opencoap/ssl/SslConfig;", "expireAfter", "Ljava/time/Duration;", "sessionStore", "Lorg/opencoap/ssl/transport/SessionStore;", "lifecycleCallbacks", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;", "(Lorg/opencoap/ssl/transport/Transport;Lorg/opencoap/ssl/SslConfig;Ljava/time/Duration;Lorg/opencoap/ssl/transport/SessionStore;Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;)V", "cidSize", "", "executor", "Lorg/opencoap/ssl/transport/SingleThreadExecutor;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sessions", "", "Ljava/net/InetSocketAddress;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "close", "", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "handleReceived", "Ljava/util/concurrent/CompletableFuture;", "adr", "buf", "timeout", "loadSession", "", "cid", "localPort", "numberOfSessions", "receive", "send", "packet", "setSessionAuthenticationContext", "authenticationContext", "", "closeAndRemove", "Companion", "DtlsHandshake", "DtlsSession", "DtlsState", "kotlin-mbedtls"})
public final class DtlsServer
implements Transport<Packet<byte[]>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Transport<Packet<ByteBuffer>> transport;
    @NotNull
    private final SslConfig sslConfig;
    @NotNull
    private final Duration expireAfter;
    @NotNull
    private final SessionStore sessionStore;
    @NotNull
    private final DtlsSessionLifecycleCallbacks lifecycleCallbacks;
    private final Logger logger;
    @NotNull
    private final SingleThreadExecutor executor;
    @NotNull
    private final Map<InetSocketAddress, DtlsState> sessions;
    private final int cidSize;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public DtlsServer(@NotNull Transport<Packet<ByteBuffer>> transport, @NotNull SslConfig sslConfig, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks) {
        Intrinsics.checkNotNullParameter(transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
        Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
        Intrinsics.checkNotNullParameter((Object)lifecycleCallbacks, (String)"lifecycleCallbacks");
        this.transport = transport;
        this.sslConfig = sslConfig;
        this.expireAfter = expireAfter;
        this.sessionStore = sessionStore;
        this.lifecycleCallbacks = lifecycleCallbacks;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.executor = SingleThreadExecutor.Companion.create("dtls-srv-");
        this.sessions = new LinkedHashMap();
        this.cidSize = this.sslConfig.getCidSupplier().next().length;
    }

    public /* synthetic */ DtlsServer(Transport transport, SslConfig sslConfig, Duration duration, SessionStore sessionStore, DtlsSessionLifecycleCallbacks dtlsSessionLifecycleCallbacks, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(60)");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            sessionStore = NoOpsSessionStore.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            dtlsSessionLifecycleCallbacks = new DtlsSessionLifecycleCallbacks(){

                @Override
                public void handshakeStarted(@NotNull InetSocketAddress adr) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeStarted(this, adr);
                }

                @Override
                public void handshakeFinished(@NotNull InetSocketAddress adr, long hanshakeStartTimestamp, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeFinished(this, adr, hanshakeStartTimestamp, reason, throwable);
                }

                @Override
                public void sessionStarted(@NotNull InetSocketAddress adr, @NotNull String cipherSuite, boolean reloaded) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.sessionStarted(this, adr, cipherSuite, reloaded);
                }

                @Override
                public void sessionFinished(@NotNull InetSocketAddress adr, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished(this, adr, reason, throwable);
                }
            };
        }
        this(transport, sslConfig, duration, sessionStore, dtlsSessionLifecycleCallbacks);
    }

    @NotNull
    public final ScheduledThreadPoolExecutor executor() {
        return this.executor.getUnderlying();
    }

    @Override
    @NotNull
    public CompletableFuture<Packet<byte[]>> receive(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        CompletionStage completionStage = this.transport.receive(timeout).thenComposeAsync(arg_0 -> DtlsServer.receive$lambda$0((Function1)new Function1<Packet<ByteBuffer>, CompletionStage<Packet<byte[]>>>(this, timeout){
            final /* synthetic */ DtlsServer this$0;
            final /* synthetic */ Duration $timeout;
            {
                this.this$0 = $receiver;
                this.$timeout = $timeout;
                super(1);
            }

            public final CompletionStage<Packet<byte[]>> invoke(Packet<ByteBuffer> packet) {
                if (Intrinsics.areEqual(packet, Packet.Companion.getEmptyByteBufferPacket())) {
                    return CompletableFuture.completedFuture(Packet.Companion.getEmptyBytesPacket());
                }
                InetSocketAddress adr = packet.getPeerAddress();
                ByteBuffer buf = packet.getBuffer();
                return DtlsServer.access$handleReceived(this.this$0, adr, buf, this.$timeout);
            }
        }, arg_0), (Executor)this.executor);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun receive(tim\u2026       }, executor)\n    }");
        return completionStage;
    }

    private final CompletableFuture<Packet<byte[]>> handleReceived(InetSocketAddress adr, ByteBuffer buf, Duration timeout) {
        CompletionStage<Packet<Object>> completionStage;
        Lazy cid$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this, buf){
            final /* synthetic */ DtlsServer this$0;
            final /* synthetic */ ByteBuffer $buf;
            {
                this.this$0 = $receiver;
                this.$buf = $buf;
                super(0);
            }

            @Nullable
            public final byte[] invoke() {
                return SslContext.Companion.peekCID(DtlsServer.access$getCidSize$p(this.this$0), this.$buf);
            }
        }));
        DtlsState dtlsState = this.sessions.get(adr);
        if (dtlsState instanceof DtlsHandshake) {
            ((DtlsHandshake)dtlsState).step(buf);
            completionStage = this.receive(timeout);
        } else if (dtlsState instanceof DtlsSession) {
            byte[] plainBytes = ((DtlsSession)dtlsState).decrypt(buf);
            if (!(plainBytes.length == 0)) {
                CompletableFuture<Packet<byte[]>> completableFuture = CompletableFuture.completedFuture(new Packet<byte[]>(plainBytes, adr, ((DtlsSession)dtlsState).getSessionContext()));
                completionStage = completableFuture;
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Packet(p\u2026tlsState.sessionContext))");
            } else {
                completionStage = this.receive(timeout);
            }
        } else if (DtlsServer.handleReceived$lambda$1((Lazy<byte[]>)cid$delegate) != null) {
            ByteBuffer copyBuf = ExtensionsKt.copyDirect(buf);
            byte[] byArray = DtlsServer.handleReceived$lambda$1((Lazy<byte[]>)cid$delegate);
            Intrinsics.checkNotNull((Object)byArray);
            CompletionStage completionStage2 = this.loadSession(byArray, adr).thenCompose(arg_0 -> DtlsServer.handleReceived$lambda$2((Function1)new Function1<Boolean, CompletionStage<Packet<byte[]>>>(this, adr, copyBuf, timeout){
                final /* synthetic */ DtlsServer this$0;
                final /* synthetic */ InetSocketAddress $adr;
                final /* synthetic */ ByteBuffer $copyBuf;
                final /* synthetic */ Duration $timeout;
                {
                    this.this$0 = $receiver;
                    this.$adr = $adr;
                    this.$copyBuf = $copyBuf;
                    this.$timeout = $timeout;
                    super(1);
                }

                public final CompletionStage<Packet<byte[]>> invoke(Boolean isLoaded) {
                    Intrinsics.checkNotNullExpressionValue((Object)isLoaded, (String)"isLoaded");
                    return isLoaded != false ? DtlsServer.access$handleReceived(this.this$0, this.$adr, this.$copyBuf, this.$timeout) : this.this$0.receive(this.$timeout);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"private fun handleReceiv\u2026        }\n        }\n    }");
            completionStage = completionStage2;
        } else {
            this.sessions.put(adr, new DtlsHandshake(this.sslConfig.newContext(adr), adr));
            completionStage = this.handleReceived(adr, buf, timeout);
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> send(@NotNull Packet<byte[]> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        return SingleThreadExecutorKt.supply(this.executor, () -> DtlsServer.send$lambda$3(this, packet));
    }

    public final int numberOfSessions() {
        Integer n = SingleThreadExecutorKt.supply(this.executor, () -> DtlsServer.numberOfSessions$lambda$4(this)).join();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"executor.supply { sessions.size }.join()");
        return ((Number)n).intValue();
    }

    @NotNull
    public final CompletableFuture<Boolean> setSessionAuthenticationContext(@NotNull InetSocketAddress adr, @NotNull String authenticationContext) {
        Intrinsics.checkNotNullParameter((Object)adr, (String)"adr");
        Intrinsics.checkNotNullParameter((Object)authenticationContext, (String)"authenticationContext");
        return SingleThreadExecutorKt.supply(this.executor, () -> DtlsServer.setSessionAuthenticationContext$lambda$6(this, adr, authenticationContext));
    }

    @Override
    public int localPort() {
        return this.transport.localPort();
    }

    @Override
    public void close() {
        SingleThreadExecutorKt.supply(this.executor, () -> DtlsServer.close$lambda$7(this)).get(30L, TimeUnit.SECONDS);
        this.executor.shutdown();
    }

    private final CompletableFuture<Boolean> loadSession(byte[] cid2, InetSocketAddress adr) {
        CompletionStage completionStage = this.sessionStore.read(cid2).thenApplyAsync(arg_0 -> DtlsServer.loadSession$lambda$8((Function1)new Function1<SessionWithContext, Boolean>(this, adr, cid2){
            final /* synthetic */ DtlsServer this$0;
            final /* synthetic */ InetSocketAddress $adr;
            final /* synthetic */ byte[] $cid;
            {
                this.this$0 = $receiver;
                this.$adr = $adr;
                this.$cid = $cid;
                super(1);
            }

            public final Boolean invoke(@Nullable SessionWithContext sessBuf) {
                boolean bl;
                try {
                    boolean bl2;
                    if (sessBuf == null) {
                        DtlsServer.access$getLogger$p(this.this$0).warn("[{}] [CID:{}] DTLS session not found", (Object)this.$adr, (Object)ExtensionsKt.toHex(this.$cid));
                        bl2 = false;
                    } else {
                        DtlsSession dtlsSession = new DtlsSession(this.this$0, DtlsServer.access$getSslConfig$p(this.this$0).loadSession(this.$cid, sessBuf.getSessionBlob(), this.$adr), this.$adr, null, 4, null);
                        dtlsSession.setAuthenticationContext(sessBuf.getAuthenticationContext());
                        DtlsServer.access$getSessions$p(this.this$0).put(this.$adr, dtlsSession);
                        bl2 = true;
                    }
                    bl = bl2;
                }
                catch (SslException ex) {
                    Object[] objectArray = new Object[]{this.$adr, ExtensionsKt.toHex(this.$cid), ex.getMessage()};
                    DtlsServer.access$getLogger$p(this.this$0).warn("[{}] [CID:{}] Failed to load session: {}", objectArray);
                    bl = false;
                }
                return bl;
            }
        }, arg_0), (Executor)this.executor);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"private fun loadSession(\u2026       }, executor)\n    }");
        return completionStage;
    }

    private final void closeAndRemove(DtlsState $this$closeAndRemove) {
        this.sessions.remove($this$closeAndRemove.getPeerAddress(), $this$closeAndRemove);
    }

    @Override
    @NotNull
    public <P2> Transport<P2> map(@NotNull Function1<? super Packet<byte[]>, ? extends P2> f, @NotNull Function1<? super P2, Packet<byte[]>> f2) {
        return Transport.DefaultImpls.map(this, f, f2);
    }

    private static final CompletionStage receive$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final byte[] handleReceived$lambda$1(Lazy<byte[]> $cid$delegate) {
        Lazy<byte[]> lazy = $cid$delegate;
        return (byte[])lazy.getValue();
    }

    private static final CompletionStage handleReceived$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Boolean send$lambda$3(DtlsServer this$0, Packet $packet) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        DtlsState dtlsState = this$0.sessions.get($packet.getPeerAddress());
        if (dtlsState instanceof DtlsSession) {
            this$0.transport.send($packet.map((Function1)new Function1<byte[], ByteBuffer>((Object)dtlsState){

                @NotNull
                public final ByteBuffer invoke(@NotNull byte[] p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DtlsSession)this.receiver).encrypt(p0);
                }
            }));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Integer numberOfSessions$lambda$4(DtlsServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.sessions.size();
    }

    private static final Boolean setSessionAuthenticationContext$lambda$6(DtlsServer this$0, InetSocketAddress $adr, String $authenticationContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$adr, (String)"$adr");
        Intrinsics.checkNotNullParameter((Object)$authenticationContext, (String)"$authenticationContext");
        DtlsState dtlsState = this$0.sessions.get($adr);
        DtlsSession dtlsSession = dtlsState instanceof DtlsSession ? (DtlsSession)dtlsState : null;
        if (dtlsSession != null) {
            dtlsSession.setAuthenticationContext($authenticationContext);
            Unit it = Unit.INSTANCE;
            boolean bl2 = false;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Unit close$lambda$7(DtlsServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.transport.close();
        Iterator<Map.Entry<InetSocketAddress, DtlsState>> iterator = this$0.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            DtlsState dtlsState = iterator.next().getValue();
            iterator.remove();
            dtlsState.storeAndClose();
        }
        return Unit.INSTANCE;
    }

    private static final Boolean loadSession$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServer create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks) {
        return Companion.create(config, listenPort, expireAfter, sessionStore, lifecycleCallbacks);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServer create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore) {
        return Companion.create(config, listenPort, expireAfter, sessionStore);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServer create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter) {
        return Companion.create(config, listenPort, expireAfter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServer create(@NotNull SslConfig config, int listenPort) {
        return Companion.create(config, listenPort);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServer create(@NotNull SslConfig config) {
        return Companion.create(config);
    }

    public static final /* synthetic */ CompletableFuture access$handleReceived(DtlsServer $this, InetSocketAddress adr, ByteBuffer buf, Duration timeout) {
        return $this.handleReceived(adr, buf, timeout);
    }

    public static final /* synthetic */ int access$getCidSize$p(DtlsServer $this) {
        return $this.cidSize;
    }

    public static final /* synthetic */ SslConfig access$getSslConfig$p(DtlsServer $this) {
        return $this.sslConfig;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$Companion;", "", "()V", "EMPTY_BUFFER", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "create", "Lorg/opencoap/ssl/transport/DtlsServer;", "config", "Lorg/opencoap/ssl/SslConfig;", "listenPort", "", "expireAfter", "Ljava/time/Duration;", "sessionStore", "Lorg/opencoap/ssl/transport/SessionStore;", "lifecycleCallbacks", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServer create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
            Intrinsics.checkNotNullParameter((Object)lifecycleCallbacks, (String)"lifecycleCallbacks");
            Transport<Packet<ByteBuffer>> channel = DatagramChannelAdapter.Companion.open(listenPort);
            return new DtlsServer(channel, config, expireAfter, sessionStore, lifecycleCallbacks);
        }

        public static /* synthetic */ DtlsServer create$default(Companion companion, SslConfig sslConfig, int n, Duration duration, SessionStore sessionStore, DtlsSessionLifecycleCallbacks dtlsSessionLifecycleCallbacks, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                Duration duration2 = Duration.ofSeconds(60L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(60)");
                duration = duration2;
            }
            if ((n2 & 8) != 0) {
                sessionStore = NoOpsSessionStore.INSTANCE;
            }
            if ((n2 & 0x10) != 0) {
                dtlsSessionLifecycleCallbacks = new DtlsSessionLifecycleCallbacks(){

                    public void handshakeStarted(@NotNull InetSocketAddress adr) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeStarted(this, adr);
                    }

                    public void handshakeFinished(@NotNull InetSocketAddress adr, long hanshakeStartTimestamp, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeFinished(this, adr, hanshakeStartTimestamp, reason, throwable);
                    }

                    public void sessionStarted(@NotNull InetSocketAddress adr, @NotNull String cipherSuite, boolean reloaded) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.sessionStarted(this, adr, cipherSuite, reloaded);
                    }

                    public void sessionFinished(@NotNull InetSocketAddress adr, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished(this, adr, reason, throwable);
                    }
                };
            }
            return companion.create(sslConfig, n, duration, sessionStore, dtlsSessionLifecycleCallbacks);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServer create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
            return org.opencoap.ssl.transport.DtlsServer$Companion.create$default(this, config, listenPort, expireAfter, sessionStore, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServer create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            return org.opencoap.ssl.transport.DtlsServer$Companion.create$default(this, config, listenPort, expireAfter, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServer create(@NotNull SslConfig config, int listenPort) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return org.opencoap.ssl.transport.DtlsServer$Companion.create$default(this, config, listenPort, null, null, null, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServer create(@NotNull SslConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return org.opencoap.ssl.transport.DtlsServer$Companion.create$default(this, config, 0, null, null, null, 30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "", "peerAddress", "Ljava/net/InetSocketAddress;", "(Ljava/net/InetSocketAddress;)V", "getPeerAddress", "()Ljava/net/InetSocketAddress;", "scheduledTask", "Ljava/util/concurrent/ScheduledFuture;", "getScheduledTask", "()Ljava/util/concurrent/ScheduledFuture;", "setScheduledTask", "(Ljava/util/concurrent/ScheduledFuture;)V", "storeAndClose", "", "storeAndClose0", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsHandshake;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsSession;", "kotlin-mbedtls"})
    private static abstract class DtlsState {
        @NotNull
        private final InetSocketAddress peerAddress;
        @Nullable
        private ScheduledFuture<?> scheduledTask;

        private DtlsState(InetSocketAddress peerAddress) {
            this.peerAddress = peerAddress;
        }

        @NotNull
        public final InetSocketAddress getPeerAddress() {
            return this.peerAddress;
        }

        @Nullable
        protected final ScheduledFuture<?> getScheduledTask() {
            return this.scheduledTask;
        }

        protected final void setScheduledTask(@Nullable ScheduledFuture<?> scheduledFuture) {
            this.scheduledTask = scheduledFuture;
        }

        public abstract void storeAndClose0();

        public final void storeAndClose() {
            ScheduledFuture<?> scheduledFuture = this.scheduledTask;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            this.storeAndClose0();
        }

        public /* synthetic */ DtlsState(InetSocketAddress peerAddress, DefaultConstructorMarker $constructor_marker) {
            this(peerAddress);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0011J\b\u0010\u0014\u001a\u00020\bH\u0016J\u0006\u0010\u0015\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$DtlsHandshake;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "ctx", "Lorg/opencoap/ssl/SslHandshakeContext;", "peerAddress", "Ljava/net/InetSocketAddress;", "(Lorg/opencoap/ssl/transport/DtlsServer;Lorg/opencoap/ssl/SslHandshakeContext;Ljava/net/InetSocketAddress;)V", "reportHandshakeFinished", "", "reason", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks$Reason;", "err", "", "reportHandshakeStarted", "retryStep", "send", "buf", "Ljava/nio/ByteBuffer;", "step", "encPacket", "storeAndClose0", "timeout", "kotlin-mbedtls"})
    private final class DtlsHandshake
    extends DtlsState {
        @NotNull
        private final SslHandshakeContext ctx;

        public DtlsHandshake(@NotNull SslHandshakeContext ctx, InetSocketAddress peerAddress) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
            super(peerAddress, null);
            this.ctx = ctx;
            this.reportHandshakeStarted();
        }

        private final void send(ByteBuffer buf) {
            DtlsServer.this.transport.send(new Packet(buf, this.getPeerAddress(), null, 4, null));
        }

        private final void retryStep() {
            ByteBuffer byteBuffer = EMPTY_BUFFER;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"EMPTY_BUFFER");
            this.step(byteBuffer);
        }

        public final void step(@NotNull ByteBuffer encPacket) {
            Intrinsics.checkNotNullParameter((Object)encPacket, (String)"encPacket");
            ScheduledFuture<?> scheduledFuture = this.getScheduledTask();
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            try {
                SslContext newCtx2 = this.ctx.step(encPacket, (Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>((Object)this){

                    public final void invoke(@NotNull ByteBuffer p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        DtlsHandshake.access$send((DtlsHandshake)this.receiver, p0);
                    }
                }));
                if (newCtx2 instanceof SslHandshakeContext) {
                    this.setScheduledTask(!((SslHandshakeContext)newCtx2).getReadTimeout().isZero() ? SingleThreadExecutorKt.schedule(DtlsServer.this.executor, this::retryStep, ((SslHandshakeContext)newCtx2).getReadTimeout()) : SingleThreadExecutorKt.schedule(DtlsServer.this.executor, this::timeout, DtlsServer.this.expireAfter));
                } else if (newCtx2 instanceof SslSession) {
                    DtlsHandshake.reportHandshakeFinished$default(this, DtlsSessionLifecycleCallbacks.Reason.SUCCEEDED, null, 2, null);
                    DtlsServer.this.sessions.put(this.getPeerAddress(), new DtlsSession(DtlsServer.this, (SslSession)newCtx2, this.getPeerAddress(), null, 4, null));
                }
            }
            catch (Exception ex) {
                Exception exception = ex;
                if (!(exception instanceof HelloVerifyRequired)) {
                    if (exception instanceof SslException) {
                        DtlsServer.this.logger.warn("[{}] DTLS failed: {}", (Object)this.getPeerAddress(), (Object)ex.getMessage());
                    } else {
                        DtlsServer.this.logger.error(ex.toString(), (Throwable)ex);
                    }
                }
                this.reportHandshakeFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
                DtlsServer.this.closeAndRemove(this);
            }
        }

        public final void timeout() {
            DtlsHandshake.reportHandshakeFinished$default(this, DtlsSessionLifecycleCallbacks.Reason.EXPIRED, null, 2, null);
            DtlsServer.this.closeAndRemove(this);
            DtlsServer.this.logger.warn("[{}] DTLS handshake expired", (Object)this.getPeerAddress());
        }

        @Override
        public void storeAndClose0() {
            this.ctx.close();
        }

        private final void reportHandshakeStarted() {
            DtlsServer.this.lifecycleCallbacks.handshakeStarted(this.getPeerAddress());
        }

        private final void reportHandshakeFinished(DtlsSessionLifecycleCallbacks.Reason reason, Throwable err) {
            DtlsServer.this.lifecycleCallbacks.handshakeFinished(this.getPeerAddress(), this.ctx.getStartTimestamp(), reason, err);
        }

        static /* synthetic */ void reportHandshakeFinished$default(DtlsHandshake dtlsHandshake, DtlsSessionLifecycleCallbacks.Reason reason, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            dtlsHandshake.reportHandshakeFinished(reason, throwable);
        }

        public static final /* synthetic */ void access$send(DtlsHandshake $this, ByteBuffer buf) {
            $this.send(buf);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eJ\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0006\u0010\u001e\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$DtlsSession;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "ctx", "Lorg/opencoap/ssl/SslSession;", "peerAddress", "Ljava/net/InetSocketAddress;", "sessionContext", "Lorg/opencoap/ssl/transport/DtlsSessionContext;", "(Lorg/opencoap/ssl/transport/DtlsServer;Lorg/opencoap/ssl/SslSession;Ljava/net/InetSocketAddress;Lorg/opencoap/ssl/transport/DtlsSessionContext;)V", "getSessionContext", "()Lorg/opencoap/ssl/transport/DtlsSessionContext;", "setSessionContext", "(Lorg/opencoap/ssl/transport/DtlsSessionContext;)V", "decrypt", "", "encPacket", "Ljava/nio/ByteBuffer;", "encrypt", "plainPacket", "reportSessionFinished", "", "reason", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks$Reason;", "err", "", "reportSessionStarted", "setAuthenticationContext", "authentication", "", "storeAndClose0", "timeout", "kotlin-mbedtls"})
    private final class DtlsSession
    extends DtlsState {
        @NotNull
        private final SslSession ctx;
        @NotNull
        private DtlsSessionContext sessionContext;
        final /* synthetic */ DtlsServer this$0;

        public DtlsSession(@NotNull DtlsServer this$0, @NotNull SslSession ctx, @NotNull InetSocketAddress peerAddress, DtlsSessionContext sessionContext) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
            Intrinsics.checkNotNullParameter((Object)sessionContext, (String)"sessionContext");
            this.this$0 = this$0;
            super(peerAddress, null);
            this.ctx = ctx;
            this.sessionContext = sessionContext;
            this.reportSessionStarted();
        }

        public /* synthetic */ DtlsSession(DtlsServer dtlsServer, SslSession sslSession, InetSocketAddress inetSocketAddress, DtlsSessionContext dtlsSessionContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                dtlsSessionContext = new DtlsSessionContext(null, sslSession.getPeerCertificateSubject(), 1, null);
            }
            this(dtlsServer, sslSession, inetSocketAddress, dtlsSessionContext);
        }

        @NotNull
        public final DtlsSessionContext getSessionContext() {
            return this.sessionContext;
        }

        public final void setSessionContext(@NotNull DtlsSessionContext dtlsSessionContext) {
            Intrinsics.checkNotNullParameter((Object)dtlsSessionContext, (String)"<set-?>");
            this.sessionContext = dtlsSessionContext;
        }

        @Override
        public void storeAndClose0() {
            if (this.ctx.getOwnCid() != null) {
                try {
                    SessionWithContext session = new SessionWithContext(this.ctx.saveAndClose(), this.sessionContext.getAuthentication());
                    this.this$0.sessionStore.write(this.ctx.getOwnCid(), session);
                }
                catch (SslException ex) {
                    Object[] objectArray = new Object[]{this.getPeerAddress(), ex.getMessage(), ExtensionsKt.toHex(this.ctx.getOwnCid())};
                    this.this$0.logger.warn("[{}] DTLS failed to store session: {}, CID:{}", objectArray);
                }
            } else {
                this.ctx.close();
            }
        }

        @NotNull
        public final byte[] decrypt(@NotNull ByteBuffer encPacket) {
            Intrinsics.checkNotNullParameter((Object)encPacket, (String)"encPacket");
            ScheduledFuture<?> scheduledFuture = this.getScheduledTask();
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            try {
                byte[] plainBuf = this.ctx.decrypt(encPacket);
                this.setScheduledTask(SingleThreadExecutorKt.schedule(this.this$0.executor, this::timeout, this.this$0.expireAfter));
                return plainBuf;
            }
            catch (CloseNotifyException ex) {
                this.this$0.logger.info("[{}] DTLS received close notify", (Object)this.getPeerAddress());
                DtlsSession.reportSessionFinished$default(this, DtlsSessionLifecycleCallbacks.Reason.CLOSED, null, 2, null);
            }
            catch (SslException ex) {
                this.this$0.logger.warn("[{}] DTLS failed: {}", (Object)this.getPeerAddress(), (Object)ex.getMessage());
                this.reportSessionFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
            }
            this.this$0.closeAndRemove(this);
            return new byte[0];
        }

        @NotNull
        public final ByteBuffer encrypt(@NotNull byte[] plainPacket) {
            Intrinsics.checkNotNullParameter((Object)plainPacket, (String)"plainPacket");
            try {
                return this.ctx.encrypt(plainPacket);
            }
            catch (SslException ex) {
                this.this$0.logger.warn("[{}] DTLS failed: {}", (Object)this.getPeerAddress(), (Object)ex.getMessage());
                this.reportSessionFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
                this.this$0.closeAndRemove(this);
                throw ex;
            }
        }

        public final void timeout() {
            DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished$default(this.this$0.lifecycleCallbacks, this.getPeerAddress(), DtlsSessionLifecycleCallbacks.Reason.EXPIRED, null, 4, null);
            this.this$0.sessions.remove(this.getPeerAddress(), this);
            this.this$0.logger.info("[{}] DTLS connection expired", (Object)this.getPeerAddress());
            this.storeAndClose();
        }

        public final void setAuthenticationContext(@Nullable String authentication) {
            this.sessionContext = DtlsSessionContext.copy$default(this.sessionContext, authentication, null, 2, null);
        }

        private final void reportSessionStarted() {
            this.this$0.lifecycleCallbacks.sessionStarted(this.getPeerAddress(), this.ctx.getCipherSuite(), this.ctx.getReloaded());
        }

        private final void reportSessionFinished(DtlsSessionLifecycleCallbacks.Reason reason, Throwable err) {
            this.this$0.lifecycleCallbacks.sessionFinished(this.getPeerAddress(), reason, err);
        }

        static /* synthetic */ void reportSessionFinished$default(DtlsSession dtlsSession, DtlsSessionLifecycleCallbacks.Reason reason, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            dtlsSession.reportSessionFinished(reason, throwable);
        }
    }
}

