/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.transport.ExtensionsKt;
import org.opencoap.ssl.transport.SessionStore;
import org.opencoap.ssl.transport.SessionWithContext;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opencoap/ssl/transport/HashMapSessionStore;", "Lorg/opencoap/ssl/transport/SessionStore;", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/opencoap/ssl/transport/SessionWithContext;", "clear", "", "read", "Ljava/util/concurrent/CompletableFuture;", "cid", "", "size", "", "write", "session", "kotlin-mbedtls"})
public final class HashMapSessionStore
implements SessionStore {
    @NotNull
    private final ConcurrentHashMap<String, SessionWithContext> map = new ConcurrentHashMap();

    @Override
    @NotNull
    public CompletableFuture<SessionWithContext> read(@NotNull byte[] cid2) {
        Intrinsics.checkNotNullParameter((Object)cid2, (String)"cid");
        CompletableFuture<SessionWithContext> completableFuture = CompletableFuture.completedFuture(this.map.remove(ExtensionsKt.toHex(cid2)));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(map.remove(cid.toHex()))");
        return completableFuture;
    }

    @Override
    public void write(@NotNull byte[] cid2, @NotNull SessionWithContext session) {
        Intrinsics.checkNotNullParameter((Object)cid2, (String)"cid");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.map.put(ExtensionsKt.toHex(cid2), session);
    }

    public final void clear() {
        this.map.clear();
    }

    public final int size() {
        return this.map.size();
    }
}

