/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.AuthConfig;
import org.opencoap.ssl.MbedtlsApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B%\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J5\u0010\u001c\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006&"}, d2={"Lorg/opencoap/ssl/CertificateAuth;", "Lorg/opencoap/ssl/AuthConfig;", "ownCertChain", "", "Ljava/security/cert/X509Certificate;", "privateKey", "Ljava/security/PrivateKey;", "trustedCert", "(Ljava/util/List;Ljava/security/PrivateKey;Ljava/security/cert/X509Certificate;)V", "(Ljava/util/List;Ljava/security/PrivateKey;)V", "trustedCerts", "(Ljava/util/List;Ljava/security/PrivateKey;Ljava/util/List;)V", "getOwnCertChain", "()Ljava/util/List;", "getPrivateKey", "()Ljava/security/PrivateKey;", "getTrustedCerts", "component1", "component2", "component3", "configure", "", "sslConfig", "Lcom/sun/jna/Memory;", "caCert", "ownCert", "pkey", "ctrDrbg", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "kotlin-mbedtls"})
public final class CertificateAuth
implements AuthConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<X509Certificate> ownCertChain;
    @Nullable
    private final PrivateKey privateKey;
    @NotNull
    private final List<X509Certificate> trustedCerts;

    public CertificateAuth(@NotNull List<? extends X509Certificate> ownCertChain, @Nullable PrivateKey privateKey, @NotNull List<? extends X509Certificate> trustedCerts) {
        Intrinsics.checkNotNullParameter(ownCertChain, (String)"ownCertChain");
        Intrinsics.checkNotNullParameter(trustedCerts, (String)"trustedCerts");
        this.ownCertChain = ownCertChain;
        this.privateKey = privateKey;
        this.trustedCerts = trustedCerts;
    }

    @NotNull
    public final List<X509Certificate> getOwnCertChain() {
        return this.ownCertChain;
    }

    @Nullable
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final List<X509Certificate> getTrustedCerts() {
        return this.trustedCerts;
    }

    public CertificateAuth(@NotNull List<? extends X509Certificate> ownCertChain, @NotNull PrivateKey privateKey, @NotNull X509Certificate trustedCert) {
        Intrinsics.checkNotNullParameter(ownCertChain, (String)"ownCertChain");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)trustedCert, (String)"trustedCert");
        this(ownCertChain, privateKey, CollectionsKt.listOf((Object)trustedCert));
    }

    public CertificateAuth(@NotNull List<? extends X509Certificate> ownCertChain, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(ownCertChain, (String)"ownCertChain");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this(ownCertChain, privateKey, CollectionsKt.emptyList());
    }

    @Override
    public void configure(@NotNull Memory sslConfig, @NotNull Memory caCert, @NotNull Memory ownCert, @NotNull Memory pkey, @NotNull Memory ctrDrbg) {
        byte[] certDer;
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)caCert, (String)"caCert");
        Intrinsics.checkNotNullParameter((Object)ownCert, (String)"ownCert");
        Intrinsics.checkNotNullParameter((Object)pkey, (String)"pkey");
        Intrinsics.checkNotNullParameter((Object)ctrDrbg, (String)"ctrDrbg");
        for (X509Certificate cert : this.trustedCerts) {
            certDer = cert.getEncoded();
            Pointer pointer = (Pointer)caCert;
            Intrinsics.checkNotNull((Object)certDer);
            MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.X509.INSTANCE.mbedtls_x509_crt_parse_der(pointer, certDer, certDer.length));
        }
        MbedtlsApi.INSTANCE.mbedtls_ssl_conf_ca_chain((Pointer)sslConfig, (Pointer)caCert, Pointer.NULL);
        for (X509Certificate cert : this.ownCertChain) {
            certDer = cert.getEncoded();
            Pointer pointer = (Pointer)ownCert;
            Intrinsics.checkNotNull((Object)certDer);
            MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.X509.INSTANCE.mbedtls_x509_crt_parse_der(pointer, certDer, certDer.length));
        }
        if (this.privateKey != null) {
            Pointer pointer = (Pointer)pkey;
            byte[] byArray = this.privateKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            int n = this.privateKey.getEncoded().length;
            Function function = MbedtlsApi.Crypto.INSTANCE.getMbedtls_ctr_drbg_random$kotlin_mbedtls();
            Intrinsics.checkNotNullExpressionValue((Object)function, (String)"<get-mbedtls_ctr_drbg_random>(...)");
            MbedtlsApi.Crypto.INSTANCE.mbedtls_pk_parse_key(pointer, byArray, n, Pointer.NULL, 0, (Pointer)function, (Pointer)ctrDrbg);
            MbedtlsApi.INSTANCE.mbedtls_ssl_conf_own_cert((Pointer)sslConfig, ownCert, (Pointer)pkey);
        }
    }

    @NotNull
    public final List<X509Certificate> component1() {
        return this.ownCertChain;
    }

    @Nullable
    public final PrivateKey component2() {
        return this.privateKey;
    }

    @NotNull
    public final List<X509Certificate> component3() {
        return this.trustedCerts;
    }

    @NotNull
    public final CertificateAuth copy(@NotNull List<? extends X509Certificate> ownCertChain, @Nullable PrivateKey privateKey, @NotNull List<? extends X509Certificate> trustedCerts) {
        Intrinsics.checkNotNullParameter(ownCertChain, (String)"ownCertChain");
        Intrinsics.checkNotNullParameter(trustedCerts, (String)"trustedCerts");
        return new CertificateAuth(ownCertChain, privateKey, trustedCerts);
    }

    public static /* synthetic */ CertificateAuth copy$default(CertificateAuth certificateAuth, List list, PrivateKey privateKey, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = certificateAuth.ownCertChain;
        }
        if ((n & 2) != 0) {
            privateKey = certificateAuth.privateKey;
        }
        if ((n & 4) != 0) {
            list2 = certificateAuth.trustedCerts;
        }
        return certificateAuth.copy(list, privateKey, list2);
    }

    @NotNull
    public String toString() {
        return "CertificateAuth(ownCertChain=" + this.ownCertChain + ", privateKey=" + this.privateKey + ", trustedCerts=" + this.trustedCerts + ')';
    }

    public int hashCode() {
        int result = ((Object)this.ownCertChain).hashCode();
        result = result * 31 + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = result * 31 + ((Object)this.trustedCerts).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CertificateAuth)) {
            return false;
        }
        CertificateAuth certificateAuth = (CertificateAuth)other;
        if (!Intrinsics.areEqual(this.ownCertChain, certificateAuth.ownCertChain)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.privateKey, (Object)certificateAuth.privateKey)) {
            return false;
        }
        return Intrinsics.areEqual(this.trustedCerts, certificateAuth.trustedCerts);
    }

    @JvmStatic
    @NotNull
    public static final CertificateAuth trusted(@NotNull List<? extends X509Certificate> trustedCerts) {
        return Companion.trusted(trustedCerts);
    }

    @JvmStatic
    @NotNull
    public static final CertificateAuth trusted(X509Certificate ... trustedCerts) {
        return Companion.trusted(trustedCerts);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/opencoap/ssl/CertificateAuth$Companion;", "", "()V", "trusted", "Lorg/opencoap/ssl/CertificateAuth;", "trustedCerts", "", "Ljava/security/cert/X509Certificate;", "([Ljava/security/cert/X509Certificate;)Lorg/opencoap/ssl/CertificateAuth;", "", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CertificateAuth trusted(@NotNull List<? extends X509Certificate> trustedCerts) {
            Intrinsics.checkNotNullParameter(trustedCerts, (String)"trustedCerts");
            return new CertificateAuth((List<? extends X509Certificate>)CollectionsKt.emptyList(), null, CollectionsKt.toList((Iterable)trustedCerts));
        }

        @JvmStatic
        @NotNull
        public final CertificateAuth trusted(X509Certificate ... trustedCerts) {
            Intrinsics.checkNotNullParameter((Object)trustedCerts, (String)"trustedCerts");
            return this.trusted(ArraysKt.toList((Object[])trustedCerts));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

