/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.AuthConfig;
import org.opencoap.ssl.MbedtlsApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/opencoap/ssl/PskAuth;", "Lorg/opencoap/ssl/AuthConfig;", "pskId", "", "pskSecret", "", "(Ljava/lang/String;[B)V", "([B[B)V", "getPskId", "()[B", "getPskSecret", "component1", "component2", "configure", "", "sslConfig", "Lcom/sun/jna/Memory;", "caCert", "ownCert", "pkey", "ctrDrbg", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin-mbedtls"})
public final class PskAuth
implements AuthConfig {
    @NotNull
    private final byte[] pskId;
    @NotNull
    private final byte[] pskSecret;

    public PskAuth(@NotNull byte[] pskId, @NotNull byte[] pskSecret) {
        Intrinsics.checkNotNullParameter((Object)pskId, (String)"pskId");
        Intrinsics.checkNotNullParameter((Object)pskSecret, (String)"pskSecret");
        this.pskId = pskId;
        this.pskSecret = pskSecret;
    }

    @NotNull
    public final byte[] getPskId() {
        return this.pskId;
    }

    @NotNull
    public final byte[] getPskSecret() {
        return this.pskSecret;
    }

    public PskAuth(@NotNull String pskId, @NotNull byte[] pskSecret) {
        Intrinsics.checkNotNullParameter((Object)pskId, (String)"pskId");
        Intrinsics.checkNotNullParameter((Object)pskSecret, (String)"pskSecret");
        this(StringsKt.encodeToByteArray((String)pskId), pskSecret);
    }

    @Override
    public void configure(@NotNull Memory sslConfig, @NotNull Memory caCert, @NotNull Memory ownCert, @NotNull Memory pkey, @NotNull Memory ctrDrbg) {
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)caCert, (String)"caCert");
        Intrinsics.checkNotNullParameter((Object)ownCert, (String)"ownCert");
        Intrinsics.checkNotNullParameter((Object)pkey, (String)"pkey");
        Intrinsics.checkNotNullParameter((Object)ctrDrbg, (String)"ctrDrbg");
        MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_conf_psk((Pointer)sslConfig, this.pskSecret, this.pskSecret.length, this.pskId, this.pskId.length));
    }

    @NotNull
    public final byte[] component1() {
        return this.pskId;
    }

    @NotNull
    public final byte[] component2() {
        return this.pskSecret;
    }

    @NotNull
    public final PskAuth copy(@NotNull byte[] pskId, @NotNull byte[] pskSecret) {
        Intrinsics.checkNotNullParameter((Object)pskId, (String)"pskId");
        Intrinsics.checkNotNullParameter((Object)pskSecret, (String)"pskSecret");
        return new PskAuth(pskId, pskSecret);
    }

    public static /* synthetic */ PskAuth copy$default(PskAuth pskAuth, byte[] byArray, byte[] byArray2, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = pskAuth.pskId;
        }
        if ((n & 2) != 0) {
            byArray2 = pskAuth.pskSecret;
        }
        return pskAuth.copy(byArray, byArray2);
    }

    @NotNull
    public String toString() {
        return "PskAuth(pskId=" + Arrays.toString(this.pskId) + ", pskSecret=" + Arrays.toString(this.pskSecret) + ')';
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.pskId);
        result = result * 31 + Arrays.hashCode(this.pskSecret);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PskAuth)) {
            return false;
        }
        PskAuth pskAuth = (PskAuth)other;
        if (!Intrinsics.areEqual((Object)this.pskId, (Object)pskAuth.pskId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pskSecret, (Object)pskAuth.pskSecret);
    }
}

