/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.MbedtlsApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ,\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/opencoap/ssl/ReceiveCallback;", "Lcom/sun/jna/Callback;", "()V", "buffer", "Ljava/lang/ThreadLocal;", "Ljava/nio/ByteBuffer;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "timeout", "", "callback", "ctx", "Lcom/sun/jna/Pointer;", "bufPointer", "len", "invoke", "T", "buf", "readFun", "Lkotlin/Function0;", "(Ljava/nio/ByteBuffer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-mbedtls"})
public final class ReceiveCallback
implements Callback {
    @NotNull
    public static final ReceiveCallback INSTANCE = new ReceiveCallback();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
    @NotNull
    private static final ThreadLocal<ByteBuffer> buffer = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<Integer> timeout = new ThreadLocal();

    private ReceiveCallback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T invoke(@Nullable ByteBuffer buf, @NotNull Function0<? extends T> readFun) {
        Intrinsics.checkNotNullParameter(readFun, (String)"readFun");
        buffer.set(buf);
        try {
            Object object = readFun.invoke();
            return (T)object;
        }
        finally {
            buffer.remove();
            timeout.remove();
        }
    }

    public final int timeout() {
        Integer n = timeout.get();
        return n == null ? 0 : n;
    }

    public final int callback(@Nullable Pointer ctx, @NotNull Pointer bufPointer, int len, int timeout) {
        Intrinsics.checkNotNullParameter((Object)bufPointer, (String)"bufPointer");
        ByteBuffer buffer = ReceiveCallback.buffer.get();
        ReceiveCallback.buffer.remove();
        ReceiveCallback.timeout.set(timeout);
        try {
            int n;
            if (buffer == null) {
                n = -26880;
            } else if (!buffer.hasRemaining() && timeout == 0) {
                n = -26880;
            } else if (!buffer.hasRemaining()) {
                n = -26624;
            } else {
                int size2 = RangesKt.coerceAtMost((int)buffer.remaining(), (int)len);
                buffer.limit(buffer.position() + size2);
                bufPointer.getByteBuffer(0L, (long)len).put(buffer);
                n = size2;
            }
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return MbedtlsApi.INSTANCE.getMBEDTLS_ERR_NET_RECV_FAILED();
        }
    }
}

