/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.MbedtlsApi;
import org.opencoap.ssl.ReceiveCallback;
import org.opencoap.ssl.SendCallback;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslContext;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.transport.BytesExtensionsKt;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0 J*\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0 J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cJ\n\u0010$\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010%\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010&\u001a\u00020\bJ\u0010\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\u001cH\u0002J\b\u0010)\u001a\u00020\rH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/opencoap/ssl/SslSession;", "Lorg/opencoap/ssl/SslContext;", "Ljava/io/Closeable;", "conf", "Lorg/opencoap/ssl/SslConfig;", "sslContext", "Lcom/sun/jna/Memory;", "cid", "", "reloaded", "", "(Lorg/opencoap/ssl/SslConfig;Lcom/sun/jna/Memory;[BZ)V", "cipherSuite", "", "getCipherSuite", "()Ljava/lang/String;", "ownCid", "getOwnCid", "()[B", "peerCertificateSubject", "getPeerCertificateSubject", "peerCid", "getPeerCid", "getReloaded", "()Z", "close", "", "closeNotify", "Ljava/nio/ByteBuffer;", "decrypt", "encBuffer", "send", "Lkotlin/Function1;", "plainBuffer", "encrypt", "data", "readPeerCertificateSubject", "readPeerCid", "saveAndClose", "sslRead", "", "toString", "kotlin-mbedtls"})
public final class SslSession
implements SslContext,
Closeable {
    @NotNull
    private final SslConfig conf;
    @NotNull
    private final Memory sslContext;
    @Nullable
    private final byte[] cid;
    private final boolean reloaded;
    @Nullable
    private final byte[] peerCid;
    @Nullable
    private final byte[] ownCid;
    @Nullable
    private final String peerCertificateSubject;

    public SslSession(@NotNull SslConfig conf, @NotNull Memory sslContext, @Nullable byte[] cid2, boolean reloaded) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)sslContext, (String)"sslContext");
        this.conf = conf;
        this.sslContext = sslContext;
        this.cid = cid2;
        this.reloaded = reloaded;
        this.peerCid = this.readPeerCid();
        this.ownCid = this.peerCid != null ? this.cid : null;
        this.peerCertificateSubject = this.readPeerCertificateSubject();
    }

    public /* synthetic */ SslSession(SslConfig sslConfig, Memory memory, byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(sslConfig, memory, byArray, bl);
    }

    public final boolean getReloaded() {
        return this.reloaded;
    }

    @Nullable
    public final byte[] getPeerCid() {
        return this.peerCid;
    }

    @Nullable
    public final byte[] getOwnCid() {
        return this.ownCid;
    }

    @Nullable
    public final String getPeerCertificateSubject() {
        return this.peerCertificateSubject;
    }

    private final byte[] readPeerCid() {
        Memory mem = new Memory(80L);
        Pointer pointer = (Pointer)this.sslContext;
        Pointer pointer2 = (Pointer)mem;
        Pointer pointer3 = mem.share(16L);
        Intrinsics.checkNotNullExpressionValue((Object)pointer3, (String)"share(...)");
        Pointer pointer4 = mem.share(8L);
        Intrinsics.checkNotNullExpressionValue((Object)pointer4, (String)"share(...)");
        MbedtlsApi.INSTANCE.mbedtls_ssl_get_peer_cid(pointer, pointer2, pointer3, pointer4);
        if (mem.getInt(0L) == 0) {
            return null;
        }
        int size2 = mem.getInt(8L);
        return mem.getByteArray(16L, size2);
    }

    private final String readPeerCertificateSubject() {
        String string;
        Pointer pointer;
        Pointer pointer2 = MbedtlsApi.INSTANCE.mbedtls_ssl_get_peer_cert((Pointer)this.sslContext);
        Pointer pointer3 = pointer = pointer2 != null ? pointer2.share(8L) : null;
        if (pointer == null) {
            return null;
        }
        Pointer pointer4 = pointer;
        int derLen = pointer4.getInt(8L);
        Pointer derPointer = pointer4.getPointer(16L);
        byte[] der = derPointer.getByteArray(0L, derLen);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Intrinsics.checkNotNull((Object)der);
            Certificate certificate = factory.generateCertificate(new ByteArrayInputStream(der));
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate cert = (X509Certificate)certificate;
            string = cert.getSubjectX500Principal().getName();
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not parse peer certificate: {}", (Object)ex, (Object)ex);
            string = null;
        }
        return string;
    }

    @NotNull
    public final String getCipherSuite() {
        return MbedtlsApi.INSTANCE.mbedtls_ssl_get_ciphersuite((Pointer)this.sslContext);
    }

    @NotNull
    public final ByteBuffer encrypt(@NotNull ByteBuffer data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ByteBuffer byteBuffer = SendCallback.INSTANCE.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this, data){
            final /* synthetic */ SslSession this$0;
            final /* synthetic */ ByteBuffer $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_write((Pointer)SslSession.access$getSslContext$p(this.this$0), this.$data, this.$data.remaining()));
            }
        }));
        if (byteBuffer == null) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(0);
            byteBuffer = byteBuffer2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocate(...)");
        }
        return byteBuffer;
    }

    public final void decrypt(@NotNull ByteBuffer encBuffer, @NotNull ByteBuffer plainBuffer, @NotNull Function1<? super ByteBuffer, Unit> send2) {
        Intrinsics.checkNotNullParameter((Object)encBuffer, (String)"encBuffer");
        Intrinsics.checkNotNullParameter((Object)plainBuffer, (String)"plainBuffer");
        Intrinsics.checkNotNullParameter(send2, (String)"send");
        int size2 = ((Number)SendCallback.INSTANCE.invoke(send2, (Function0)new Function0<Integer>(encBuffer, this, plainBuffer){
            final /* synthetic */ ByteBuffer $encBuffer;
            final /* synthetic */ SslSession this$0;
            final /* synthetic */ ByteBuffer $plainBuffer;
            {
                this.$encBuffer = $encBuffer;
                this.this$0 = $receiver;
                this.$plainBuffer = $plainBuffer;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return (Integer)ReceiveCallback.INSTANCE.invoke(this.$encBuffer, (Function0)new Function0<Integer>(this.this$0, this.$plainBuffer){
                    final /* synthetic */ SslSession this$0;
                    final /* synthetic */ ByteBuffer $plainBuffer;
                    {
                        this.this$0 = $receiver;
                        this.$plainBuffer = $plainBuffer;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return SslSession.access$sslRead(this.this$0, this.$plainBuffer);
                    }
                });
            }
        })).intValue();
        plainBuffer.limit(size2 + plainBuffer.position());
    }

    @NotNull
    public final ByteBuffer decrypt(@NotNull ByteBuffer encBuffer, @NotNull Function1<? super ByteBuffer, Unit> send2) {
        Intrinsics.checkNotNullParameter((Object)encBuffer, (String)"encBuffer");
        Intrinsics.checkNotNullParameter(send2, (String)"send");
        ByteBuffer buf = ByteBuffer.allocate(encBuffer.remaining());
        Intrinsics.checkNotNull((Object)buf);
        this.decrypt(encBuffer, buf, send2);
        return buf;
    }

    private final int sslRead(ByteBuffer plainBuffer) {
        int n;
        int ret2 = MbedtlsApi.INSTANCE.mbedtls_ssl_read((Pointer)this.sslContext, plainBuffer, plainBuffer.remaining());
        if (ret2 >= 0) {
            n = ret2;
        } else if (ret2 == -26880) {
            n = 0;
        } else {
            throw SslException.Companion.from(ret2);
        }
        return n;
    }

    @NotNull
    public final byte[] saveAndClose() {
        byte[] buffer = new byte[1280];
        byte[] outputLen = new byte[4];
        MbedtlsApi.INSTANCE.verify$kotlin_mbedtls(MbedtlsApi.INSTANCE.mbedtls_ssl_context_save((Pointer)this.sslContext, buffer, buffer.length, outputLen));
        this.close();
        int size2 = (outputLen[0] & 0xFF) + ((outputLen[1] & 0xFF) << 8);
        byte[] byArray = Arrays.copyOf(buffer, size2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return this.peerCid != null && this.peerCertificateSubject != null ? "[CID:" + (this.cid != null ? BytesExtensionsKt.toHex(this.cid) : null) + ", peerCID:" + BytesExtensionsKt.toHex(this.peerCid) + ", peer-cert:" + this.peerCertificateSubject + ", cipher-suite:" + this.getCipherSuite() + ']' : (this.peerCid != null ? "[CID:" + (this.cid != null ? BytesExtensionsKt.toHex(this.cid) : null) + ", peerCID:" + BytesExtensionsKt.toHex(this.peerCid) + ", cipher-suite:" + this.getCipherSuite() + ']' : (this.peerCertificateSubject != null ? "[peer-cert:" + this.peerCertificateSubject + ", cipher-suite:" + this.getCipherSuite() + ']' : "[cipher-suite:" + this.getCipherSuite() + ']'));
    }

    @NotNull
    public final ByteBuffer closeNotify() {
        ByteBuffer byteBuffer = SendCallback.INSTANCE.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SslSession this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MbedtlsApi.INSTANCE.mbedtls_ssl_close_notify((Pointer)SslSession.access$getSslContext$p(this.this$0));
            }
        }));
        if (byteBuffer == null) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(0);
            byteBuffer = byteBuffer2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocate(...)");
        }
        return byteBuffer;
    }

    @Override
    public void close() {
        MbedtlsApi.INSTANCE.mbedtls_ssl_free((Pointer)this.sslContext);
    }

    public static final /* synthetic */ Memory access$getSslContext$p(SslSession $this) {
        return $this.sslContext;
    }

    public static final /* synthetic */ int access$sslRead(SslSession $this, ByteBuffer plainBuffer) {
        return $this.sslRead(plainBuffer);
    }
}

