/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opencoap.ssl.transport.BytesExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0001\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0005\u001a\f\u0010\n\u001a\u00020\u0005*\u00020\u0002H\u0000\u00a8\u0006\u000b"}, d2={"asByteBuffer", "Ljava/nio/ByteBuffer;", "", "copy", "decodeToString", "", "isEmpty", "", "isNotEmpty", "toByteBuffer", "toHex", "kotlin-mbedtls"})
public final class BytesExtensionsKt {
    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$toHex, (CharSequence)"", null, null, (int)0, null, (Function1)toHex.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final ByteBuffer copy(@NotNull ByteBuffer $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        ByteBuffer bb = ByteBuffer.allocateDirect($this$copy.remaining());
        bb.put($this$copy);
        bb.flip();
        Intrinsics.checkNotNull((Object)bb);
        return bb;
    }

    public static final boolean isNotEmpty(@NotNull ByteBuffer $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.hasRemaining();
    }

    public static final boolean isEmpty(@NotNull ByteBuffer $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return !$this$isEmpty.hasRemaining();
    }

    @NotNull
    public static final ByteBuffer asByteBuffer(@NotNull byte[] $this$asByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$asByteBuffer, (String)"<this>");
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$asByteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    @NotNull
    public static final ByteBuffer toByteBuffer(@NotNull String $this$toByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteBuffer, (String)"<this>");
        return BytesExtensionsKt.asByteBuffer(StringsKt.encodeToByteArray((String)$this$toByteBuffer));
    }

    @NotNull
    public static final String decodeToString(@NotNull ByteBuffer $this$decodeToString) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToString, (String)"<this>");
        byte[] bb = new byte[$this$decodeToString.remaining()];
        $this$decodeToString.get(bb);
        return StringsKt.decodeToString((byte[])bb);
    }
}

