/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.CloseNotifyException;
import org.opencoap.ssl.HelloVerifyRequired;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslContext;
import org.opencoap.ssl.SslException;
import org.opencoap.ssl.SslHandshakeContext;
import org.opencoap.ssl.SslSession;
import org.opencoap.ssl.transport.BytesExtensionsKt;
import org.opencoap.ssl.transport.DtlsSessionContext;
import org.opencoap.ssl.transport.DtlsSessionLifecycleCallbacks;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SessionWithContext;
import org.opencoap.ssl.transport.SingleThreadExecutorKt;
import org.opencoap.ssl.transport.TransportOutbound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 62\u00020\u0001:\u00056789:By\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00126\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\f\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010%\u001a\u00020\u0013J\u0018\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020#J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0005J \u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\rJ \u00100\u001a\u00020.2\u0006\u0010+\u001a\u00020#2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000102J\u0010\u00104\u001a\u00020\u00132\u0006\u0010+\u001a\u00020#H\u0002J\u0010\u00105\u001a\u00020\u0013*\u00060$R\u00020\u0000H\u0002R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\b\u0012\u00060$R\u00020\u00000\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;\u00b2\u0006\f\u0010\u0010\u001a\u0004\u0018\u00010\rX\u008a\u0084\u0002"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer;", "", "transport", "Lorg/opencoap/ssl/transport/TransportOutbound;", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "sslConfig", "Lorg/opencoap/ssl/SslConfig;", "expireAfter", "Ljava/time/Duration;", "storeSession", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "cid", "Lorg/opencoap/ssl/transport/SessionWithContext;", "session", "", "lifecycleCallbacks", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lorg/opencoap/ssl/transport/TransportOutbound;Lorg/opencoap/ssl/SslConfig;Ljava/time/Duration;Lkotlin/jvm/functions/Function2;Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;Ljava/util/concurrent/ScheduledExecutorService;)V", "cidSize", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "numberOfSessions", "getNumberOfSessions", "()I", "sessions", "", "Ljava/net/InetSocketAddress;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "closeSessions", "encrypt", "plainPacket", "peerAddress", "handleReceived", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "adr", "buf", "loadSession", "", "sessBuf", "putSessionAuthenticationContext", "key", "", "value", "reportMessageDrop", "closeAndRemove", "Companion", "DtlsHandshake", "DtlsSession", "DtlsState", "ReceiveResult", "kotlin-mbedtls"})
public final class DtlsServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransportOutbound<Packet<ByteBuffer>> transport;
    @NotNull
    private final SslConfig sslConfig;
    @NotNull
    private final Duration expireAfter;
    @NotNull
    private final Function2<byte[], SessionWithContext, Unit> storeSession;
    @NotNull
    private final DtlsSessionLifecycleCallbacks lifecycleCallbacks;
    @NotNull
    private final ScheduledExecutorService executor;
    private final Logger logger;
    @NotNull
    private final Map<InetSocketAddress, DtlsState> sessions;
    private final int cidSize;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    @NotNull
    private static final Future<?> NO_SCHEDULE_TASK;

    public DtlsServer(@NotNull TransportOutbound<Packet<ByteBuffer>> transport, @NotNull SslConfig sslConfig, @NotNull Duration expireAfter, @NotNull Function2<? super byte[], ? super SessionWithContext, Unit> storeSession, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter(transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
        Intrinsics.checkNotNullParameter(storeSession, (String)"storeSession");
        Intrinsics.checkNotNullParameter((Object)lifecycleCallbacks, (String)"lifecycleCallbacks");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.transport = transport;
        this.sslConfig = sslConfig;
        this.expireAfter = expireAfter;
        this.storeSession = storeSession;
        this.lifecycleCallbacks = lifecycleCallbacks;
        this.executor = executor;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.sessions = new LinkedHashMap();
        this.cidSize = this.sslConfig.getCidSupplier().next().length;
    }

    public /* synthetic */ DtlsServer(TransportOutbound transportOutbound, SslConfig sslConfig, Duration duration, Function2 function2, DtlsSessionLifecycleCallbacks dtlsSessionLifecycleCallbacks, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x10) != 0) {
            dtlsSessionLifecycleCallbacks = new DtlsSessionLifecycleCallbacks(){

                @Override
                public void handshakeStarted(@NotNull InetSocketAddress adr) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeStarted(this, adr);
                }

                @Override
                public void handshakeFinished(@NotNull InetSocketAddress adr, long hanshakeStartTimestamp, long hanshakeFinishTimestamp, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeFinished(this, adr, hanshakeStartTimestamp, hanshakeFinishTimestamp, reason, throwable);
                }

                @Override
                public void sessionStarted(@NotNull InetSocketAddress adr, @NotNull String cipherSuite, boolean reloaded) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.sessionStarted(this, adr, cipherSuite, reloaded);
                }

                @Override
                public void sessionFinished(@NotNull InetSocketAddress adr, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished(this, adr, reason, throwable);
                }

                @Override
                public void messageDropped(@NotNull InetSocketAddress adr) {
                    DtlsSessionLifecycleCallbacks.DefaultImpls.messageDropped(this, adr);
                }
            };
        }
        this(transportOutbound, sslConfig, duration, (Function2<? super byte[], ? super SessionWithContext, Unit>)function2, dtlsSessionLifecycleCallbacks, scheduledExecutorService);
    }

    public final int getNumberOfSessions() {
        return this.sessions.size();
    }

    @NotNull
    public final ReceiveResult handleReceived(@NotNull InetSocketAddress adr, @NotNull ByteBuffer buf) {
        ReceiveResult receiveResult;
        Intrinsics.checkNotNullParameter((Object)adr, (String)"adr");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Lazy cid$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this, buf){
            final /* synthetic */ DtlsServer this$0;
            final /* synthetic */ ByteBuffer $buf;
            {
                this.this$0 = $receiver;
                this.$buf = $buf;
                super(0);
            }

            @Nullable
            public final byte[] invoke() {
                return SslContext.Companion.peekCID(DtlsServer.access$getCidSize$p(this.this$0), this.$buf);
            }
        }));
        DtlsState dtlsState = this.sessions.get(adr);
        if (dtlsState instanceof DtlsHandshake) {
            receiveResult = ((DtlsHandshake)dtlsState).step(buf);
        } else if (dtlsState instanceof DtlsSession) {
            receiveResult = ((DtlsSession)dtlsState).decrypt(buf);
        } else if (DtlsServer.handleReceived$lambda$0((Lazy<byte[]>)cid$delegate) != null) {
            byte[] byArray = DtlsServer.handleReceived$lambda$0((Lazy<byte[]>)cid$delegate);
            Intrinsics.checkNotNull((Object)byArray);
            receiveResult = new ReceiveResult.CidSessionMissing(byArray);
        } else {
            DtlsHandshake dtlsHandshake = new DtlsHandshake(this.sslConfig.newContext(adr), adr);
            this.sessions.put(adr, dtlsHandshake);
            receiveResult = dtlsHandshake.step(buf);
        }
        return receiveResult;
    }

    @Nullable
    public final ByteBuffer encrypt(@NotNull ByteBuffer plainPacket, @NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)plainPacket, (String)"plainPacket");
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        DtlsState dtlsState = this.sessions.get(peerAddress);
        DtlsSession dtlsSession = dtlsState instanceof DtlsSession ? (DtlsSession)dtlsState : null;
        return dtlsSession != null ? dtlsSession.encrypt(plainPacket) : null;
    }

    public final boolean putSessionAuthenticationContext(@NotNull InetSocketAddress adr, @NotNull String key, @Nullable String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)adr, (String)"adr");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DtlsState s = this.sessions.get(adr);
        if (s instanceof DtlsSession) {
            if (value != null) {
                DtlsSession dtlsSession = (DtlsSession)s;
                dtlsSession.setAuthenticationContext(MapsKt.plus(dtlsSession.getAuthenticationContext(), (Pair)TuplesKt.to((Object)key, (Object)value)));
            } else {
                DtlsSession dtlsSession = (DtlsSession)s;
                dtlsSession.setAuthenticationContext(MapsKt.minus(dtlsSession.getAuthenticationContext(), (Object)key));
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void closeSessions() {
        Iterator<Map.Entry<InetSocketAddress, DtlsState>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            DtlsState dtlsState = iterator.next().getValue();
            iterator.remove();
            dtlsState.storeAndClose();
        }
    }

    public final boolean loadSession(@Nullable SessionWithContext sessBuf, @NotNull InetSocketAddress adr, @NotNull byte[] cid2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)adr, (String)"adr");
        Intrinsics.checkNotNullParameter((Object)cid2, (String)"cid");
        try {
            boolean bl2;
            if (sessBuf == null) {
                this.logger.warn("[{}] [CID:{}] DTLS session not found", (Object)adr, (Object)BytesExtensionsKt.toHex(cid2));
                this.reportMessageDrop(adr);
                bl2 = false;
            } else {
                this.sessions.put(adr, new DtlsSession(this, this.sslConfig.loadSession(cid2, sessBuf.getSessionBlob(), adr), adr, sessBuf.getAuthenticationContext(), sessBuf.getSessionStartTimestamp()));
                bl2 = true;
            }
            bl = bl2;
        }
        catch (SslException ex) {
            Object[] objectArray = new Object[]{adr, BytesExtensionsKt.toHex(cid2), ex.getMessage()};
            this.logger.warn("[{}] [CID:{}] Failed to load session: {}", objectArray);
            this.reportMessageDrop(adr);
            bl = false;
        }
        return bl;
    }

    private final void reportMessageDrop(InetSocketAddress adr) {
        this.lifecycleCallbacks.messageDropped(adr);
    }

    private final void closeAndRemove(DtlsState $this$closeAndRemove) {
        this.sessions.remove($this$closeAndRemove.getPeerAddress(), $this$closeAndRemove);
        $this$closeAndRemove.close();
    }

    private static final byte[] handleReceived$lambda$0(Lazy<byte[]> $cid$delegate) {
        Lazy<byte[]> lazy = $cid$delegate;
        return (byte[])lazy.getValue();
    }

    public static final /* synthetic */ int access$getCidSize$p(DtlsServer $this) {
        return $this.cidSize;
    }

    static {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        NO_SCHEDULE_TASK = completableFuture;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$Companion;", "", "()V", "EMPTY_BUFFER", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "NO_SCHEDULE_TASK", "Ljava/util/concurrent/Future;", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0006\u0010\u0016\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$DtlsHandshake;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "Lorg/opencoap/ssl/transport/DtlsServer;", "ctx", "Lorg/opencoap/ssl/SslHandshakeContext;", "peerAddress", "Ljava/net/InetSocketAddress;", "(Lorg/opencoap/ssl/transport/DtlsServer;Lorg/opencoap/ssl/SslHandshakeContext;Ljava/net/InetSocketAddress;)V", "close", "", "reportHandshakeFinished", "reason", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks$Reason;", "err", "", "reportHandshakeStarted", "retryStep", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "step", "encPacket", "Ljava/nio/ByteBuffer;", "storeAndClose0", "timeout", "kotlin-mbedtls"})
    private final class DtlsHandshake
    extends DtlsState {
        @NotNull
        private final SslHandshakeContext ctx;

        public DtlsHandshake(@NotNull SslHandshakeContext ctx, InetSocketAddress peerAddress) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
            super(peerAddress);
            this.ctx = ctx;
            this.setScheduledTask(NO_SCHEDULE_TASK);
            this.reportHandshakeStarted();
        }

        private final ReceiveResult retryStep() {
            ByteBuffer byteBuffer = EMPTY_BUFFER;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"access$getEMPTY_BUFFER$cp(...)");
            return this.step(byteBuffer);
        }

        @NotNull
        public final ReceiveResult step(@NotNull ByteBuffer encPacket) {
            Intrinsics.checkNotNullParameter((Object)encPacket, (String)"encPacket");
            this.getScheduledTask().cancel(false);
            try {
                SslContext newCtx2 = this.ctx.step(encPacket, (Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>((Object)this){

                    public final void invoke(@NotNull ByteBuffer p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((DtlsHandshake)this.receiver).send(p0);
                    }
                }));
                if (newCtx2 instanceof SslHandshakeContext) {
                    this.setScheduledTask(!((SslHandshakeContext)newCtx2).getReadTimeout().isZero() ? (Future)SingleThreadExecutorKt.schedule(DtlsServer.this.executor, () -> this.retryStep(), ((SslHandshakeContext)newCtx2).getReadTimeout()) : (Future)SingleThreadExecutorKt.schedule(DtlsServer.this.executor, this::timeout, DtlsServer.this.expireAfter));
                } else if (newCtx2 instanceof SslSession) {
                    DtlsServer.this.sessions.put(this.getPeerAddress(), new DtlsSession(DtlsServer.this, (SslSession)newCtx2, this.getPeerAddress(), null, null, 12, null));
                    DtlsHandshake.reportHandshakeFinished$default(this, DtlsSessionLifecycleCallbacks.Reason.SUCCEEDED, null, 2, null);
                }
            }
            catch (HelloVerifyRequired ex) {
                DtlsServer.this.closeAndRemove(this);
                this.reportHandshakeFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
            }
            catch (Exception ex) {
                if (ex instanceof SslException) {
                    DtlsServer.this.logger.warn("[{}] DTLS failed: {}", (Object)this.getPeerAddress(), (Object)ex.getMessage());
                } else {
                    DtlsServer.this.logger.error(ex.toString(), (Throwable)ex);
                }
                DtlsServer.this.closeAndRemove(this);
                this.reportHandshakeFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
                DtlsServer.this.reportMessageDrop(this.getPeerAddress());
            }
            return ReceiveResult.Handled.INSTANCE;
        }

        public final void timeout() {
            DtlsServer.this.closeAndRemove(this);
            DtlsServer.this.logger.warn("[{}] DTLS handshake expired", (Object)this.getPeerAddress());
            DtlsHandshake.reportHandshakeFinished$default(this, DtlsSessionLifecycleCallbacks.Reason.EXPIRED, null, 2, null);
        }

        @Override
        public void storeAndClose0() {
            this.close();
        }

        @Override
        public void close() {
            this.ctx.close();
        }

        private final void reportHandshakeStarted() {
            DtlsServer.this.lifecycleCallbacks.handshakeStarted(this.getPeerAddress());
        }

        private final void reportHandshakeFinished(DtlsSessionLifecycleCallbacks.Reason reason, Throwable err) {
            DtlsServer.this.lifecycleCallbacks.handshakeFinished(this.getPeerAddress(), this.ctx.getStartTimestamp(), this.ctx.getFinishTimestamp(), reason, err);
        }

        static /* synthetic */ void reportHandshakeFinished$default(DtlsHandshake dtlsHandshake, DtlsSessionLifecycleCallbacks.Reason reason, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            dtlsHandshake.reportHandshakeFinished(reason, throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eJ\u001c\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0016J\u0006\u0010(\u001a\u00020\u001aR*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u0002`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$DtlsSession;", "Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "Lorg/opencoap/ssl/transport/DtlsServer;", "ctx", "Lorg/opencoap/ssl/SslSession;", "peerAddress", "Ljava/net/InetSocketAddress;", "authenticationContext", "", "", "Lorg/opencoap/ssl/transport/AuthenticationContext;", "sessionStartTimestamp", "Ljava/time/Instant;", "(Lorg/opencoap/ssl/transport/DtlsServer;Lorg/opencoap/ssl/SslSession;Ljava/net/InetSocketAddress;Ljava/util/Map;Ljava/time/Instant;)V", "getAuthenticationContext", "()Ljava/util/Map;", "setAuthenticationContext", "(Ljava/util/Map;)V", "ownCidHex", "getOwnCidHex", "()Ljava/lang/String;", "sessionContext", "Lorg/opencoap/ssl/transport/DtlsSessionContext;", "getSessionContext", "()Lorg/opencoap/ssl/transport/DtlsSessionContext;", "close", "", "decrypt", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "encPacket", "Ljava/nio/ByteBuffer;", "encrypt", "plainPacket", "reportSessionFinished", "reason", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks$Reason;", "err", "", "reportSessionStarted", "storeAndClose0", "timeout", "kotlin-mbedtls"})
    private final class DtlsSession
    extends DtlsState {
        @NotNull
        private final SslSession ctx;
        @NotNull
        private Map<String, String> authenticationContext;
        @NotNull
        private final Instant sessionStartTimestamp;
        final /* synthetic */ DtlsServer this$0;

        public DtlsSession(@NotNull DtlsServer this$0, @NotNull SslSession ctx, @NotNull InetSocketAddress peerAddress, @NotNull Map<String, String> authenticationContext, Instant sessionStartTimestamp) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
            Intrinsics.checkNotNullParameter(authenticationContext, (String)"authenticationContext");
            Intrinsics.checkNotNullParameter((Object)sessionStartTimestamp, (String)"sessionStartTimestamp");
            this.this$0 = this$0;
            super(peerAddress);
            this.ctx = ctx;
            this.authenticationContext = authenticationContext;
            this.sessionStartTimestamp = sessionStartTimestamp;
            this.setScheduledTask((Future)SingleThreadExecutorKt.schedule(this.this$0.executor, this::timeout, this.this$0.expireAfter));
            this.reportSessionStarted();
        }

        public /* synthetic */ DtlsSession(DtlsServer dtlsServer2, SslSession sslSession, InetSocketAddress inetSocketAddress, Map map2, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 8) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
                instant = instant2;
            }
            this(dtlsServer2, sslSession, inetSocketAddress, map2, instant);
        }

        @NotNull
        public final Map<String, String> getAuthenticationContext() {
            return this.authenticationContext;
        }

        public final void setAuthenticationContext(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.authenticationContext = map2;
        }

        @NotNull
        public final DtlsSessionContext getSessionContext() {
            String string = this.ctx.getPeerCertificateSubject();
            Map<String, String> map2 = this.authenticationContext;
            byte[] byArray = this.ctx.getOwnCid();
            byte[] byArray2 = !(byArray != null ? byArray.length == 0 : false) ? this.ctx.getOwnCid() : this.ctx.getPeerCid();
            Instant instant = this.sessionStartTimestamp;
            return new DtlsSessionContext(map2, string, byArray2, instant);
        }

        @Override
        public void storeAndClose0() {
            if (this.ctx.getOwnCid() != null) {
                try {
                    SessionWithContext session = new SessionWithContext(this.ctx.saveAndClose(), this.authenticationContext, this.sessionStartTimestamp);
                    this.this$0.storeSession.invoke((Object)this.ctx.getOwnCid(), (Object)session);
                }
                catch (Exception ex) {
                    Object[] objectArray = new Object[]{this.getPeerAddress(), this.getOwnCidHex(), ex.getMessage()};
                    this.this$0.logger.error("[{}] [CID:{}] DTLS failed to store session: {}", objectArray);
                }
            } else {
                this.close();
            }
        }

        @Override
        public void close() {
            this.ctx.close();
        }

        @NotNull
        public final ReceiveResult decrypt(@NotNull ByteBuffer encPacket) {
            Intrinsics.checkNotNullParameter((Object)encPacket, (String)"encPacket");
            this.getScheduledTask().cancel(false);
            try {
                ByteBuffer plainBuf2 = this.ctx.decrypt(encPacket, (Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>((Object)this){

                    public final void invoke(@NotNull ByteBuffer p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((DtlsSession)this.receiver).send(p0);
                    }
                }));
                this.setScheduledTask((Future)SingleThreadExecutorKt.schedule(this.this$0.executor, this::timeout, this.this$0.expireAfter));
                return BytesExtensionsKt.isNotEmpty(plainBuf2) ? (ReceiveResult)new ReceiveResult.Decrypted(new Packet<ByteBuffer>(plainBuf2, this.getPeerAddress(), this.getSessionContext())) : (ReceiveResult)ReceiveResult.Handled.INSTANCE;
            }
            catch (CloseNotifyException ex) {
                this.this$0.logger.info("[{}] [CID:{}] DTLS received close notify", (Object)this.getPeerAddress(), (Object)this.getOwnCidHex());
                DtlsSession.reportSessionFinished$default(this, DtlsSessionLifecycleCallbacks.Reason.CLOSED, null, 2, null);
            }
            catch (SslException ex) {
                Object[] objectArray = new Object[]{this.getPeerAddress(), this.getOwnCidHex(), ex.getMessage()};
                this.this$0.logger.warn("[{}] [CID:{}] DTLS failed: {}", objectArray);
                this.reportSessionFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
                this.this$0.reportMessageDrop(this.getPeerAddress());
            }
            this.this$0.closeAndRemove(this);
            return ReceiveResult.DecryptFailed.INSTANCE;
        }

        @NotNull
        public final ByteBuffer encrypt(@NotNull ByteBuffer plainPacket) {
            Intrinsics.checkNotNullParameter((Object)plainPacket, (String)"plainPacket");
            try {
                return this.ctx.encrypt(plainPacket);
            }
            catch (SslException ex) {
                this.this$0.closeAndRemove(this);
                Object[] objectArray = new Object[]{this.getPeerAddress(), this.getOwnCidHex(), ex.getMessage()};
                this.this$0.logger.warn("[{}] [CID:{}] DTLS failed: {}", objectArray);
                this.reportSessionFinished(DtlsSessionLifecycleCallbacks.Reason.FAILED, ex);
                throw ex;
            }
        }

        public final void timeout() {
            this.this$0.sessions.remove(this.getPeerAddress(), this);
            this.storeAndClose();
            this.this$0.logger.info("[{}] [CID:{}] DTLS connection expired", (Object)this.getPeerAddress(), (Object)this.getOwnCidHex());
            DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished$default(this.this$0.lifecycleCallbacks, this.getPeerAddress(), DtlsSessionLifecycleCallbacks.Reason.EXPIRED, null, 4, null);
        }

        private final String getOwnCidHex() {
            Object object;
            block3: {
                block2: {
                    object = this.ctx.getOwnCid();
                    if (object == null) break block2;
                    String string = BytesExtensionsKt.toHex(object);
                    object = string;
                    if (string != null) break block3;
                }
                object = "na";
            }
            return object;
        }

        private final void reportSessionStarted() {
            this.this$0.lifecycleCallbacks.sessionStarted(this.getPeerAddress(), this.ctx.getCipherSuite(), this.ctx.getReloaded());
        }

        private final void reportSessionFinished(DtlsSessionLifecycleCallbacks.Reason reason, Throwable err) {
            this.this$0.lifecycleCallbacks.sessionFinished(this.getPeerAddress(), reason, err);
        }

        static /* synthetic */ void reportSessionFinished$default(DtlsSession dtlsSession, DtlsSessionLifecycleCallbacks.Reason reason, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            dtlsSession.reportSessionFinished(reason, throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH&J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$DtlsState;", "", "peerAddress", "Ljava/net/InetSocketAddress;", "(Lorg/opencoap/ssl/transport/DtlsServer;Ljava/net/InetSocketAddress;)V", "getPeerAddress", "()Ljava/net/InetSocketAddress;", "scheduledTask", "Ljava/util/concurrent/Future;", "getScheduledTask", "()Ljava/util/concurrent/Future;", "setScheduledTask", "(Ljava/util/concurrent/Future;)V", "close", "", "send", "buf", "Ljava/nio/ByteBuffer;", "storeAndClose", "storeAndClose0", "kotlin-mbedtls"})
    private abstract class DtlsState {
        @NotNull
        private final InetSocketAddress peerAddress;
        protected Future<?> scheduledTask;

        public DtlsState(InetSocketAddress peerAddress) {
            Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
            this.peerAddress = peerAddress;
        }

        @NotNull
        public final InetSocketAddress getPeerAddress() {
            return this.peerAddress;
        }

        @NotNull
        protected final Future<?> getScheduledTask() {
            Future<?> future = this.scheduledTask;
            if (future != null) {
                return future;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"scheduledTask");
            return null;
        }

        protected final void setScheduledTask(@NotNull Future<?> future) {
            Intrinsics.checkNotNullParameter(future, (String)"<set-?>");
            this.scheduledTask = future;
        }

        public abstract void storeAndClose0();

        public final void storeAndClose() {
            this.getScheduledTask().cancel(false);
            this.storeAndClose0();
        }

        public final void send(@NotNull ByteBuffer buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            DtlsServer.this.transport.send(new Packet(buf, this.peerAddress, null, 4, null));
        }

        public abstract void close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "", "CidSessionMissing", "DecryptFailed", "Decrypted", "Handled", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$CidSessionMissing;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$DecryptFailed;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$Decrypted;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$Handled;", "kotlin-mbedtls"})
    public static interface ReceiveResult {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$CidSessionMissing;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "cid", "", "([B)V", "getCid", "()[B", "kotlin-mbedtls"})
        public static final class CidSessionMissing
        implements ReceiveResult {
            @NotNull
            private final byte[] cid;

            public CidSessionMissing(@NotNull byte[] cid2) {
                Intrinsics.checkNotNullParameter((Object)cid2, (String)"cid");
                this.cid = cid2;
            }

            @NotNull
            public final byte[] getCid() {
                return this.cid;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$DecryptFailed;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "()V", "kotlin-mbedtls"})
        public static final class DecryptFailed
        implements ReceiveResult {
            @NotNull
            public static final DecryptFailed INSTANCE = new DecryptFailed();

            private DecryptFailed() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$Decrypted;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "packet", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "(Lorg/opencoap/ssl/transport/Packet;)V", "getPacket", "()Lorg/opencoap/ssl/transport/Packet;", "kotlin-mbedtls"})
        public static final class Decrypted
        implements ReceiveResult {
            @NotNull
            private final Packet<ByteBuffer> packet;

            public Decrypted(@NotNull Packet<ByteBuffer> packet) {
                Intrinsics.checkNotNullParameter(packet, (String)"packet");
                this.packet = packet;
            }

            @NotNull
            public final Packet<ByteBuffer> getPacket() {
                return this.packet;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult$Handled;", "Lorg/opencoap/ssl/transport/DtlsServer$ReceiveResult;", "()V", "kotlin-mbedtls"})
        public static final class Handled
        implements ReceiveResult {
            @NotNull
            public static final Handled INSTANCE = new Handled();

            private Handled() {
            }
        }
    }
}

