/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.transport.BytesExtensionsKt;
import org.opencoap.ssl.transport.DatagramChannelAdapter;
import org.opencoap.ssl.transport.DtlsServer;
import org.opencoap.ssl.transport.DtlsSessionLifecycleCallbacks;
import org.opencoap.ssl.transport.NoOpsSessionStore;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SessionStore;
import org.opencoap.ssl.transport.SessionWithContext;
import org.opencoap.ssl.transport.SingleThreadExecutor;
import org.opencoap.ssl.transport.SingleThreadExecutorKt;
import org.opencoap.ssl.transport.Transport;
import org.opencoap.ssl.transport.TransportOutbound;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001:\u0001\"B7\b\u0002\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\n\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0011J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J \u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J2\u0010\u001e\u001a\u0014\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/opencoap/ssl/transport/DtlsServerTransport;", "Lorg/opencoap/ssl/transport/Transport;", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "transport", "dtlsServer", "Lorg/opencoap/ssl/transport/DtlsServer;", "sessionStore", "Lorg/opencoap/ssl/transport/SessionStore;", "executor", "Lorg/opencoap/ssl/transport/SingleThreadExecutor;", "(Lorg/opencoap/ssl/transport/Transport;Lorg/opencoap/ssl/transport/DtlsServer;Lorg/opencoap/ssl/transport/SessionStore;Lorg/opencoap/ssl/transport/SingleThreadExecutor;)V", "close", "", "Ljava/util/concurrent/ScheduledExecutorService;", "localPort", "", "numberOfSessions", "putSessionAuthenticationContext", "Ljava/util/concurrent/CompletableFuture;", "", "adr", "Ljava/net/InetSocketAddress;", "key", "", "value", "receive", "timeout", "Ljava/time/Duration;", "receive0", "buf", "send", "packet", "Companion", "kotlin-mbedtls"})
@SourceDebugExtension(value={"SMAP\nDtlsServerTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsServerTransport.kt\norg/opencoap/ssl/transport/DtlsServerTransport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class DtlsServerTransport
implements Transport<Packet<ByteBuffer>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Transport<Packet<ByteBuffer>> transport;
    @NotNull
    private final DtlsServer dtlsServer;
    @NotNull
    private final SessionStore sessionStore;
    @NotNull
    private final SingleThreadExecutor executor;

    private DtlsServerTransport(Transport<Packet<ByteBuffer>> transport, DtlsServer dtlsServer2, SessionStore sessionStore, SingleThreadExecutor executor) {
        this.transport = transport;
        this.dtlsServer = dtlsServer2;
        this.sessionStore = sessionStore;
        this.executor = executor;
    }

    public final int numberOfSessions() {
        Integer n = SingleThreadExecutorKt.supply(this.executor, () -> DtlsServerTransport.numberOfSessions$lambda$0(this)).join();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"join(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public final ScheduledExecutorService executor() {
        return this.executor.getUnderlying();
    }

    @Override
    @NotNull
    public CompletableFuture<Packet<ByteBuffer>> receive(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        CompletionStage completionStage = this.transport.receive(timeout).thenComposeAsync(arg_0 -> DtlsServerTransport.receive$lambda$1((Function1)new Function1<Packet<ByteBuffer>, CompletionStage<Packet<ByteBuffer>>>(this, timeout){
            final /* synthetic */ DtlsServerTransport this$0;
            final /* synthetic */ Duration $timeout;
            {
                this.this$0 = $receiver;
                this.$timeout = $timeout;
                super(1);
            }

            public final CompletionStage<Packet<ByteBuffer>> invoke(Packet<ByteBuffer> packet) {
                return Intrinsics.areEqual(packet, Packet.Companion.getEmptyByteBufferPacket()) ? CompletableFuture.completedFuture(Packet.Companion.getEmptyByteBufferPacket()) : DtlsServerTransport.access$receive0(this.this$0, packet.getPeerAddress(), packet.getBuffer(), this.$timeout);
            }
        }, arg_0), (Executor)this.executor);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenComposeAsync(...)");
        return completionStage;
    }

    private final CompletableFuture<Packet<ByteBuffer>> receive0(InetSocketAddress adr, ByteBuffer buf, Duration timeout) {
        CompletionStage<Packet<ByteBuffer>> completionStage;
        DtlsServer.ReceiveResult result = this.dtlsServer.handleReceived(adr, buf);
        DtlsServer.ReceiveResult receiveResult = result;
        if (receiveResult instanceof DtlsServer.ReceiveResult.Handled) {
            completionStage = this.receive(timeout);
        } else if (receiveResult instanceof DtlsServer.ReceiveResult.DecryptFailed) {
            completionStage = this.receive(timeout);
        } else if (receiveResult instanceof DtlsServer.ReceiveResult.Decrypted) {
            completionStage = CompletableFuture.completedFuture(((DtlsServer.ReceiveResult.Decrypted)result).getPacket());
        } else if (receiveResult instanceof DtlsServer.ReceiveResult.CidSessionMissing) {
            ByteBuffer copyBuf = BytesExtensionsKt.copy(buf);
            completionStage = ((CompletableFuture)this.sessionStore.read(((DtlsServer.ReceiveResult.CidSessionMissing)result).getCid()).thenApplyAsync(arg_0 -> DtlsServerTransport.receive0$lambda$2((Function1)new Function1<SessionWithContext, Boolean>(this, adr, result){
                final /* synthetic */ DtlsServerTransport this$0;
                final /* synthetic */ InetSocketAddress $adr;
                final /* synthetic */ DtlsServer.ReceiveResult $result;
                {
                    this.this$0 = $receiver;
                    this.$adr = $adr;
                    this.$result = $result;
                    super(1);
                }

                public final Boolean invoke(@Nullable SessionWithContext sessBuf) {
                    return DtlsServerTransport.access$getDtlsServer$p(this.this$0).loadSession(sessBuf, this.$adr, ((DtlsServer.ReceiveResult.CidSessionMissing)this.$result).getCid());
                }
            }, arg_0), (Executor)this.executor)).thenCompose(arg_0 -> DtlsServerTransport.receive0$lambda$3((Function1)new Function1<Boolean, CompletionStage<Packet<ByteBuffer>>>(this, adr, copyBuf, timeout){
                final /* synthetic */ DtlsServerTransport this$0;
                final /* synthetic */ InetSocketAddress $adr;
                final /* synthetic */ ByteBuffer $copyBuf;
                final /* synthetic */ Duration $timeout;
                {
                    this.this$0 = $receiver;
                    this.$adr = $adr;
                    this.$copyBuf = $copyBuf;
                    this.$timeout = $timeout;
                    super(1);
                }

                public final CompletionStage<Packet<ByteBuffer>> invoke(Boolean isLoaded) {
                    Intrinsics.checkNotNull((Object)isLoaded);
                    return isLoaded != false ? DtlsServerTransport.access$receive0(this.this$0, this.$adr, this.$copyBuf, this.$timeout) : this.this$0.receive(this.$timeout);
                }
            }, arg_0));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> send(@NotNull Packet<ByteBuffer> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        CompletionStage completionStage = SingleThreadExecutorKt.supply(this.executor, () -> DtlsServerTransport.send$lambda$4(this, packet)).thenCompose(Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    @Override
    public int localPort() {
        return this.transport.localPort();
    }

    @Override
    public void close() {
        SingleThreadExecutorKt.supply(this.executor, () -> DtlsServerTransport.close$lambda$5(this)).get(30L, TimeUnit.SECONDS);
        this.executor.shutdown();
    }

    @NotNull
    public final CompletableFuture<Boolean> putSessionAuthenticationContext(@NotNull InetSocketAddress adr, @NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)adr, (String)"adr");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SingleThreadExecutorKt.supply(this.executor, () -> DtlsServerTransport.putSessionAuthenticationContext$lambda$6(this, adr, key, value));
    }

    @Override
    @NotNull
    public <P2> Transport<P2> map(@NotNull Function1<? super Packet<ByteBuffer>, ? extends P2> f, @NotNull Function1<? super P2, Packet<ByteBuffer>> f2) {
        return Transport.DefaultImpls.map(this, f, f2);
    }

    private static final Integer numberOfSessions$lambda$0(DtlsServerTransport this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.dtlsServer.getNumberOfSessions();
    }

    private static final CompletionStage receive$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Boolean receive0$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CompletionStage receive0$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletableFuture send$lambda$4(DtlsServerTransport this$0, Packet $packet) {
        Packet<ByteBuffer> packet;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        ByteBuffer byteBuffer = this$0.dtlsServer.encrypt((ByteBuffer)$packet.getBuffer(), $packet.getPeerAddress());
        if (byteBuffer != null) {
            ByteBuffer p0 = byteBuffer;
            boolean bl = false;
            packet = $packet.map(p0);
        } else {
            packet = null;
        }
        Packet<ByteBuffer> encPacket = packet;
        return encPacket == null ? CompletableFuture.completedFuture(false) : this$0.transport.send(encPacket);
    }

    private static final Unit close$lambda$5(DtlsServerTransport this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.transport.close();
        this$0.dtlsServer.closeSessions();
        return Unit.INSTANCE;
    }

    private static final Boolean putSessionAuthenticationContext$lambda$6(DtlsServerTransport this$0, InetSocketAddress $adr, String $key, String $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$adr, (String)"$adr");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return this$0.dtlsServer.putSessionAuthenticationContext($adr, $key, $value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull Transport<Packet<ByteBuffer>> transport, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks) {
        return Companion.create(config, listenPort, expireAfter, sessionStore, transport, lifecycleCallbacks);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull Transport<Packet<ByteBuffer>> transport) {
        return Companion.create(config, listenPort, expireAfter, sessionStore, transport);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore) {
        return Companion.create(config, listenPort, expireAfter, sessionStore);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter) {
        return Companion.create(config, listenPort, expireAfter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServerTransport create(@NotNull SslConfig config, int listenPort) {
        return Companion.create(config, listenPort);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsServerTransport create(@NotNull SslConfig config) {
        return Companion.create(config);
    }

    public /* synthetic */ DtlsServerTransport(Transport transport, DtlsServer dtlsServer2, SessionStore sessionStore, SingleThreadExecutor executor, DefaultConstructorMarker $constructor_marker) {
        this(transport, dtlsServer2, sessionStore, executor);
    }

    public static final /* synthetic */ CompletableFuture access$receive0(DtlsServerTransport $this, InetSocketAddress adr, ByteBuffer buf, Duration timeout) {
        return $this.receive0(adr, buf, timeout);
    }

    public static final /* synthetic */ DtlsServer access$getDtlsServer$p(DtlsServerTransport $this) {
        return $this.dtlsServer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u00110\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/opencoap/ssl/transport/DtlsServerTransport$Companion;", "", "()V", "create", "Lorg/opencoap/ssl/transport/DtlsServerTransport;", "config", "Lorg/opencoap/ssl/SslConfig;", "listenPort", "", "expireAfter", "Ljava/time/Duration;", "sessionStore", "Lorg/opencoap/ssl/transport/SessionStore;", "transport", "Lorg/opencoap/ssl/transport/Transport;", "Lorg/opencoap/ssl/transport/Packet;", "Ljava/nio/ByteBuffer;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "lifecycleCallbacks", "Lorg/opencoap/ssl/transport/DtlsSessionLifecycleCallbacks;", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull Transport<Packet<ByteBuffer>> transport, @NotNull DtlsSessionLifecycleCallbacks lifecycleCallbacks) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
            Intrinsics.checkNotNullParameter(transport, (String)"transport");
            Intrinsics.checkNotNullParameter((Object)lifecycleCallbacks, (String)"lifecycleCallbacks");
            SingleThreadExecutor executor = SingleThreadExecutor.Companion.create("dtls-srv-");
            DtlsServer dtlsServer2 = new DtlsServer((TransportOutbound<Packet<ByteBuffer>>)transport, config, expireAfter, (Function2<? super byte[], ? super SessionWithContext, Unit>)((Function2)new Function2<byte[], SessionWithContext, Unit>((Object)sessionStore){

                public final void invoke(@NotNull byte[] p0, @NotNull SessionWithContext p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((SessionStore)this.receiver).write(p0, p1);
                }
            }), lifecycleCallbacks, executor);
            return new DtlsServerTransport(transport, dtlsServer2, sessionStore, executor, null);
        }

        public static /* synthetic */ DtlsServerTransport create$default(Companion companion, SslConfig sslConfig, int n, Duration duration, SessionStore sessionStore, Transport transport, DtlsSessionLifecycleCallbacks dtlsSessionLifecycleCallbacks, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                Duration duration2 = Duration.ofSeconds(60L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
                duration = duration2;
            }
            if ((n2 & 8) != 0) {
                sessionStore = NoOpsSessionStore.INSTANCE;
            }
            if ((n2 & 0x10) != 0) {
                transport = DatagramChannelAdapter.Companion.open(n);
            }
            if ((n2 & 0x20) != 0) {
                dtlsSessionLifecycleCallbacks = new DtlsSessionLifecycleCallbacks(){

                    public void handshakeStarted(@NotNull InetSocketAddress adr) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeStarted(this, adr);
                    }

                    public void handshakeFinished(@NotNull InetSocketAddress adr, long hanshakeStartTimestamp, long hanshakeFinishTimestamp, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.handshakeFinished(this, adr, hanshakeStartTimestamp, hanshakeFinishTimestamp, reason, throwable);
                    }

                    public void sessionStarted(@NotNull InetSocketAddress adr, @NotNull String cipherSuite, boolean reloaded) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.sessionStarted(this, adr, cipherSuite, reloaded);
                    }

                    public void sessionFinished(@NotNull InetSocketAddress adr, @NotNull DtlsSessionLifecycleCallbacks.Reason reason, @Nullable Throwable throwable) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.sessionFinished(this, adr, reason, throwable);
                    }

                    public void messageDropped(@NotNull InetSocketAddress adr) {
                        DtlsSessionLifecycleCallbacks.DefaultImpls.messageDropped(this, adr);
                    }
                };
            }
            return companion.create(sslConfig, n, duration, sessionStore, transport, dtlsSessionLifecycleCallbacks);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore, @NotNull Transport<Packet<ByteBuffer>> transport) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
            Intrinsics.checkNotNullParameter(transport, (String)"transport");
            return org.opencoap.ssl.transport.DtlsServerTransport$Companion.create$default(this, config, listenPort, expireAfter, sessionStore, transport, null, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter, @NotNull SessionStore sessionStore) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
            return org.opencoap.ssl.transport.DtlsServerTransport$Companion.create$default(this, config, listenPort, expireAfter, sessionStore, null, null, 48, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServerTransport create(@NotNull SslConfig config, int listenPort, @NotNull Duration expireAfter) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)expireAfter, (String)"expireAfter");
            return org.opencoap.ssl.transport.DtlsServerTransport$Companion.create$default(this, config, listenPort, expireAfter, null, null, null, 56, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServerTransport create(@NotNull SslConfig config, int listenPort) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return org.opencoap.ssl.transport.DtlsServerTransport$Companion.create$default(this, config, listenPort, null, null, null, null, 60, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsServerTransport create(@NotNull SslConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return org.opencoap.ssl.transport.DtlsServerTransport$Companion.create$default(this, config, 0, null, null, null, null, 62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

