/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.HelloVerifyRequired;
import org.opencoap.ssl.SslConfig;
import org.opencoap.ssl.SslContext;
import org.opencoap.ssl.SslHandshakeContext;
import org.opencoap.ssl.SslSession;
import org.opencoap.ssl.transport.BytesExtensionsKt;
import org.opencoap.ssl.transport.DatagramChannelAdapter;
import org.opencoap.ssl.transport.DtlsTransmitter;
import org.opencoap.ssl.transport.Packet;
import org.opencoap.ssl.transport.SessionWriter;
import org.opencoap.ssl.transport.SingleThreadExecutorKt;
import org.opencoap.ssl.transport.Transport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B-\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010 \u001a\u00020!H\u0016J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020\u0010J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0#2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0#2\u0006\u0010*\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001aR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lorg/opencoap/ssl/transport/DtlsTransmitter;", "Lorg/opencoap/ssl/transport/Transport;", "Ljava/nio/ByteBuffer;", "remoteAddress", "Ljava/net/InetSocketAddress;", "transport", "sslSession", "Lorg/opencoap/ssl/SslSession;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/net/InetSocketAddress;Lorg/opencoap/ssl/transport/Transport;Lorg/opencoap/ssl/SslSession;Ljava/util/concurrent/ExecutorService;)V", "cipherSuite", "", "getCipherSuite", "()Ljava/lang/String;", "ownCid", "", "getOwnCid", "()[B", "peerCertificateSubject", "getPeerCertificateSubject", "peerCid", "getPeerCid", "getRemoteAddress", "()Ljava/net/InetSocketAddress;", "storeSession", "Lorg/opencoap/ssl/transport/SessionWriter;", "getTransport$kotlin_mbedtls", "()Lorg/opencoap/ssl/transport/Transport;", "close", "", "closeNotify", "localPort", "", "receive", "Ljava/util/concurrent/CompletableFuture;", "timeout", "Ljava/time/Duration;", "saveSession", "send", "", "packet", "text", "storeOnClose", "sessionWriter", "Companion", "kotlin-mbedtls"})
public final class DtlsTransmitter
implements Transport<ByteBuffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InetSocketAddress remoteAddress;
    @NotNull
    private final Transport<ByteBuffer> transport;
    @NotNull
    private final SslSession sslSession;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private SessionWriter storeSession;
    @NotNull
    private static final AtomicInteger threadIndex = new AtomicInteger(0);

    private DtlsTransmitter(InetSocketAddress remoteAddress, Transport<ByteBuffer> transport, SslSession sslSession, ExecutorService executor) {
        this.remoteAddress = remoteAddress;
        this.transport = transport;
        this.sslSession = sslSession;
        this.executor = executor;
        this.storeSession = SessionWriter.NO_OPS;
    }

    @NotNull
    public final InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @NotNull
    public final Transport<ByteBuffer> getTransport$kotlin_mbedtls() {
        return this.transport;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> send(@NotNull ByteBuffer packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        CompletionStage completionStage = SingleThreadExecutorKt.supply(this.executor, () -> DtlsTransmitter.send$lambda$0(this, packet)).thenCompose(arg_0 -> DtlsTransmitter.send$lambda$1((Function1)new Function1<ByteBuffer, CompletableFuture<Boolean>>(this.transport){

            @NotNull
            public final CompletableFuture<Boolean> invoke(@NotNull ByteBuffer p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Transport)this.receiver).send(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public final CompletableFuture<Boolean> send(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.send(BytesExtensionsKt.toByteBuffer(text));
    }

    @Override
    @NotNull
    public CompletableFuture<ByteBuffer> receive(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        CompletionStage completionStage = this.transport.receive(timeout).thenApplyAsync(arg_0 -> DtlsTransmitter.receive$lambda$2((Function1)new Function1<ByteBuffer, ByteBuffer>(this){
            final /* synthetic */ DtlsTransmitter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ByteBuffer invoke(ByteBuffer it) {
                ByteBuffer byteBuffer;
                if (it.remaining() == 0) {
                    byteBuffer = Packet.Companion.getEMPTY_BYTEBUFFER();
                } else {
                    SslSession sslSession = DtlsTransmitter.access$getSslSession$p(this.this$0);
                    Intrinsics.checkNotNull((Object)it);
                    byteBuffer = sslSession.decrypt(it, (Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>(this.this$0.getTransport$kotlin_mbedtls()){

                        public final void invoke(@NotNull ByteBuffer p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((Transport)this.receiver).send(p0);
                        }
                    }));
                }
                return byteBuffer;
            }
        }, arg_0), (Executor)this.executor);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApplyAsync(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<ByteBuffer> receive() {
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return this.receive(duration);
    }

    @Override
    public int localPort() {
        return this.transport.localPort();
    }

    @Override
    public void close() {
        this.transport.close();
        SingleThreadExecutorKt.supply(this.executor, () -> DtlsTransmitter.close$lambda$3(this)).join();
    }

    public final void closeNotify() {
        SingleThreadExecutorKt.supply(this.executor, () -> DtlsTransmitter.closeNotify$lambda$4(this)).join();
        this.close();
    }

    @NotNull
    public final String getCipherSuite() {
        return this.sslSession.getCipherSuite();
    }

    @Nullable
    public final byte[] getPeerCid() {
        return this.sslSession.getPeerCid();
    }

    @Nullable
    public final byte[] getOwnCid() {
        return this.sslSession.getOwnCid();
    }

    @Nullable
    public final String getPeerCertificateSubject() {
        return this.sslSession.getPeerCertificateSubject();
    }

    @NotNull
    public final byte[] saveSession() {
        return this.sslSession.saveAndClose();
    }

    @NotNull
    public final DtlsTransmitter storeOnClose(@NotNull SessionWriter sessionWriter) {
        DtlsTransmitter dtlsTransmitter;
        Intrinsics.checkNotNullParameter((Object)sessionWriter, (String)"sessionWriter");
        DtlsTransmitter it = dtlsTransmitter = this;
        boolean bl = false;
        this.storeSession = sessionWriter;
        return dtlsTransmitter;
    }

    @Override
    @NotNull
    public <P2> Transport<P2> map(@NotNull Function1<? super ByteBuffer, ? extends P2> f, @NotNull Function1<? super P2, ? extends ByteBuffer> f2) {
        return Transport.DefaultImpls.map(this, f, f2);
    }

    private static final ByteBuffer send$lambda$0(DtlsTransmitter this$0, ByteBuffer $packet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return this$0.sslSession.encrypt($packet);
    }

    private static final CompletionStage send$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final ByteBuffer receive$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ByteBuffer)$tmp0.invoke(p0);
    }

    private static final Unit close$lambda$3(DtlsTransmitter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.sslSession.getOwnCid() != null && !Intrinsics.areEqual((Object)this$0.storeSession, (Object)SessionWriter.NO_OPS)) {
            this$0.storeSession.invoke(this$0.sslSession.getOwnCid(), this$0.sslSession.saveAndClose());
        } else {
            this$0.sslSession.close();
        }
        return Unit.INSTANCE;
    }

    private static final CompletableFuture closeNotify$lambda$4(DtlsTransmitter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.transport.send(this$0.sslSession.closeNotify());
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<DtlsTransmitter> connect(@NotNull Transport<?> server, @NotNull SslConfig conf, int bindPort) {
        return Companion.connect(server, conf, bindPort);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf, int bindPort) {
        return Companion.connect(dest, conf, bindPort);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf, @NotNull Transport<ByteBuffer> trans, @NotNull ExecutorService executor) {
        return Companion.connect(dest, conf, trans, executor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsTransmitter create(@NotNull InetSocketAddress dest, @NotNull SslSession sslSession, int bindPort) {
        return Companion.create(dest, sslSession, bindPort);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsTransmitter create(@NotNull InetSocketAddress dest, @NotNull SslSession sslSession, @NotNull Transport<ByteBuffer> cnnTransmitter) {
        return Companion.create(dest, sslSession, cnnTransmitter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<DtlsTransmitter> connect(@NotNull Transport<?> server, @NotNull SslConfig conf) {
        return Companion.connect(server, conf);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf) {
        return Companion.connect(dest, conf);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf, @NotNull Transport<ByteBuffer> trans) {
        return Companion.connect(dest, conf, trans);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DtlsTransmitter create(@NotNull InetSocketAddress dest, @NotNull SslSession sslSession) {
        return Companion.create(dest, sslSession);
    }

    public static final /* synthetic */ SslSession access$getSslSession$p(DtlsTransmitter $this) {
        return $this.sslSession;
    }

    public /* synthetic */ DtlsTransmitter(InetSocketAddress remoteAddress, Transport transport, SslSession sslSession, ExecutorService executor, DefaultConstructorMarker $constructor_marker) {
        this(remoteAddress, transport, sslSession, executor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J,\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J&\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\r\u0010\u0018\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/opencoap/ssl/transport/DtlsTransmitter$Companion;", "", "()V", "threadIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "connect", "Ljava/util/concurrent/CompletableFuture;", "Lorg/opencoap/ssl/transport/DtlsTransmitter;", "dest", "Ljava/net/InetSocketAddress;", "conf", "Lorg/opencoap/ssl/SslConfig;", "bindPort", "", "trans", "Lorg/opencoap/ssl/transport/Transport;", "Ljava/nio/ByteBuffer;", "executor", "Ljava/util/concurrent/ExecutorService;", "server", "create", "sslSession", "Lorg/opencoap/ssl/SslSession;", "cnnTransmitter", "newSingleExecutor", "newSingleExecutor$kotlin_mbedtls", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutorService newSingleExecutor$kotlin_mbedtls() {
            ExecutorService executorService = Executors.newSingleThreadExecutor(Companion::newSingleExecutor$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
            return executorService;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CompletableFuture<DtlsTransmitter> connect(@NotNull Transport<?> server, @NotNull SslConfig conf, int bindPort) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            return this.connect(new InetSocketAddress(InetAddress.getLocalHost(), server.localPort()), conf, bindPort);
        }

        public static /* synthetic */ CompletableFuture connect$default(Companion companion, Transport transport, SslConfig sslConfig, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.connect(transport, sslConfig, n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf, int bindPort) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            return org.opencoap.ssl.transport.DtlsTransmitter$Companion.connect$default(this, dest, conf, DatagramChannelAdapter.Companion.connect(dest, bindPort), null, 8, null);
        }

        public static /* synthetic */ CompletableFuture connect$default(Companion companion, InetSocketAddress inetSocketAddress, SslConfig sslConfig, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.connect(inetSocketAddress, sslConfig, n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf, @NotNull Transport<ByteBuffer> trans, @NotNull ExecutorService executor) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            Intrinsics.checkNotNullParameter(trans, (String)"trans");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            CompletableFuture<DtlsTransmitter> promise = new CompletableFuture<DtlsTransmitter>();
            SslHandshakeContext sslHandshakeContext = conf.newContext(dest);
            Function1 send2 = (Function1)new Function1<ByteBuffer, Unit>(trans){
                final /* synthetic */ Transport<ByteBuffer> $trans;
                {
                    this.$trans = $trans;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$trans.send(it);
                }
            };
            SslContext sslContext = sslHandshakeContext.step((Function1<? super ByteBuffer, Unit>)send2);
            Intrinsics.checkNotNull((Object)sslContext, (String)"null cannot be cast to non-null type org.opencoap.ssl.SslHandshakeContext");
            SslHandshakeContext sslContext2 = (SslHandshakeContext)sslContext;
            ((CompletableFuture)trans.receive(sslContext2.getReadTimeout()).thenComposeAsync(arg_0 -> Companion.connect$lambda$2((Function1)new Function1<ByteBuffer, CompletableFuture<SslSession>>(sslHandshakeContext, (Function1<? super ByteBuffer, Unit>)send2, trans, executor){
                final /* synthetic */ SslHandshakeContext $sslHandshakeContext;
                final /* synthetic */ Function1<ByteBuffer, Unit> $send;
                final /* synthetic */ Transport<ByteBuffer> $trans;
                final /* synthetic */ ExecutorService $executor;
                {
                    this.$sslHandshakeContext = $sslHandshakeContext;
                    this.$send = $send;
                    this.$trans = $trans;
                    this.$executor = $executor;
                    super(1, Intrinsics.Kotlin.class, "handleReceive", "connect$handleReceive(Lorg/opencoap/ssl/SslHandshakeContext;Lkotlin/jvm/functions/Function1;Lorg/opencoap/ssl/transport/Transport;Ljava/util/concurrent/ExecutorService;Ljava/nio/ByteBuffer;)Ljava/util/concurrent/CompletableFuture;", 0);
                }

                @NotNull
                public final CompletableFuture<SslSession> invoke(@NotNull ByteBuffer p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.opencoap.ssl.transport.DtlsTransmitter$Companion.access$connect$handleReceive(this.$sslHandshakeContext, this.$send, this.$trans, this.$executor, p0);
                }
            }, arg_0), (Executor)executor)).whenComplete((arg_0, arg_1) -> Companion.connect$lambda$3((Function2)new Function2<SslSession, Throwable, Unit>(promise, dest, trans, executor, sslHandshakeContext, conf){
                final /* synthetic */ CompletableFuture<DtlsTransmitter> $promise;
                final /* synthetic */ InetSocketAddress $dest;
                final /* synthetic */ Transport<ByteBuffer> $trans;
                final /* synthetic */ ExecutorService $executor;
                final /* synthetic */ SslHandshakeContext $sslHandshakeContext;
                final /* synthetic */ SslConfig $conf;
                {
                    this.$promise = $promise;
                    this.$dest = $dest;
                    this.$trans = $trans;
                    this.$executor = $executor;
                    this.$sslHandshakeContext = $sslHandshakeContext;
                    this.$conf = $conf;
                    super(2);
                }

                public final void invoke(SslSession sslSession, Throwable ex) {
                    Throwable throwable;
                    Throwable throwable2 = ex;
                    Throwable throwable3 = throwable = throwable2 != null ? throwable2.getCause() : null;
                    if (throwable == null) {
                        Intrinsics.checkNotNull((Object)sslSession);
                        this.$promise.complete(new DtlsTransmitter(this.$dest, this.$trans, sslSession, this.$executor, null));
                    } else if (throwable instanceof HelloVerifyRequired) {
                        this.$sslHandshakeContext.close();
                        DtlsTransmitter.Companion.connect(this.$dest, this.$conf, this.$trans, this.$executor).whenComplete((arg_0, arg_1) -> connect.2.invoke$lambda$0((Function2)new Function2<DtlsTransmitter, Throwable, Unit>(this.$promise){
                            final /* synthetic */ CompletableFuture<DtlsTransmitter> $promise;
                            {
                                this.$promise = $promise;
                                super(2);
                            }

                            public final void invoke(DtlsTransmitter t, Throwable ex2) {
                                if (ex2 != null) {
                                    this.$promise.completeExceptionally(ex2);
                                } else {
                                    this.$promise.complete(t);
                                }
                            }
                        }, arg_0, arg_1));
                    } else {
                        this.$sslHandshakeContext.close();
                        this.$trans.close();
                        this.$promise.completeExceptionally(ex);
                    }
                }

                private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0, p1);
                }
            }, arg_0, arg_1));
            return promise;
        }

        public static /* synthetic */ CompletableFuture connect$default(Companion companion, InetSocketAddress inetSocketAddress, SslConfig sslConfig, Transport transport, ExecutorService executorService, int n, Object object) {
            if ((n & 8) != 0) {
                executorService = companion.newSingleExecutor$kotlin_mbedtls();
            }
            return companion.connect(inetSocketAddress, sslConfig, transport, executorService);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsTransmitter create(@NotNull InetSocketAddress dest, @NotNull SslSession sslSession, int bindPort) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)sslSession, (String)"sslSession");
            return this.create(dest, sslSession, DatagramChannelAdapter.Companion.connect(dest, bindPort));
        }

        public static /* synthetic */ DtlsTransmitter create$default(Companion companion, InetSocketAddress inetSocketAddress, SslSession sslSession, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.create(inetSocketAddress, sslSession, n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsTransmitter create(@NotNull InetSocketAddress dest, @NotNull SslSession sslSession, @NotNull Transport<ByteBuffer> cnnTransmitter) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)sslSession, (String)"sslSession");
            Intrinsics.checkNotNullParameter(cnnTransmitter, (String)"cnnTransmitter");
            return new DtlsTransmitter(dest, cnnTransmitter, sslSession, this.newSingleExecutor$kotlin_mbedtls(), null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CompletableFuture<DtlsTransmitter> connect(@NotNull Transport<?> server, @NotNull SslConfig conf) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            return org.opencoap.ssl.transport.DtlsTransmitter$Companion.connect$default(this, server, conf, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            return org.opencoap.ssl.transport.DtlsTransmitter$Companion.connect$default(this, dest, conf, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CompletableFuture<DtlsTransmitter> connect(@NotNull InetSocketAddress dest, @NotNull SslConfig conf, @NotNull Transport<ByteBuffer> trans) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            Intrinsics.checkNotNullParameter(trans, (String)"trans");
            return org.opencoap.ssl.transport.DtlsTransmitter$Companion.connect$default(this, dest, conf, trans, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final DtlsTransmitter create(@NotNull InetSocketAddress dest, @NotNull SslSession sslSession) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Intrinsics.checkNotNullParameter((Object)sslSession, (String)"sslSession");
            return org.opencoap.ssl.transport.DtlsTransmitter$Companion.create$default(this, dest, sslSession, 0, 4, null);
        }

        private static final Thread newSingleExecutor$lambda$0(Runnable it) {
            return new Thread(it, "dtls-" + threadIndex.getAndIncrement());
        }

        private static final CompletionStage connect$handleReceive$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CompletionStage)$tmp0.invoke(p0);
        }

        private static final CompletableFuture<SslSession> connect$handleReceive(SslHandshakeContext sslHandshakeContext, Function1<? super ByteBuffer, Unit> send2, Transport<ByteBuffer> $trans, ExecutorService $executor, ByteBuffer buffer) {
            CompletionStage<SslContext> completionStage;
            SslContext newSslContext = sslHandshakeContext.step(buffer, send2);
            SslContext sslContext = newSslContext;
            if (sslContext instanceof SslSession) {
                CompletableFuture<SslContext> completableFuture = CompletableFuture.completedFuture(newSslContext);
                completionStage = completableFuture;
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            } else if (sslContext instanceof SslHandshakeContext) {
                Duration timeout = ((SslHandshakeContext)newSslContext).getReadTimeout().isZero() ? Duration.ofSeconds(1L) : ((SslHandshakeContext)newSslContext).getReadTimeout();
                Intrinsics.checkNotNull((Object)timeout);
                CompletionStage completionStage2 = $trans.receive(timeout).thenComposeAsync(arg_0 -> Companion.connect$handleReceive$lambda$1((Function1)new Function1<ByteBuffer, CompletableFuture<SslSession>>(sslHandshakeContext, send2, $trans, $executor){
                    final /* synthetic */ SslHandshakeContext $sslHandshakeContext;
                    final /* synthetic */ Function1<ByteBuffer, Unit> $send;
                    final /* synthetic */ Transport<ByteBuffer> $trans;
                    final /* synthetic */ ExecutorService $executor;
                    {
                        this.$sslHandshakeContext = $sslHandshakeContext;
                        this.$send = $send;
                        this.$trans = $trans;
                        this.$executor = $executor;
                        super(1, Intrinsics.Kotlin.class, "handleReceive", "connect$handleReceive(Lorg/opencoap/ssl/SslHandshakeContext;Lkotlin/jvm/functions/Function1;Lorg/opencoap/ssl/transport/Transport;Ljava/util/concurrent/ExecutorService;Ljava/nio/ByteBuffer;)Ljava/util/concurrent/CompletableFuture;", 0);
                    }

                    @NotNull
                    public final CompletableFuture<SslSession> invoke(@NotNull ByteBuffer p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return org.opencoap.ssl.transport.DtlsTransmitter$Companion.access$connect$handleReceive(this.$sslHandshakeContext, this.$send, this.$trans, this.$executor, p0);
                    }
                }, arg_0), (Executor)$executor);
                Intrinsics.checkNotNull((Object)completionStage2);
                completionStage = completionStage2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return completionStage;
        }

        private static final CompletionStage connect$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CompletionStage)$tmp0.invoke(p0);
        }

        private static final void connect$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public static final /* synthetic */ CompletableFuture access$connect$handleReceive(SslHandshakeContext sslHandshakeContext, Function1 send2, Transport $trans, ExecutorService $executor, ByteBuffer buffer) {
            return org.opencoap.ssl.transport.DtlsTransmitter$Companion.connect$handleReceive(sslHandshakeContext, (Function1<? super ByteBuffer, Unit>)send2, $trans, $executor, buffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

