/*
 * Decompiled with CFR 0.152.
 */
package org.opencoap.ssl.transport;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencoap.ssl.transport.DtlsSessionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0000\"\u0004\b\u0001\u0010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001b0\u001dJ\u001f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0000\"\u0004\b\u0001\u0010\u001b2\u0006\u0010\u001e\u001a\u0002H\u001b\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/opencoap/ssl/transport/Packet;", "T", "", "buffer", "peerAddress", "Ljava/net/InetSocketAddress;", "sessionContext", "Lorg/opencoap/ssl/transport/DtlsSessionContext;", "(Ljava/lang/Object;Ljava/net/InetSocketAddress;Lorg/opencoap/ssl/transport/DtlsSessionContext;)V", "getBuffer", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPeerAddress", "()Ljava/net/InetSocketAddress;", "getSessionContext", "()Lorg/opencoap/ssl/transport/DtlsSessionContext;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/net/InetSocketAddress;Lorg/opencoap/ssl/transport/DtlsSessionContext;)Lorg/opencoap/ssl/transport/Packet;", "equals", "", "other", "hashCode", "", "map", "T2", "f", "Lkotlin/Function1;", "newBuf", "(Ljava/lang/Object;)Lorg/opencoap/ssl/transport/Packet;", "toString", "", "Companion", "kotlin-mbedtls"})
public final class Packet<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final T buffer;
    @NotNull
    private final InetSocketAddress peerAddress;
    @NotNull
    private final DtlsSessionContext sessionContext;
    @NotNull
    private static final ByteBuffer EMPTY_BYTEBUFFER;
    @NotNull
    private static final Packet<ByteBuffer> EmptyByteBufferPacket;

    @JvmOverloads
    public Packet(T buffer, @NotNull InetSocketAddress peerAddress, @NotNull DtlsSessionContext sessionContext) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        Intrinsics.checkNotNullParameter((Object)sessionContext, (String)"sessionContext");
        this.buffer = buffer;
        this.peerAddress = peerAddress;
        this.sessionContext = sessionContext;
    }

    public /* synthetic */ Packet(Object object, InetSocketAddress inetSocketAddress, DtlsSessionContext dtlsSessionContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            dtlsSessionContext = DtlsSessionContext.EMPTY;
        }
        this(object, inetSocketAddress, dtlsSessionContext);
    }

    public final T getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    @NotNull
    public final DtlsSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @NotNull
    public final <T2> Packet<T2> map(@NotNull Function1<? super T, ? extends T2> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new Packet<Object>(f.invoke(this.buffer), this.peerAddress, this.sessionContext);
    }

    @NotNull
    public final <T2> Packet<T2> map(T2 newBuf) {
        return new Packet<T2>(newBuf, this.peerAddress, this.sessionContext);
    }

    public final T component1() {
        return this.buffer;
    }

    @NotNull
    public final InetSocketAddress component2() {
        return this.peerAddress;
    }

    @NotNull
    public final DtlsSessionContext component3() {
        return this.sessionContext;
    }

    @NotNull
    public final Packet<T> copy(T buffer, @NotNull InetSocketAddress peerAddress, @NotNull DtlsSessionContext sessionContext) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        Intrinsics.checkNotNullParameter((Object)sessionContext, (String)"sessionContext");
        return new Packet<T>(buffer, peerAddress, sessionContext);
    }

    public static /* synthetic */ Packet copy$default(Packet packet, Object object, InetSocketAddress inetSocketAddress, DtlsSessionContext dtlsSessionContext, int n, Object object2) {
        if ((n & 1) != 0) {
            object = packet.buffer;
        }
        if ((n & 2) != 0) {
            inetSocketAddress = packet.peerAddress;
        }
        if ((n & 4) != 0) {
            dtlsSessionContext = packet.sessionContext;
        }
        return packet.copy(object, inetSocketAddress, dtlsSessionContext);
    }

    @NotNull
    public String toString() {
        return "Packet(buffer=" + this.buffer + ", peerAddress=" + this.peerAddress + ", sessionContext=" + this.sessionContext + ')';
    }

    public int hashCode() {
        int result = this.buffer == null ? 0 : this.buffer.hashCode();
        result = result * 31 + this.peerAddress.hashCode();
        result = result * 31 + this.sessionContext.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Packet)) {
            return false;
        }
        Packet packet = (Packet)other;
        if (!Intrinsics.areEqual(this.buffer, packet.buffer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.peerAddress, (Object)packet.peerAddress)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sessionContext, (Object)packet.sessionContext);
    }

    @JvmOverloads
    public Packet(T buffer, @NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        this(buffer, peerAddress, null, 4, null);
    }

    @NotNull
    public static final ByteBuffer getEMPTY_BYTEBUFFER() {
        return Companion.getEMPTY_BYTEBUFFER();
    }

    @NotNull
    public static final Packet<ByteBuffer> getEmptyByteBufferPacket() {
        return Companion.getEmptyByteBufferPacket();
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        EMPTY_BYTEBUFFER = byteBuffer;
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved("", 0);
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"createUnresolved(...)");
        EmptyByteBufferPacket = new Packet(EMPTY_BYTEBUFFER, inetSocketAddress, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00040\tj\u0002`\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/opencoap/ssl/transport/Packet$Companion;", "", "()V", "EMPTY_BYTEBUFFER", "Ljava/nio/ByteBuffer;", "getEMPTY_BYTEBUFFER$annotations", "getEMPTY_BYTEBUFFER", "()Ljava/nio/ByteBuffer;", "EmptyByteBufferPacket", "Lorg/opencoap/ssl/transport/Packet;", "Lorg/opencoap/ssl/transport/ByteBufferPacket;", "getEmptyByteBufferPacket$annotations", "getEmptyByteBufferPacket", "()Lorg/opencoap/ssl/transport/Packet;", "kotlin-mbedtls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteBuffer getEMPTY_BYTEBUFFER() {
            return EMPTY_BYTEBUFFER;
        }

        @JvmStatic
        public static /* synthetic */ void getEMPTY_BYTEBUFFER$annotations() {
        }

        @NotNull
        public final Packet<ByteBuffer> getEmptyByteBufferPacket() {
            return EmptyByteBufferPacket;
        }

        @JvmStatic
        public static /* synthetic */ void getEmptyByteBufferPacket$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

