/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ceph;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.ceph.CephFsProto;

public class CephInputStream
extends FSInputStream {
    private static final Log LOG = LogFactory.getLog(CephInputStream.class);
    private boolean closed;
    private int fileHandle;
    private long fileLength;
    private CephFsProto ceph;
    private byte[] buffer;
    private int bufPos = 0;
    private int bufValid = 0;
    private long cephPos = 0L;

    public CephInputStream(Configuration conf, CephFsProto cephfs, int fh, long flength, int bufferSize) {
        this.fileLength = flength;
        this.fileHandle = fh;
        this.closed = false;
        this.ceph = cephfs;
        this.buffer = new byte[0x200000];
        LOG.debug((Object)("CephInputStream constructor: initializing stream with fh " + fh + " and file length " + flength));
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private synchronized boolean fillBuffer() throws IOException {
        this.bufValid = this.ceph.read(this.fileHandle, this.buffer, this.buffer.length, -1L);
        this.bufPos = 0;
        if (this.bufValid < 0) {
            int err = this.bufValid;
            this.bufValid = 0;
            this.ceph.lseek(this.fileHandle, this.cephPos, 1);
            throw new IOException("Failed to fill read buffer! Error code:" + err);
        }
        this.cephPos += (long)this.bufValid;
        return this.bufValid != 0;
    }

    public synchronized long getPos() throws IOException {
        return this.cephPos - (long)this.bufValid + (long)this.bufPos;
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("file is closed");
        }
        return (int)(this.fileLength - this.getPos());
    }

    public synchronized void seek(long targetPos) throws IOException {
        LOG.trace((Object)("CephInputStream.seek: Seeking to position " + targetPos + " on fd " + this.fileHandle));
        if (targetPos > this.fileLength) {
            throw new IOException("CephInputStream.seek: failed seek to position " + targetPos + " on fd " + this.fileHandle + ": Cannot seek after EOF " + this.fileLength);
        }
        long oldPos = this.cephPos;
        this.cephPos = this.ceph.lseek(this.fileHandle, targetPos, 1);
        this.bufValid = 0;
        this.bufPos = 0;
        if (this.cephPos < 0L) {
            this.cephPos = oldPos;
            throw new IOException("Ceph failed to seek to new position!");
        }
    }

    public synchronized boolean seekToNewSource(long targetPos) {
        return false;
    }

    public synchronized int read() throws IOException {
        LOG.trace((Object)("CephInputStream.read: Reading a single byte from fd " + this.fileHandle + " by calling general read function"));
        byte[] result = new byte[1];
        if (this.getPos() >= this.fileLength) {
            return -1;
        }
        if (-1 == this.read(result, 0, 1)) {
            return -1;
        }
        if (result[0] < 0) {
            return 256 + result[0];
        }
        return result[0];
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int read;
        LOG.trace((Object)("CephInputStream.read: Reading " + len + " bytes from fd " + this.fileHandle));
        if (this.closed) {
            throw new IOException("CephInputStream.read: cannot read " + len + " bytes from fd " + this.fileHandle + ": stream closed");
        }
        if (this.getPos() >= this.fileLength) {
            LOG.debug((Object)("CephInputStream.read: cannot read " + len + " bytes from fd " + this.fileHandle + ": current position is " + this.getPos() + " and file length is " + this.fileLength));
            return -1;
        }
        int totalRead = 0;
        int initialLen = len;
        do {
            read = Math.min(len, this.bufValid - this.bufPos);
            try {
                System.arraycopy(this.buffer, this.bufPos, buf, off, read);
            }
            catch (IndexOutOfBoundsException ie) {
                throw new IOException("CephInputStream.read: Indices out of bounds:read length is " + len + ", buffer offset is " + off + ", and buffer size is " + buf.length);
            }
            catch (ArrayStoreException ae) {
                throw new IOException("Uh-oh, CephInputStream failed to do an arraycopy due to type mismatch...");
            }
            catch (NullPointerException ne) {
                throw new IOException("CephInputStream.read: cannot read " + len + "bytes from fd:" + this.fileHandle + ": buf is null");
            }
            this.bufPos += read;
            off += read;
            totalRead += read;
        } while ((len -= read) > 0 && this.fillBuffer());
        LOG.trace((Object)("CephInputStream.read: Reading " + initialLen + " bytes from fd " + this.fileHandle + ": succeeded in reading " + totalRead + " bytes"));
        return totalRead;
    }

    public void close() throws IOException {
        LOG.trace((Object)"CephOutputStream.close:enter");
        if (!this.closed) {
            this.ceph.close(this.fileHandle);
            this.closed = true;
            LOG.trace((Object)"CephOutputStream.close:exit");
        }
    }
}

