/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ceph;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ceph.CephFsProto;

public class CephOutputStream
extends OutputStream {
    private static final Log LOG = LogFactory.getLog(CephOutputStream.class);
    private boolean closed;
    private CephFsProto ceph;
    private int fileHandle;
    private byte[] buffer;
    private int bufUsed = 0;

    public CephOutputStream(Configuration conf, CephFsProto cephfs, int fh, int bufferSize) {
        this.ceph = cephfs;
        this.fileHandle = fh;
        this.closed = false;
        this.buffer = new byte[0x200000];
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private synchronized void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("operation on closed stream (fd=" + this.fileHandle + ")");
        }
    }

    public synchronized long getPos() throws IOException {
        this.checkOpen();
        return this.ceph.lseek(this.fileHandle, 0L, 2);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        this.checkOpen();
        while (len > 0) {
            int remaining = Math.min(len, this.buffer.length - this.bufUsed);
            System.arraycopy(buf, off, this.buffer, this.bufUsed, remaining);
            this.bufUsed += remaining;
            off += remaining;
            len -= remaining;
            if (this.buffer.length != this.bufUsed) continue;
            this.flushBuffer();
        }
    }

    private synchronized void flushBuffer() throws IOException {
        if (this.bufUsed == 0) {
            return;
        }
        while (this.bufUsed > 0) {
            int ret = this.ceph.write(this.fileHandle, this.buffer, this.bufUsed, -1L);
            if (ret < 0) {
                throw new IOException("ceph.write: ret=" + ret);
            }
            if (ret == this.bufUsed) {
                this.bufUsed = 0;
                return;
            }
            assert (ret > 0);
            assert (ret < this.bufUsed);
            int remaining = this.bufUsed - ret;
            System.arraycopy(this.buffer, ret, this.buffer, 0, remaining);
            this.bufUsed -= ret;
        }
        assert (this.bufUsed == 0);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkOpen();
        this.flushBuffer();
        this.ceph.fsync(this.fileHandle);
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkOpen();
        this.flush();
        this.ceph.close(this.fileHandle);
        this.closed = true;
    }
}

