/*
 * Decompiled with CFR 0.152.
 */
package org.opendcs.maven.central.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.opendcs.maven.central.invoker.ApiClient;
import org.opendcs.maven.central.invoker.ApiException;
import org.opendcs.maven.central.invoker.ApiResponse;
import org.opendcs.maven.central.invoker.Configuration;
import org.opendcs.maven.central.invoker.Pair;
import org.opendcs.maven.central.model.ApiV1PublisherDeploymentsFilesPost200Response;
import org.opendcs.maven.central.model.ApiV1PublisherDeploymentsFilesPostRequest;

public class InformationApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public InformationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InformationApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ApiV1PublisherDeploymentsFilesPost200Response apiV1PublisherDeploymentsFilesPost(ApiV1PublisherDeploymentsFilesPostRequest apiV1PublisherDeploymentsFilesPostRequest) throws ApiException {
        ApiResponse<ApiV1PublisherDeploymentsFilesPost200Response> localVarResponse = this.apiV1PublisherDeploymentsFilesPostWithHttpInfo(apiV1PublisherDeploymentsFilesPostRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ApiV1PublisherDeploymentsFilesPost200Response> apiV1PublisherDeploymentsFilesPostWithHttpInfo(ApiV1PublisherDeploymentsFilesPostRequest apiV1PublisherDeploymentsFilesPostRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.apiV1PublisherDeploymentsFilesPostRequestBuilder(apiV1PublisherDeploymentsFilesPostRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("apiV1PublisherDeploymentsFilesPost", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (ApiV1PublisherDeploymentsFilesPost200Response)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ApiV1PublisherDeploymentsFilesPost200Response>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder apiV1PublisherDeploymentsFilesPostRequestBuilder(ApiV1PublisherDeploymentsFilesPostRequest apiV1PublisherDeploymentsFilesPostRequest) throws ApiException {
        if (apiV1PublisherDeploymentsFilesPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'apiV1PublisherDeploymentsFilesPostRequest' when calling apiV1PublisherDeploymentsFilesPost");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/publisher/deployments/files";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)apiV1PublisherDeploymentsFilesPostRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public HashMap<String, Object> apiV1PublisherPublishedGet(String namespace, String name, String version) throws ApiException {
        ApiResponse<HashMap<String, Object>> localVarResponse = this.apiV1PublisherPublishedGetWithHttpInfo(namespace, name, version);
        return localVarResponse.getData();
    }

    public ApiResponse<HashMap<String, Object>> apiV1PublisherPublishedGetWithHttpInfo(String namespace, String name, String version) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.apiV1PublisherPublishedGetRequestBuilder(namespace, name, version);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("apiV1PublisherPublishedGet", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (HashMap)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder apiV1PublisherPublishedGetRequestBuilder(String namespace, String name, String version) throws ApiException {
        if (namespace == null) {
            throw new ApiException(400, "Missing the required parameter 'namespace' when calling apiV1PublisherPublishedGet");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling apiV1PublisherPublishedGet");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling apiV1PublisherPublishedGet");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/publisher/published";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "namespace";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("namespace", namespace));
        localVarQueryParameterBaseName = "name";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("name", name));
        localVarQueryParameterBaseName = "version";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("version", version));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

