/*
 * Decompiled with CFR 0.152.
 */
package org.opendcs.maven.central.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;
import org.opendcs.maven.central.invoker.ApiClient;
import org.opendcs.maven.central.invoker.ApiException;
import org.opendcs.maven.central.invoker.ApiResponse;
import org.opendcs.maven.central.invoker.Configuration;

public class IntegrationApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public IntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGet(String deploymentId, String relativePath) throws ApiException {
        ApiResponse<File> localVarResponse = this.apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGetWithHttpInfo(deploymentId, relativePath);
        return localVarResponse.getData();
    }

    public ApiResponse<File> apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGetWithHttpInfo(String deploymentId, String relativePath) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGetRequestBuilder(deploymentId, relativePath);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGet", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (File)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGetRequestBuilder(String deploymentId, String relativePath) throws ApiException {
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGet");
        }
        if (relativePath == null) {
            throw new ApiException(400, "Missing the required parameter 'relativePath' when calling apiV1PublisherDeploymentDeploymentIdDownloadRelativePathGet");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/publisher/deployment/{deploymentId}/download/{relativePath}".replace("{deploymentId}", ApiClient.urlEncode(deploymentId.toString())).replace("{relativePath}", ApiClient.urlEncode(relativePath.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/octet-stream");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File apiV1PublisherDeploymentsDownloadRelativePathGet(String relativePath) throws ApiException {
        ApiResponse<File> localVarResponse = this.apiV1PublisherDeploymentsDownloadRelativePathGetWithHttpInfo(relativePath);
        return localVarResponse.getData();
    }

    public ApiResponse<File> apiV1PublisherDeploymentsDownloadRelativePathGetWithHttpInfo(String relativePath) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.apiV1PublisherDeploymentsDownloadRelativePathGetRequestBuilder(relativePath);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("apiV1PublisherDeploymentsDownloadRelativePathGet", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (File)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder apiV1PublisherDeploymentsDownloadRelativePathGetRequestBuilder(String relativePath) throws ApiException {
        if (relativePath == null) {
            throw new ApiException(400, "Missing the required parameter 'relativePath' when calling apiV1PublisherDeploymentsDownloadRelativePathGet");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/publisher/deployments/download/{relativePath}".replace("{relativePath}", ApiClient.urlEncode(relativePath.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/octet-stream");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

