/*
 * Decompiled with CFR 0.152.
 */
package org.opendcs.maven.central.invoker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.opendcs.maven.central.invoker.Pair;

public class ApiClient {
    private HttpClient.Builder builder;
    private ObjectMapper mapper;
    private String scheme;
    private String host;
    private int port;
    private String basePath;
    private Consumer<HttpRequest.Builder> interceptor;
    private Consumer<HttpResponse<InputStream>> responseInterceptor;
    private Consumer<HttpResponse<String>> asyncResponseInterceptor;
    private Duration readTimeout;
    private Duration connectTimeout;

    public static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return value.toString();
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    public static List<Pair> parameterToPairs(String name, Object value) {
        if (name == null || name.isEmpty() || value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Pair(ApiClient.urlEncode(name), ApiClient.urlEncode(ApiClient.valueToString(value))));
    }

    public static List<Pair> parameterToPairs(String collectionFormat, String name, Collection<?> values) {
        String format;
        if (name == null || name.isEmpty() || values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            return values.stream().map(value -> new Pair(ApiClient.urlEncode(name), ApiClient.urlEncode(ApiClient.valueToString(value)))).collect(Collectors.toList());
        }
        StringJoiner joiner = new StringJoiner(switch (format) {
            case "csv" -> ApiClient.urlEncode(",");
            case "ssv" -> ApiClient.urlEncode(" ");
            case "tsv" -> ApiClient.urlEncode("\t");
            case "pipes" -> ApiClient.urlEncode("|");
            default -> throw new IllegalArgumentException("Illegal collection format: " + collectionFormat);
        });
        for (Object value2 : values) {
            joiner.add(ApiClient.urlEncode(ApiClient.valueToString(value2)));
        }
        return Collections.singletonList(new Pair(ApiClient.urlEncode(name), joiner.toString()));
    }

    public ApiClient() {
        this.builder = ApiClient.createDefaultHttpClientBuilder();
        this.mapper = ApiClient.createDefaultObjectMapper();
        this.updateBaseUri(this.getDefaultBaseUri());
        this.interceptor = null;
        this.readTimeout = null;
        this.connectTimeout = null;
        this.responseInterceptor = null;
        this.asyncResponseInterceptor = null;
    }

    public ApiClient(HttpClient.Builder builder, ObjectMapper mapper, String baseUri) {
        this.builder = builder;
        this.mapper = mapper;
        this.updateBaseUri(baseUri != null ? baseUri : this.getDefaultBaseUri());
        this.interceptor = null;
        this.readTimeout = null;
        this.connectTimeout = null;
        this.responseInterceptor = null;
        this.asyncResponseInterceptor = null;
    }

    public static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new JsonNullableModule());
        return mapper;
    }

    private String getDefaultBaseUri() {
        return "http://localhost";
    }

    public static HttpClient.Builder createDefaultHttpClientBuilder() {
        return HttpClient.newBuilder();
    }

    public final void updateBaseUri(String baseUri) {
        URI uri = URI.create(baseUri);
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.basePath = uri.getRawPath();
    }

    public ApiClient setHttpClientBuilder(HttpClient.Builder builder) {
        this.builder = builder;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.builder.build();
    }

    public ApiClient setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper.copy();
    }

    public ApiClient setHost(String host) {
        this.host = host;
        return this;
    }

    public ApiClient setPort(int port) {
        this.port = port;
        return this;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getBaseUri() {
        return this.scheme + "://" + this.host + (String)(this.port == -1 ? "" : ":" + this.port) + this.basePath;
    }

    public ApiClient setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public ApiClient setRequestInterceptor(Consumer<HttpRequest.Builder> interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Consumer<HttpRequest.Builder> getRequestInterceptor() {
        return this.interceptor;
    }

    public ApiClient setResponseInterceptor(Consumer<HttpResponse<InputStream>> interceptor) {
        this.responseInterceptor = interceptor;
        return this;
    }

    public Consumer<HttpResponse<InputStream>> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public ApiClient setAsyncResponseInterceptor(Consumer<HttpResponse<String>> interceptor) {
        this.asyncResponseInterceptor = interceptor;
        return this;
    }

    public Consumer<HttpResponse<String>> getAsyncResponseInterceptor() {
        return this.asyncResponseInterceptor;
    }

    public ApiClient setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.builder.connectTimeout(connectTimeout);
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }
}

