/*
 * Decompiled with CFR 0.152.
 */
package org.opendcs.maven.central.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.opendcs.maven.central.invoker.ApiClient;

@JsonPropertyOrder(value={"name", "path", "errors", "warnings"})
public class DeployedComponentVersion {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private String path;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    @Nullable
    private List<String> errors = new ArrayList<String>();
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    @Nullable
    private List<String> warnings = new ArrayList<String>();

    public DeployedComponentVersion name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public DeployedComponentVersion path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public DeployedComponentVersion errors(@Nullable List<String> errors) {
        this.errors = errors;
        return this;
    }

    public DeployedComponentVersion addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(@Nullable List<String> errors) {
        this.errors = errors;
    }

    public DeployedComponentVersion warnings(@Nullable List<String> warnings) {
        this.warnings = warnings;
        return this;
    }

    public DeployedComponentVersion addWarningsItem(String warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(@Nullable List<String> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployedComponentVersion deployedComponentVersion = (DeployedComponentVersion)o;
        return Objects.equals(this.name, deployedComponentVersion.name) && Objects.equals(this.path, deployedComponentVersion.path) && Objects.equals(this.errors, deployedComponentVersion.errors) && Objects.equals(this.warnings, deployedComponentVersion.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path, this.errors, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeployedComponentVersion {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getName()))));
        }
        if (this.getPath() != null) {
            joiner.add(String.format("%spath%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getPath()))));
        }
        if (this.getErrors() != null) {
            for (i = 0; i < this.getErrors().size(); ++i) {
                joiner.add(String.format("%serrors%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), ApiClient.urlEncode(ApiClient.valueToString(this.getErrors().get(i)))));
            }
        }
        if (this.getWarnings() != null) {
            for (i = 0; i < this.getWarnings().size(); ++i) {
                joiner.add(String.format("%swarnings%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), ApiClient.urlEncode(ApiClient.valueToString(this.getWarnings().get(i)))));
            }
        }
        return joiner.toString();
    }
}

