/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import feign.AsyncClient;
import feign.FeignException;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics4.BaseMeteredClient;
import feign.metrics4.FeignMetricName;
import feign.metrics4.MetricSuppliers;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MeteredAsyncClient
extends BaseMeteredClient
implements AsyncClient<Object> {
    private final AsyncClient<Object> asyncClient;

    public MeteredAsyncClient(AsyncClient<Object> asyncClient, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        super(metricRegistry, new FeignMetricName(AsyncClient.class), metricSuppliers);
        this.asyncClient = asyncClient;
    }

    public CompletableFuture<Response> execute(Request request, Request.Options options, Optional<Object> requestContext) {
        RequestTemplate template = request.requestTemplate();
        Timer.Context timer = this.createTimer(template);
        return ((CompletableFuture)this.asyncClient.execute(request, options, requestContext).whenComplete((response, th) -> {
            if (th == null) {
                this.recordSuccess(template, (Response)response);
            } else if (th instanceof FeignException) {
                FeignException e = (FeignException)th;
                this.recordFailure(template, e);
            } else if (th instanceof Exception) {
                Exception e = (Exception)th;
                this.recordFailure(template, e);
            }
        })).whenComplete((response, th) -> timer.close());
    }
}

