/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.metrics4.FeignMetricName;
import feign.metrics4.MeteredBody;
import feign.metrics4.MetricSuppliers;
import java.io.IOException;
import java.lang.reflect.Type;

public class MeteredDecoder
implements Decoder {
    private final Decoder decoder;
    private final MetricRegistry metricRegistry;
    private final MetricSuppliers metricSuppliers;
    private final FeignMetricName metricName;

    public MeteredDecoder(Decoder decoder, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.decoder = decoder;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Decoder.class);
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        Object decoded;
        RequestTemplate template = response.request().requestTemplate();
        MeteredBody body = response.body() == null ? null : new MeteredBody(response.body());
        response = response.toBuilder().body((Response.Body)body).build();
        try (Timer.Context classTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.metricName.metricName(template.methodMetadata(), template.feignTarget()), (String[])new String[]{"uri", template.methodMetadata().template().path()}), this.metricSuppliers.timers()).time();){
            decoded = this.decoder.decode(response, type);
        }
        if (body != null) {
            this.metricRegistry.histogram(this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "response_size"), this.metricSuppliers.histograms()).update(body.count());
        }
        return decoded;
    }
}

