/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxb;

import feign.jaxb.JAXBContextCacheKey;
import feign.jaxb.JAXBContextInstantationMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public final class JAXBContextFactory {
    private final ConcurrentHashMap<JAXBContextCacheKey, JAXBContext> jaxbContexts = new ConcurrentHashMap(64);
    private final Map<String, Object> properties;
    private final JAXBContextInstantationMode jaxbContextInstantationMode;

    private JAXBContextFactory(Map<String, Object> properties, JAXBContextInstantationMode jaxbContextInstantationMode) {
        this.properties = properties;
        this.jaxbContextInstantationMode = jaxbContextInstantationMode;
    }

    public Unmarshaller createUnmarshaller(Class<?> clazz) throws JAXBException {
        return this.getContext(clazz).createUnmarshaller();
    }

    public Marshaller createMarshaller(Class<?> clazz) throws JAXBException {
        Marshaller marshaller = this.getContext(clazz).createMarshaller();
        this.setMarshallerProperties(marshaller);
        return marshaller;
    }

    private void setMarshallerProperties(Marshaller marshaller) throws PropertyException {
        for (Map.Entry<String, Object> en : this.properties.entrySet()) {
            marshaller.setProperty(en.getKey(), en.getValue());
        }
    }

    private JAXBContext getContext(Class<?> clazz) throws JAXBException {
        JAXBContextCacheKey cacheKey = this.jaxbContextInstantationMode.getJAXBContextCacheKey(clazz);
        JAXBContext jaxbContext = this.jaxbContexts.get(cacheKey);
        if (jaxbContext == null) {
            jaxbContext = this.jaxbContextInstantationMode.getJAXBContext(clazz);
            this.jaxbContexts.putIfAbsent(cacheKey, jaxbContext);
        }
        return jaxbContext;
    }

    private void preloadContextCache(List<Class<?>> classes) throws JAXBException {
        if (classes != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                this.getContext(clazz);
            }
        }
    }

    public static class Builder {
        private final Map<String, Object> properties = new HashMap<String, Object>(10);
        private JAXBContextInstantationMode jaxbContextInstantationMode = JAXBContextInstantationMode.CLASS;

        public Builder withMarshallerJAXBEncoding(String value) {
            this.properties.put("jaxb.encoding", value);
            return this;
        }

        public Builder withMarshallerSchemaLocation(String value) {
            this.properties.put("jaxb.schemaLocation", value);
            return this;
        }

        public Builder withMarshallerNoNamespaceSchemaLocation(String value) {
            this.properties.put("jaxb.noNamespaceSchemaLocation", value);
            return this;
        }

        public Builder withMarshallerFormattedOutput(Boolean value) {
            this.properties.put("jaxb.formatted.output", value);
            return this;
        }

        public Builder withMarshallerFragment(Boolean value) {
            this.properties.put("jaxb.fragment", value);
            return this;
        }

        public Builder withProperty(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder withJAXBContextInstantiationMode(JAXBContextInstantationMode jaxbContextInstantiationMode) {
            this.jaxbContextInstantationMode = jaxbContextInstantiationMode;
            return this;
        }

        public JAXBContextFactory build() {
            return new JAXBContextFactory(this.properties, this.jaxbContextInstantationMode);
        }

        public JAXBContextFactory build(List<Class<?>> classes) throws JAXBException {
            JAXBContextFactory factory = new JAXBContextFactory(this.properties, this.jaxbContextInstantationMode);
            factory.preloadContextCache(classes);
            return factory;
        }
    }
}

