/*
 * Decompiled with CFR 0.152.
 */
package feign.mock;

import feign.Request;
import feign.Util;
import feign.mock.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class RequestKey {
    private final HttpMethod method;
    private final String url;
    private final Map<String, Collection<String>> headers;
    private final Charset charset;
    private final byte[] body;

    public static Builder builder(HttpMethod method, String url) {
        return new Builder(method, url);
    }

    public static RequestKey create(Request request) {
        return new RequestKey(request);
    }

    private static String buildUrl(Request request) {
        try {
            return URLDecoder.decode(request.url(), Util.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private RequestKey(Builder builder) {
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers;
        this.charset = builder.charset;
        this.body = builder.body;
    }

    private RequestKey(Request request) {
        this.method = HttpMethod.valueOf(request.method());
        this.url = RequestKey.buildUrl(request);
        this.headers = request.headers();
        this.charset = request.charset();
        this.body = request.body();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public byte[] getBody() {
        return this.body;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestKey other = (RequestKey)obj;
        if (this.method != other.method) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public boolean equalsExtended(Object obj) {
        if (this.equals(obj)) {
            RequestKey other = (RequestKey)obj;
            boolean headersEqual = other.headers == null || this.headers == null || this.headers.equals(other.headers);
            boolean charsetEqual = other.charset == null || this.charset == null || this.charset.equals(other.charset);
            boolean bodyEqual = other.body == null || this.body == null || Arrays.equals(other.body, this.body);
            return headersEqual && charsetEqual && bodyEqual;
        }
        return false;
    }

    public String toString() {
        return String.format("Request [%s %s: %s headers and %s]", new Object[]{this.method, this.url, this.headers == null ? "without" : "with " + this.headers.size(), this.charset == null ? "no charset" : "charset " + this.charset});
    }

    public static class Builder {
        private final HttpMethod method;
        private final String url;
        private Map<String, Collection<String>> headers;
        private Charset charset;
        private byte[] body;

        private Builder(HttpMethod method, String url) {
            this.method = method;
            this.url = url;
        }

        public Builder headers(Map<String, Collection<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder body(String body) {
            return this.body(body.getBytes(Util.UTF_8));
        }

        public Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        public RequestKey build() {
            return new RequestKey(this);
        }
    }
}

