/*
 * Decompiled with CFR 0.152.
 */
package feign.reactive;

import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.reactive.ReactiveFeign;
import feign.reactive.ReactorInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactorFeign
extends ReactiveFeign {
    public static Builder builder() {
        return new Builder();
    }

    private static class ReactorInvocationHandlerFactory
    implements InvocationHandlerFactory {
        private final Scheduler scheduler;

        private ReactorInvocationHandlerFactory(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            return new ReactorInvocationHandler(target, dispatch, this.scheduler);
        }
    }

    public static class Builder
    extends ReactiveFeign.Builder {
        private Scheduler scheduler = Schedulers.elastic();

        @Override
        public Feign build() {
            super.invocationHandlerFactory((InvocationHandlerFactory)new ReactorInvocationHandlerFactory(this.scheduler));
            return super.build();
        }

        public Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            throw new UnsupportedOperationException("Invocation Handler Factory overrides are not supported.");
        }

        public Builder scheduleOn(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }
    }
}

