/*
 * Decompiled with CFR 0.152.
 */
package feign.ribbon;

import com.netflix.client.ClientFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import feign.ribbon.LBClient;

public interface LBClientFactory {
    public static final IClientConfigKey<String> RetryableStatusCodes = new CommonClientConfigKey<String>("RetryableStatusCodes"){};

    public LBClient create(String var1);

    public static final class DisableAutoRetriesByDefaultClientConfig
    extends DefaultClientConfigImpl {
        public int getDefaultMaxAutoRetriesNextServer() {
            return 0;
        }

        public void loadDefaultValues() {
            super.loadDefaultValues();
            this.putDefaultStringProperty(RetryableStatusCodes, "");
        }
    }

    public static final class Default
    implements LBClientFactory {
        @Override
        public LBClient create(String clientName) {
            IClientConfig config = ClientFactory.getNamedConfig((String)clientName, DisableAutoRetriesByDefaultClientConfig.class);
            ILoadBalancer lb = ClientFactory.getNamedLoadBalancer((String)clientName);
            return LBClient.create(lb, config);
        }
    }
}

