/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils;

import com.querydsl.codegen.utils.AbstractEvaluatorFactory;
import com.querydsl.codegen.utils.CodegenException;
import com.querydsl.codegen.utils.MemFileManager;
import com.querydsl.codegen.utils.MemJavaFileObject;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;

public class ECJEvaluatorFactory
extends AbstractEvaluatorFactory {
    private final MemFileManager fileManager;
    private final ClassLoader parentClassLoader;
    private final List<String> problemList = new ArrayList<String>();
    private final CompilerOptions compilerOptions;

    public static CompilerOptions getDefaultCompilerOptions() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.source", javaSpecVersion);
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaSpecVersion);
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        return new CompilerOptions(settings);
    }

    public ECJEvaluatorFactory(ClassLoader parent) {
        this(parent, ECJEvaluatorFactory.getDefaultCompilerOptions());
    }

    public ECJEvaluatorFactory(ClassLoader parent, CompilerOptions compilerOptions) {
        this.parentClassLoader = parent;
        this.fileManager = new MemFileManager(parent, (StandardJavaFileManager)new EclipseFileManager(Locale.getDefault(), Charset.defaultCharset()));
        this.loader = this.fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
        this.compilerOptions = compilerOptions;
    }

    @Override
    protected void compile(String source, ClassType projectionType, String[] names, Type[] types, String id, Map<String, Object> constants) throws IOException {
        source = this.createSource(source, projectionType, names, types, id, constants);
        final char[] targetContents = source.toCharArray();
        final String targetName = id;
        final ICompilationUnit[] targetCompilationUnits = new ICompilationUnit[]{new ICompilationUnit(){

            public char[] getContents() {
                return targetContents;
            }

            public char[] getMainTypeName() {
                int dot = targetName.lastIndexOf(46);
                if (dot > 0) {
                    return targetName.substring(dot + 1).toCharArray();
                }
                return targetName.toCharArray();
            }

            public char[][] getPackageName() {
                StringTokenizer tok = new StringTokenizer(targetName, ".");
                char[][] result = new char[tok.countTokens() - 1][];
                for (int j = 0; j < result.length; ++j) {
                    result[j] = tok.nextToken().toCharArray();
                }
                return result;
            }

            public char[] getFileName() {
                return CharOperation.concat((char[])targetName.toCharArray(), (char[])".java".toCharArray());
            }

            public boolean ignoreOptionalProblems() {
                return true;
            }
        }};
        INameEnvironment env = new INameEnvironment(){

            private String join(char[][] compoundName, char separator) {
                if (compoundName == null) {
                    return "";
                }
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < compoundName.length; ++i) {
                    result.append(compoundName[i]);
                    if (i >= compoundName.length - 1) continue;
                    result.append(separator);
                }
                return result.toString();
            }

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                return this.findType(this.join(compoundTypeName, '.'));
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                return this.findType(CharOperation.arrayConcat((char[][])packageName, (char[])typeName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isClass(String result) {
                if (result == null || result.isEmpty()) {
                    return false;
                }
                if (result.equals(targetName)) {
                    return true;
                }
                InputStream is = null;
                try {
                    String resourceName;
                    is = ECJEvaluatorFactory.this.loader.getResourceAsStream(result);
                    if (is == null && (is = ECJEvaluatorFactory.this.parentClassLoader.getResourceAsStream(resourceName = result.replace('.', '/') + ".class")) == null && !result.contains(".")) {
                        is = ECJEvaluatorFactory.this.parentClassLoader.getResourceAsStream("java/lang/" + resourceName);
                    }
                    boolean bl = is != null;
                    return bl;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String parent = this.join(parentPackageName, '.');
                if (this.isClass(parent)) {
                    return false;
                }
                String qualifiedName = (String)(parent.isEmpty() ? "" : parent + ".") + new String(packageName);
                return !this.isClass(qualifiedName);
            }

            public void cleanup() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NameEnvironmentAnswer findType(String className) {
                String resourceName = className.replace('.', '/') + ".class";
                InputStream is = null;
                try {
                    if (className.equals(targetName)) {
                        NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer(targetCompilationUnits[0], null);
                        return nameEnvironmentAnswer;
                    }
                    is = ECJEvaluatorFactory.this.loader.getResourceAsStream(resourceName);
                    if (is == null) {
                        is = ECJEvaluatorFactory.this.parentClassLoader.getResourceAsStream(resourceName);
                    }
                    if (is != null) {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] data = new byte[1024];
                        while (true) {
                            int nRead;
                            if ((nRead = is.read(data, 0, data.length)) == -1) {
                                buffer.flush();
                                ClassFileReader cfr = new ClassFileReader(buffer.toByteArray(), className.toCharArray(), true);
                                NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)cfr, null);
                                return nameEnvironmentAnswer;
                            }
                            buffer.write(data, 0, nRead);
                        }
                    }
                    NameEnvironmentAnswer buffer = null;
                    return buffer;
                }
                catch (IOException | ClassFormatException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (result.hasErrors()) {
                    for (CategorizedProblem problem : result.getProblems()) {
                        if (!problem.isError()) continue;
                        ECJEvaluatorFactory.this.problemList.add(problem.getMessage());
                    }
                } else {
                    for (ClassFile clazz : result.getClassFiles()) {
                        try {
                            MemJavaFileObject jfo = (MemJavaFileObject)ECJEvaluatorFactory.this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, new String(clazz.fileName()), JavaFileObject.Kind.CLASS, null);
                            OutputStream os = jfo.openOutputStream();
                            os.write(clazz.getBytes());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        };
        this.problemList.clear();
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        try {
            Compiler compiler = new Compiler(env, policy, this.compilerOptions, requestor, (IProblemFactory)problemFactory);
            compiler.compile(targetCompilationUnits);
            if (!this.problemList.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String problem : this.problemList) {
                    sb.append("\t").append(problem).append("\n");
                }
                throw new CodegenException("Compilation of " + id + " failed:\n" + source + "\n" + sb.toString());
            }
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    IOException exception = (IOException)cause;
                    throw exception;
                }
                if (cause instanceof ClassFormatException) {
                    throw new IOException(cause);
                }
            }
            throw ex;
        }
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }
}

