/*
 * Decompiled with CFR 0.152.
 */
package io.github.openfeign.querydsl.jpa.spring.repository;

import com.querydsl.core.Tuple;
import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.dml.InsertClause;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.JPQLSubQuery;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;

@NoRepositoryBean
public interface JPQLRepository<T, ID>
extends Repository<T, ID> {
    public DeleteClause<?> delete(EntityPath<T> var1);

    public <U> JPQLQuery<U> select(Expression<U> var1);

    public JPQLQuery<Tuple> select(Expression<?> ... var1);

    public <U> JPQLQuery<U> selectDistinct(Expression<U> var1);

    public JPQLQuery<Tuple> selectDistinct(Expression<?> ... var1);

    public JPQLQuery<Integer> selectOne();

    public JPQLQuery<Integer> selectZero();

    public <U> JPQLQuery<U> selectFrom(EntityPath<U> var1);

    public UpdateClause<?> update(EntityPath<T> var1);

    public InsertClause<?> insert(EntityPath<T> var1);

    default public <U> JPQLSubQuery<U> subSelect(Expression<U> expr) {
        return JPAExpressions.select(expr);
    }

    default public JPQLSubQuery<Tuple> subSelect(Expression<?> ... exprs) {
        return JPAExpressions.select(exprs);
    }

    default public <U> JPQLSubQuery<U> subSelectDistinct(Expression<U> expr) {
        return JPAExpressions.select(expr).distinct();
    }

    default public JPQLSubQuery<Tuple> subSelectDistinct(Expression<?> ... exprs) {
        return JPAExpressions.select(exprs).distinct();
    }

    default public JPQLSubQuery<Integer> subSelectZero() {
        return this.subSelect((Expression<U>)((Expression)Expressions.ZERO));
    }

    default public JPQLSubQuery<Integer> subSelectOne() {
        return this.subSelect((Expression<U>)((Expression)Expressions.ONE));
    }

    default public <U> JPQLSubQuery<U> subSelectFrom(EntityPath<U> expr) {
        return this.subSelect((Expression<U>)expr).from(expr);
    }
}

