/*
 * Decompiled with CFR 0.152.
 */
package io.github.openfeign.querydsl.jpa.spring.repository.support;

import com.querydsl.core.Tuple;
import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.dml.InsertClause;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.github.openfeign.querydsl.jpa.spring.repository.JPQLRepository;
import jakarta.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class QuerydslJpaRepositoryImpl<T, ID>
implements JPQLRepository<T, ID> {
    private final EntityInformation<T, ?> entityInformation;
    private final EntityManager entityManager;
    private final JPAQueryFactory jpaQueryFactory;

    public QuerydslJpaRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"entityManager must not be null!");
        this.entityInformation = entityInformation;
        this.entityManager = entityManager;
        this.jpaQueryFactory = new JPAQueryFactory(entityManager);
    }

    @Override
    public DeleteClause<?> delete(EntityPath<T> path) {
        return this.jpaQueryFactory.delete(path);
    }

    @Override
    public <U> JPQLQuery<U> select(Expression<U> expr) {
        return this.jpaQueryFactory.select(expr);
    }

    @Override
    public JPQLQuery<Tuple> select(Expression<?> ... exprs) {
        return this.jpaQueryFactory.select(exprs);
    }

    @Override
    public <U> JPQLQuery<U> selectDistinct(Expression<U> expr) {
        return this.jpaQueryFactory.selectDistinct(expr);
    }

    @Override
    public JPQLQuery<Tuple> selectDistinct(Expression<?> ... exprs) {
        return this.jpaQueryFactory.selectDistinct(exprs);
    }

    @Override
    public JPQLQuery<Integer> selectOne() {
        return this.jpaQueryFactory.selectOne();
    }

    @Override
    public JPQLQuery<Integer> selectZero() {
        return this.jpaQueryFactory.selectZero();
    }

    @Override
    public <U> JPQLQuery<U> selectFrom(EntityPath<U> from) {
        return this.jpaQueryFactory.selectFrom(from);
    }

    @Override
    public UpdateClause<?> update(EntityPath<T> path) {
        return this.jpaQueryFactory.update(path);
    }

    @Override
    public InsertClause<?> insert(EntityPath<T> path) {
        return this.jpaQueryFactory.insert(path);
    }
}

