/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.CloseableIterator;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.TransformingIterator;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;
import org.jetbrains.annotations.Nullable;

class EclipseLinkHandler
implements QueryHandler {
    EclipseLinkHandler() {
    }

    @Override
    public void addEntity(Query query, String alias, Class<?> type) {
    }

    @Override
    public void addScalar(Query query, String alias, Class<?> type) {
    }

    @Override
    public boolean createNativeQueryTyped() {
        return true;
    }

    @Override
    public <T> CloseableIterator<T> iterate(Query query, FactoryExpression<?> projection) {
        boolean canUseCursor = false;
        try {
            canUseCursor = query.unwrap(Query.class) instanceof JpaQuery;
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        Iterator iterator = null;
        Closeable closeable = null;
        if (canUseCursor) {
            query.setHint("eclipselink.cursor", (Object)"True");
            final Cursor cursor = (Cursor)query.getSingleResult();
            final int pageSize = cursor.getPageSize();
            closeable = new Closeable(){

                @Override
                public void close() throws IOException {
                    cursor.close();
                }
            };
            iterator = new Iterator<T>(){
                private int rowsSinceLastClear = 0;

                @Override
                public boolean hasNext() {
                    return cursor.hasNext();
                }

                @Override
                public T next() {
                    if (this.rowsSinceLastClear++ == pageSize) {
                        this.rowsSinceLastClear = 0;
                        cursor.clear();
                    }
                    return cursor.next();
                }
            };
        } else {
            iterator = query.getResultList().iterator();
        }
        if (projection != null) {
            return new TransformingIterator(iterator, closeable, projection);
        }
        return CloseableIterator.of(iterator, closeable);
    }

    @Override
    public <T> Stream<T> stream(Query query, @Nullable FactoryExpression<?> projection) {
        Stream resultStream = query.getResultStream();
        if (projection != null) {
            return resultStream.map(element -> {
                Object[] objectArray;
                if (element.getClass().isArray()) {
                    objectArray = element;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = element;
                }
                return projection.newInstance(objectArray);
            });
        }
        return resultStream;
    }

    @Override
    public boolean transform(Query query, FactoryExpression<?> projection) {
        return false;
    }

    @Override
    public boolean wrapEntityProjections() {
        return false;
    }
}

