/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.maven;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Serializer;
import com.querydsl.core.util.StringUtils;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.MetadataExporterConfig;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.CustomType;
import com.querydsl.sql.codegen.support.NumericMapping;
import com.querydsl.sql.codegen.support.RenameMapping;
import com.querydsl.sql.codegen.support.TypeMapping;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public abstract class AbstractMetaDataExportMojo
extends AbstractMojo
implements MetadataExporterConfig {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private WagonManager wagonManager;
    @Parameter
    private String server;
    @Parameter(required=true)
    private String jdbcDriver;
    @Parameter(required=true)
    private String jdbcUrl;
    @Parameter
    private String jdbcUser;
    @Parameter
    private String jdbcPassword;
    @Parameter(defaultValue="Q")
    private String namePrefix;
    @Parameter(defaultValue="")
    private String nameSuffix;
    @Parameter(defaultValue="")
    private String beanPrefix;
    @Parameter(defaultValue="")
    private String beanSuffix;
    @Parameter(required=true)
    private String packageName;
    @Parameter
    private String beanPackageName;
    @Parameter
    private String schemaPattern;
    @Parameter
    private String catalogPattern;
    @Parameter
    private String tableNamePattern;
    @Parameter(required=true)
    private String targetFolder;
    @Parameter
    private String beansTargetFolder;
    @Parameter
    private String namingStrategyClass;
    @Parameter
    private String beanSerializerClass;
    @Parameter
    private String serializerClass;
    @Parameter(defaultValue="false")
    private boolean exportBeans;
    @Parameter
    private String[] beanInterfaces;
    @Parameter(defaultValue="false")
    private boolean beanAddToString;
    @Parameter(defaultValue="false")
    private boolean beanAddFullConstructor;
    @Parameter(defaultValue="false")
    private boolean beanPrintSupertype;
    @Parameter(defaultValue="false")
    private boolean innerClassesForKeys;
    @Parameter(defaultValue="false")
    private boolean validationAnnotations;
    @Parameter(defaultValue="false")
    private boolean columnAnnotations;
    @Parameter
    private String[] customTypes;
    @Parameter
    private TypeMapping[] typeMappings;
    @Parameter
    private NumericMapping[] numericMappings;
    @Parameter
    private RenameMapping[] renameMappings;
    @Parameter(defaultValue="false")
    private boolean createScalaSources;
    @Parameter(defaultValue="false")
    private boolean schemaToPackage;
    @Parameter(defaultValue="false")
    private boolean lowerCase;
    @Parameter(defaultValue="true")
    private boolean exportTables;
    @Parameter(defaultValue="true")
    private boolean exportViews;
    @Parameter(defaultValue="false")
    private boolean exportAll;
    @Parameter(defaultValue="true")
    private boolean exportPrimaryKeys;
    @Parameter(defaultValue="true")
    private boolean exportForeignKeys;
    @Parameter(defaultValue="true")
    private boolean exportDirectForeignKeys;
    @Parameter(defaultValue="true")
    private boolean exportInverseForeignKeys;
    @Parameter
    private String columnComparatorClass;
    @Parameter
    private String tableTypesToExport;
    @Parameter
    private String[] imports;
    @Parameter(defaultValue="false", property="maven.querydsl.skip")
    private boolean skip;
    private String generatedAnnotationClass;
    private static final Pattern BLANK_VALUE_PATTERN = Pattern.compile("(^|,)BLANK(,|$)", 2);
    private static final String BLANK_VALUE_REPLACEMENT = "$1$2";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.targetFolder);
        } else {
            this.project.addCompileSourceRoot(this.targetFolder);
        }
        if (this.skip) {
            return;
        }
        try {
            String password;
            String user;
            if (this.createScalaSources) {
                if (this.serializerClass == null) {
                    this.serializerClass = "com.querydsl.scala.sql.ScalaMetaDataSerializer";
                }
                if (this.exportBeans && this.beanSerializerClass == null) {
                    this.beanSerializerClass = "com.querydsl.scala.ScalaBeanSerializer";
                }
            }
            MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)this);
            Class.forName(this.jdbcDriver);
            if (this.server == null) {
                user = this.jdbcUser;
                password = this.jdbcPassword;
            } else {
                AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.server);
                if (info == null) {
                    throw new MojoExecutionException("No authentication info for server " + this.server);
                }
                user = info.getUserName();
                if (user == null) {
                    throw new MojoExecutionException("Missing username from server " + this.server);
                }
                password = info.getPassword();
                if (password == null) {
                    throw new MojoExecutionException("Missing password from server " + this.server);
                }
            }
            try (Connection conn = DriverManager.getConnection(this.jdbcUrl, user, password);){
                exporter.export(conn.getMetaData());
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract boolean isForTest();

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public void setBeanInterfaces(String[] beanInterfaces) {
        this.beanInterfaces = beanInterfaces;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setBeanPackageName(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setCatalogPattern(String catalogPattern) {
        this.catalogPattern = catalogPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setNamingStrategyClass(String namingStrategyClass) {
        this.namingStrategyClass = namingStrategyClass;
    }

    public void setBeanSerializerClass(String beanSerializerClass) {
        this.beanSerializerClass = beanSerializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setCustomTypes(String[] customTypes) {
        this.customTypes = customTypes;
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setTypeMappings(TypeMapping[] typeMappings) {
        this.typeMappings = typeMappings;
    }

    public void setNumericMappings(NumericMapping[] numericMappings) {
        this.numericMappings = numericMappings;
    }

    public void setRenameMappings(RenameMapping[] renameMappings) {
        this.renameMappings = renameMappings;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setGeneratedAnnotationClass(String generatedAnnotationClass) {
        this.generatedAnnotationClass = generatedAnnotationClass;
    }

    private static String emptyIfSetToBlank(String value) {
        boolean setToBlank = value == null || value.equalsIgnoreCase("BLANK");
        return setToBlank ? "" : value;
    }

    private static String processBlankValues(String value) {
        if (value == null) {
            return null;
        }
        return BLANK_VALUE_PATTERN.matcher(value).replaceAll(BLANK_VALUE_REPLACEMENT);
    }

    public String getNamePrefix() {
        return AbstractMetaDataExportMojo.emptyIfSetToBlank(this.namePrefix);
    }

    public String getNameSuffix() {
        return StringUtils.nullToEmpty((String)this.nameSuffix);
    }

    public String getBeanPrefix() {
        return StringUtils.nullToEmpty((String)this.beanPrefix);
    }

    public String getBeanSuffix() {
        return StringUtils.nullToEmpty((String)this.beanSuffix);
    }

    public File getBeansTargetFolder() {
        if (this.beansTargetFolder != null) {
            return new File(this.beansTargetFolder);
        }
        return null;
    }

    public File getTargetFolder() {
        return new File(this.targetFolder);
    }

    public boolean isCreateScalaSources() {
        return this.createScalaSources;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getBeanPackageName() {
        return this.beanPackageName;
    }

    public boolean isInnerClassesForKeys() {
        return this.innerClassesForKeys;
    }

    public Class<? extends NamingStrategy> getNamingStrategyClass() {
        if (this.namingStrategyClass == null) {
            return null;
        }
        try {
            return Class.forName(this.namingStrategyClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSchemaPattern() {
        return AbstractMetaDataExportMojo.processBlankValues(this.schemaPattern);
    }

    public String getCatalogPattern() {
        return this.catalogPattern;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public boolean isColumnAnnotations() {
        return this.columnAnnotations;
    }

    public boolean isValidationAnnotations() {
        return this.validationAnnotations;
    }

    public boolean isSchemaToPackage() {
        return this.schemaToPackage;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public boolean isExportTables() {
        return this.exportTables;
    }

    public boolean isExportViews() {
        return this.exportViews;
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public boolean isExportPrimaryKeys() {
        return this.exportPrimaryKeys;
    }

    public boolean isExportForeignKeys() {
        return this.exportForeignKeys;
    }

    public boolean isExportDirectForeignKeys() {
        return this.exportDirectForeignKeys;
    }

    public boolean isExportInverseForeignKeys() {
        return this.exportInverseForeignKeys;
    }

    public Charset getSourceEncoding() {
        String sourceEncoding = (String)this.project.getProperties().get("project.build.sourceEncoding");
        if (sourceEncoding != null) {
            return Charset.forName(sourceEncoding);
        }
        return StandardCharsets.UTF_8;
    }

    public String getTableTypesToExport() {
        return this.tableTypesToExport;
    }

    public List<String> getImports() {
        if (this.imports == null) {
            return null;
        }
        return Arrays.asList(this.imports);
    }

    public String getGeneratedAnnotationClass() {
        return this.generatedAnnotationClass;
    }

    public Class<? extends BeanSerializer> getBeanSerializerClass() {
        if (this.exportBeans && this.beanSerializerClass != null) {
            try {
                return Class.forName(this.beanSerializerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public boolean isExportBeans() {
        return this.exportBeans;
    }

    public String[] getBeanInterfaces() {
        return this.beanInterfaces;
    }

    public boolean isBeanAddToString() {
        return this.beanAddToString;
    }

    public boolean isBeanAddFullConstructor() {
        return this.beanAddFullConstructor;
    }

    public boolean isBeanPrintSupertype() {
        return this.beanPrintSupertype;
    }

    public List<CustomType> getCustomTypes() {
        if (this.customTypes == null) {
            return null;
        }
        return Arrays.stream(this.customTypes).map(CustomType::new).collect(Collectors.toList());
    }

    public List<TypeMapping> getTypeMappings() {
        if (this.typeMappings == null) {
            return null;
        }
        return Arrays.stream(this.typeMappings).collect(Collectors.toList());
    }

    public List<NumericMapping> getNumericMappings() {
        if (this.numericMappings == null) {
            return null;
        }
        return Arrays.stream(this.numericMappings).collect(Collectors.toList());
    }

    public List<RenameMapping> getRenameMappings() {
        if (this.renameMappings == null) {
            return null;
        }
        return Arrays.stream(this.renameMappings).collect(Collectors.toList());
    }

    public Class<? extends Comparator<Property>> getColumnComparatorClass() {
        if (this.columnComparatorClass == null) {
            return null;
        }
        try {
            return Class.forName(this.columnComparatorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends Serializer> getSerializerClass() {
        if (this.serializerClass == null) {
            return null;
        }
        try {
            return Class.forName(this.serializerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

