/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.dml;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.dml.SQLMergeUsingClause;
import com.querydsl.sql.types.Null;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLMergeUsingCase {
    private final SQLMergeUsingClause parentClause;
    private final Boolean matched;
    private final List<Predicate> matchAnds = new ArrayList<Predicate>();
    private Map<Path<?>, Expression<?>> updates = new LinkedHashMap();
    private MergeOperation mergeOperation;

    public SQLMergeUsingCase(SQLMergeUsingClause parentClause, Boolean matched) {
        this.parentClause = parentClause;
        this.matched = matched;
    }

    public SQLMergeUsingCase and(Predicate predicate) {
        this.matchAnds.add(predicate);
        return this;
    }

    public SQLMergeUsingClause thenInsert(List<? extends Path<?>> paths, List<?> values) {
        this.mergeOperation = MergeOperation.INSERT;
        this.set(paths, values);
        return this.parentClause.addWhen(this);
    }

    public SQLMergeUsingClause thenUpdate(List<? extends Path<?>> paths, List<?> values) {
        this.mergeOperation = MergeOperation.UPDATE;
        this.set(paths, values);
        return this.parentClause.addWhen(this);
    }

    public SQLMergeUsingClause thenDelete() {
        this.mergeOperation = MergeOperation.DELETE;
        return this.parentClause.addWhen(this);
    }

    private void set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) instanceof Expression) {
                this.updates.put(paths.get(i), (Expression)values.get(i));
                continue;
            }
            if (values.get(i) != null) {
                this.updates.put(paths.get(i), (Expression<?>)ConstantImpl.create(values.get(i)));
                continue;
            }
            this.updates.put(paths.get(i), (Expression<?>)Null.CONSTANT);
        }
    }

    public Boolean getMatched() {
        return this.matched;
    }

    public List<Predicate> getMatchAnds() {
        return this.matchAnds;
    }

    public MergeOperation getMergeOperation() {
        return this.mergeOperation;
    }

    public Map<Path<?>, Expression<?>> getUpdates() {
        return this.updates;
    }

    public static enum MergeOperation {
        UPDATE,
        INSERT,
        DELETE;

    }
}

