/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.dml;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.util.ResultSetAdapter;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLMergeUsingCase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class SQLMergeUsingClause
extends AbstractSQLClause<SQLMergeUsingClause> {
    protected static final Logger logger = Logger.getLogger(SQLMergeUsingClause.class.getName());
    protected final RelationalPath<?> entity;
    protected final QueryMetadata metadata = new DefaultQueryMetadata();
    protected SimpleExpression<?> usingExpression;
    protected BooleanBuilder usingOn = new BooleanBuilder();
    protected List<SQLMergeUsingCase> whens = new ArrayList<SQLMergeUsingCase>();
    protected transient String queryString;
    protected transient List<Object> constants;

    public SQLMergeUsingClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLMergeUsingClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration, connection);
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLMergeUsingClause(Supplier<Connection> connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration, connection);
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLMergeUsingClause(Connection connection, Configuration configuration, RelationalPath<?> entity, SimpleExpression<?> usingExpression) {
        super(configuration, connection);
        this.entity = entity;
        this.usingExpression = usingExpression;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLMergeUsingClause(Supplier<Connection> connection, Configuration configuration, RelationalPath<?> entity, SimpleExpression<?> usingExpression) {
        super(configuration, connection);
        this.entity = entity;
        this.usingExpression = usingExpression;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLMergeUsingClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLMergeUsingClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    @Override
    public void clear() {
        this.usingExpression = null;
        this.whens.clear();
        this.usingOn = new BooleanBuilder();
    }

    @Nullable
    public <T> T executeWithKey(Path<T> path) {
        return this.executeWithKey(path.getType(), path);
    }

    public <T> T executeWithKey(Class<T> type) {
        return this.executeWithKey(type, null);
    }

    protected <T> T executeWithKey(Class<T> type, @Nullable Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            if (rs.next()) {
                T t = this.configuration.get(rs, path, 1, type);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException e) {
            throw this.configuration.translate(e);
        }
        finally {
            this.close(rs);
        }
    }

    public <T> List<T> executeWithKeys(Path<T> path) {
        return this.executeWithKeys(path.getType(), path);
    }

    public <T> List<T> executeWithKeys(Class<T> type) {
        return this.executeWithKeys(type, null);
    }

    protected <T> List<T> executeWithKeys(Class<T> type, @Nullable Path<T> path) {
        ResultSet rs = null;
        try {
            rs = this.executeWithKeys();
            ArrayList<T> rv = new ArrayList<T>();
            while (rs.next()) {
                rv.add(this.configuration.get(rs, path, 1, type));
            }
            ArrayList<T> arrayList = rv;
            return arrayList;
        }
        catch (SQLException e) {
            throw this.configuration.translate(e);
        }
        finally {
            if (rs != null) {
                this.close(rs);
            }
            this.reset();
        }
    }

    public ResultSet executeWithKeys() {
        this.context = this.startContext(this.connection(), this.metadata, this.entity);
        try {
            PreparedStatement stmt = null;
            stmt = this.createStatement(true);
            this.listeners.notifyMergeUsing(this.entity, this.metadata, this.usingExpression, this.usingOn.getValue(), this.whens);
            this.listeners.preExecute(this.context);
            stmt.executeUpdate();
            this.listeners.executed(this.context);
            final PreparedStatement stmt2 = stmt;
            ResultSet rs = stmt.getGeneratedKeys();
            return new ResultSetAdapter(rs){

                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt2.close();
                        SQLMergeUsingClause.this.reset();
                        SQLMergeUsingClause.this.endContext(SQLMergeUsingClause.this.context);
                    }
                }
            };
        }
        catch (SQLException e) {
            this.onException(this.context, e);
            this.reset();
            this.endContext(this.context);
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
    }

    public long execute() {
        return this.executeNativeMerge();
    }

    @Override
    public List<SQLBindings> getSQL() {
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeMergeUsing(this.metadata, this.entity, this.usingExpression, this.usingOn.getValue(), this.whens);
        return Collections.singletonList(this.createBindings(this.metadata, serializer));
    }

    @Override
    public int getBatchCount() {
        return 0;
    }

    protected void addListeners(AbstractSQLClause<?> clause) {
        for (SQLListener sQLListener : this.listeners.getListeners()) {
            clause.addListener(sQLListener);
        }
    }

    protected PreparedStatement createStatement(boolean withKeys) throws SQLException {
        boolean addBatches = !this.configuration.getUseLiterals();
        this.listeners.preRender(this.context);
        SQLSerializer serializer = this.createSerializer();
        PreparedStatement stmt = null;
        serializer.serializeMergeUsing(this.metadata, this.entity, this.usingExpression, this.usingOn.getValue(), this.whens);
        this.context.addSQL(this.createBindings(this.metadata, serializer));
        this.listeners.rendered(this.context);
        this.listeners.prePrepare(this.context);
        stmt = this.prepareStatementAndSetParameters(serializer, withKeys);
        this.context.addPreparedStatement(stmt);
        this.listeners.prepared(this.context);
        return stmt;
    }

    protected PreparedStatement prepareStatementAndSetParameters(SQLSerializer serializer, boolean withKeys) throws SQLException {
        this.listeners.prePrepare(this.context);
        this.queryString = serializer.toString();
        this.constants = serializer.getConstants();
        this.logQuery(logger, this.queryString, this.constants);
        PreparedStatement stmt = this.connection().prepareStatement(this.queryString);
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        this.context.addPreparedStatement(stmt);
        this.listeners.prepared(this.context);
        return stmt;
    }

    protected long executeNativeMerge() {
        this.context = this.startContext(this.connection(), this.metadata, this.entity);
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement(false);
            this.listeners.notifyMergeUsing(this.entity, this.metadata, this.usingExpression, this.usingOn.getValue(), this.whens);
            this.listeners.preExecute(this.context);
            int rc = stmt.executeUpdate();
            this.listeners.executed(this.context);
            long l = rc;
            return l;
        }
        catch (SQLException e) {
            this.onException(this.context, e);
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
            this.reset();
            this.endContext(this.context);
        }
    }

    public SQLMergeUsingClause on(Predicate ... conditions) {
        for (Predicate condition : conditions) {
            this.on(condition);
        }
        return this;
    }

    public SQLMergeUsingClause on(Predicate condition) {
        this.usingOn.and(condition);
        return this;
    }

    public SQLMergeUsingClause using(SimpleExpression<?> usingExpression) {
        this.usingExpression = usingExpression;
        return this;
    }

    public SQLMergeUsingClause addWhen(SQLMergeUsingCase mergeCase) {
        this.whens.add(mergeCase);
        return this;
    }

    public SQLMergeUsingCase whenMatched() {
        return new SQLMergeUsingCase(this, true);
    }

    public SQLMergeUsingCase whenNotMatched() {
        return new SQLMergeUsingCase(this, false);
    }

    public String toString() {
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeMergeUsing(this.metadata, this.entity, this.usingExpression, this.usingOn.getValue(), this.whens);
        return serializer.toString();
    }
}

