/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.CollectionUtils;
import com.querydsl.sql.RelationalPath;
import java.util.Collections;
import java.util.Set;

public final class RelationalPathExtractor
implements Visitor<Set<RelationalPath<?>>, Set<RelationalPath<?>>> {
    public static final RelationalPathExtractor DEFAULT = new RelationalPathExtractor();

    public static Set<RelationalPath<?>> extract(QueryMetadata md) {
        Set known = Collections.emptySet();
        known = DEFAULT.visitJoins(md.getJoins(), known);
        if (md.getProjection() != null) {
            known = (Set)md.getProjection().accept((Visitor)DEFAULT, known);
        }
        for (OrderSpecifier o : md.getOrderBy()) {
            known = (Set)o.getTarget().accept((Visitor)DEFAULT, (Object)known);
        }
        for (Expression g : md.getGroupBy()) {
            known = (Set)g.accept((Visitor)DEFAULT, (Object)known);
        }
        if (md.getHaving() != null) {
            known = (Set)md.getHaving().accept((Visitor)DEFAULT, (Object)known);
        }
        if (md.getWhere() != null) {
            known = (Set)md.getWhere().accept((Visitor)DEFAULT, (Object)known);
        }
        return known;
    }

    public static Set<RelationalPath<?>> extract(Expression<?> expr) {
        return (Set)expr.accept((Visitor)DEFAULT, Collections.emptySet());
    }

    public Set<RelationalPath<?>> visit(Constant<?> expr, Set<RelationalPath<?>> known) {
        return known;
    }

    public Set<RelationalPath<?>> visit(FactoryExpression<?> expr, Set<RelationalPath<?>> known) {
        for (Expression arg : expr.getArgs()) {
            known = (Set)arg.accept((Visitor)this, known);
        }
        return known;
    }

    public Set<RelationalPath<?>> visit(Operation<?> expr, Set<RelationalPath<?>> known) {
        for (Expression arg : expr.getArgs()) {
            known = (Set)arg.accept((Visitor)this, known);
        }
        return known;
    }

    public Set<RelationalPath<?>> visit(ParamExpression<?> expr, Set<RelationalPath<?>> known) {
        return known;
    }

    public Set<RelationalPath<?>> visit(Path<?> expr, Set<RelationalPath<?>> known) {
        if (expr.getMetadata().isRoot()) {
            if (expr instanceof RelationalPath) {
                RelationalPath path = (RelationalPath)expr;
                known = CollectionUtils.add((Set)known, (Object)path);
            }
        } else {
            known = (Set)expr.getMetadata().getParent().accept((Visitor)this, known);
        }
        return known;
    }

    public Set<RelationalPath<?>> visit(SubQueryExpression<?> expr, Set<RelationalPath<?>> known) {
        Set old = known;
        QueryMetadata md = expr.getMetadata();
        known = this.visitJoins(md.getJoins(), known);
        if (md.getProjection() != null) {
            known = (Set)md.getProjection().accept((Visitor)this, known);
        }
        for (OrderSpecifier o : md.getOrderBy()) {
            known = (Set)o.getTarget().accept((Visitor)this, (Object)known);
        }
        for (Expression g : md.getGroupBy()) {
            known = (Set)g.accept((Visitor)this, (Object)known);
        }
        if (md.getHaving() != null) {
            known = (Set)md.getHaving().accept((Visitor)this, (Object)known);
        }
        if (md.getWhere() != null) {
            md.getWhere().accept((Visitor)this, (Object)known);
        }
        return old;
    }

    public Set<RelationalPath<?>> visit(TemplateExpression<?> expr, Set<RelationalPath<?>> known) {
        for (Object arg : expr.getArgs()) {
            if (!(arg instanceof Expression)) continue;
            known = (Set)((Expression)arg).accept((Visitor)this, known);
        }
        return known;
    }

    private Set<RelationalPath<?>> visitJoins(Iterable<JoinExpression> joins, Set<RelationalPath<?>> known) {
        for (JoinExpression j : joins) {
            known = (Set)j.getTarget().accept((Visitor)this, known);
            if (j.getCondition() == null) continue;
            known = (Set)j.getCondition().accept((Visitor)this, (Object)known);
        }
        return known;
    }

    private RelationalPathExtractor() {
    }
}

