/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.ddl;

import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.ddl.CreateTableClause;
import com.querydsl.sql.ddl.ForeignKeyData;
import java.util.List;

public class ForeignKeyBuilder {
    private final List<ForeignKeyData> foreignKeys;
    private final CreateTableClause clause;
    private final String name;
    private final String[] foreignColumns;
    private final SQLTemplates templates;

    public ForeignKeyBuilder(CreateTableClause clause, SQLTemplates templates, List<ForeignKeyData> foreignKeys, String name, String[] columns) {
        this.clause = clause;
        this.templates = templates;
        this.foreignKeys = foreignKeys;
        this.name = name;
        this.foreignColumns = (String[])columns.clone();
    }

    public CreateTableClause references(String table, String ... parentColumns) {
        ForeignKeyData foreignKey = new ForeignKeyData(this.name, this.templates.quoteIdentifier(table));
        for (int i = 0; i < parentColumns.length; ++i) {
            foreignKey.add(this.templates.quoteIdentifier(this.foreignColumns[i]), this.templates.quoteIdentifier(parentColumns[i]));
        }
        this.foreignKeys.add(foreignKey);
        return this.clause;
    }
}

