/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.types;

import com.querydsl.sql.types.AbstractJSR310DateTimeType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public class InstantType
extends AbstractJSR310DateTimeType<Instant> {
    public InstantType() {
        super(93);
    }

    public InstantType(int type) {
        super(type);
    }

    @Override
    public String getLiteral(Instant value) {
        return dateTimeFormatter.format(Timestamp.from(value).toLocalDateTime());
    }

    @Override
    public Class<Instant> getReturnedClass() {
        return Instant.class;
    }

    @Override
    @Nullable
    public Instant getValue(ResultSet rs, int startIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(startIndex);
        return timestamp != null ? timestamp.toInstant() : null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, Instant value) throws SQLException {
        st.setTimestamp(startIndex, Timestamp.from(value));
    }
}

